/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.provider.jdbc.internal.AbstractJdbcStorageAccessor;
import net.javacrumbs.shedlock.support.annotation.NonNull;

class JdbcStorageAccessor
extends AbstractJdbcStorageAccessor {
    private final DataSource dataSource;

    JdbcStorageAccessor(@NonNull DataSource dataSource, @NonNull String tableName) {
        super(tableName);
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource can not be null");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected <T> T executeCommand(String sql, AbstractJdbcStorageAccessor.SqlFunction<PreparedStatement, T> body, BiFunction<String, SQLException, T> exceptionHandler) {
        try (Connection connection = this.dataSource.getConnection();){
            Object object;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    connection.setAutoCommit(true);
                    object = body.apply((Object)statement);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return (T)object;
        }
        catch (SQLException e) {
            return (T)exceptionHandler.apply(sql, e);
        }
    }
}

