/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc;

import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.provider.jdbc.internal.AbstractJdbcStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;
import org.jetbrains.annotations.NotNull;

class JdbcStorageAccessor
extends AbstractJdbcStorageAccessor {
    JdbcStorageAccessor(@NotNull DataSource dataSource, @NotNull String tableName) {
        super(dataSource, tableName);
    }

    protected void handleInsertionException(String sql, SQLException e) {
        if (!(e instanceof SQLIntegrityConstraintViolationException)) {
            this.logger.debug("Exception thrown when inserting record", (Throwable)e);
        }
    }

    protected void handleUpdateException(String sql, SQLException e) {
        throw new LockException("Unexpected exception when locking", (Throwable)e);
    }

    protected void handleUnlockException(String sql, SQLException e) {
        throw new LockException("Unexpected exception when unlocking", (Throwable)e);
    }
}

