/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Objects;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;

class JdbcStorageAccessor
extends AbstractStorageAccessor {
    private final DataSource dataSource;
    private final String tableName;

    JdbcStorageAccessor(DataSource jdbcTemplate, String tableName) {
        this.dataSource = Objects.requireNonNull(jdbcTemplate, "dataSource can not be null");
        this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean insertRecord(LockConfiguration lockConfiguration) {
        try (Connection connection2 = this.dataSource.getConnection();
             PreparedStatement statement = connection2.prepareStatement("INSERT INTO " + this.tableName + "(name, lock_until, locked_at, locked_by) VALUES(?, ?, ?, ?)");){
            statement.setString(1, lockConfiguration.getName());
            statement.setTimestamp(2, Timestamp.from(lockConfiguration.getLockUntil()));
            statement.setTimestamp(3, Timestamp.from(Instant.now()));
            statement.setString(4, this.getHostname());
            int insertedRows = statement.executeUpdate();
            if (insertedRows <= 0) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLIntegrityConstraintViolationException connection2) {
            return false;
        }
        catch (SQLException e) {
            this.logger.debug("Exception thrown when inserting record", (Throwable)e);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public boolean updateRecord(LockConfiguration lockConfiguration) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void unlock(LockConfiguration lockConfiguration) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("UPDATE " + this.tableName + " SET lock_until = ? WHERE name = ?");){
            statement.setTimestamp(1, Timestamp.from(Instant.now()));
            statement.setString(2, lockConfiguration.getName());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new LockException("Unexpected exception when unlocking", (Throwable)e);
        }
    }
}

