/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.HashMap;
import java.util.Map;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.SqlStatementsSource;
import net.javacrumbs.shedlock.support.annotation.NonNull;

class OracleServerTimeStatementsSource
extends SqlStatementsSource {
    private final String now = "SYS_EXTRACT_UTC(SYSTIMESTAMP)";
    private final String lockAtMostFor = "SYS_EXTRACT_UTC(SYSTIMESTAMP) + :lockAtMostFor";
    private static final long millisecondsInDay = 86400000L;

    OracleServerTimeStatementsSource(JdbcTemplateLockProvider.Configuration configuration) {
        super(configuration);
    }

    @Override
    String getInsertStatement() {
        return "INSERT INTO " + this.tableName() + "(" + this.name() + ", " + this.lockUntil() + ", " + this.lockedAt() + ", " + this.lockedBy() + ") VALUES(:name, " + "SYS_EXTRACT_UTC(SYSTIMESTAMP) + :lockAtMostFor" + ", " + "SYS_EXTRACT_UTC(SYSTIMESTAMP)" + ", :lockedBy)";
    }

    @Override
    public String getUpdateStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = " + "SYS_EXTRACT_UTC(SYSTIMESTAMP) + :lockAtMostFor" + ", " + this.lockedAt() + " = " + "SYS_EXTRACT_UTC(SYSTIMESTAMP)" + ", " + this.lockedBy() + " = :lockedBy WHERE " + this.lockUntil() + " <= " + "SYS_EXTRACT_UTC(SYSTIMESTAMP)";
    }

    @Override
    public String getUnlockStatement() {
        String lockAtLeastFor = this.lockedAt() + " + :lockAtLeastFor";
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = CASE WHEN " + lockAtLeastFor + " > " + "SYS_EXTRACT_UTC(SYSTIMESTAMP)" + " THEN " + lockAtLeastFor + " ELSE " + "SYS_EXTRACT_UTC(SYSTIMESTAMP)" + " END WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy";
    }

    @Override
    public String getExtendStatement() {
        return "UPDATE " + this.tableName() + " SET " + this.lockUntil() + " = " + "SYS_EXTRACT_UTC(SYSTIMESTAMP) + :lockAtMostFor" + " WHERE " + this.name() + " = :name AND " + this.lockedBy() + " = :lockedBy AND " + this.lockUntil() + " > " + "SYS_EXTRACT_UTC(SYSTIMESTAMP)";
    }

    @Override
    @NonNull
    Map<String, Object> params(@NonNull LockConfiguration lockConfiguration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", lockConfiguration.getName());
        params.put("lockedBy", this.configuration.getLockedByValue());
        params.put("lockAtMostFor", (double)lockConfiguration.getLockAtMostFor().toMillis() / 8.64E7);
        params.put("lockAtLeastFor", (double)lockConfiguration.getLockAtLeastFor().toMillis() / 8.64E7);
        return params;
    }
}

