/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.Map;
import java.util.Objects;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateLockProvider;
import net.javacrumbs.shedlock.provider.jdbctemplate.SqlStatementsSource;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

class JdbcTemplateStorageAccessor
extends AbstractStorageAccessor {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final SqlStatementsSource sqlStatementsSource;

    JdbcTemplateStorageAccessor(@NonNull JdbcTemplateLockProvider.Configuration configuration) {
        Objects.requireNonNull(configuration, "configuration can not be null");
        this.jdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)configuration.getJdbcTemplate());
        this.sqlStatementsSource = SqlStatementsSource.create(configuration);
        PlatformTransactionManager transactionManager = configuration.getTransactionManager() != null ? configuration.getTransactionManager() : new DataSourceTransactionManager(configuration.getJdbcTemplate().getDataSource());
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
    }

    public boolean insertRecord(@NonNull LockConfiguration lockConfiguration) {
        try {
            String sql = this.sqlStatementsSource.getInsertStatement();
            return (Boolean)this.transactionTemplate.execute(status -> {
                Map<String, Object> params = this.params(lockConfiguration);
                int insertedRows = this.jdbcTemplate.update(sql, params);
                return insertedRows > 0;
            });
        }
        catch (DuplicateKeyException e) {
            return false;
        }
        catch (DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
            this.logger.warn("Unexpected exception", e);
            return false;
        }
    }

    public boolean updateRecord(@NonNull LockConfiguration lockConfiguration) {
        String sql = this.sqlStatementsSource.getUpdateStatement();
        try {
            return (Boolean)this.transactionTemplate.execute(status -> {
                int updatedRows = this.jdbcTemplate.update(sql, this.params(lockConfiguration));
                return updatedRows > 0;
            });
        }
        catch (DataIntegrityViolationException e) {
            this.logger.warn("Unexpected exception", (Throwable)e);
            return false;
        }
    }

    public boolean extend(@NonNull LockConfiguration lockConfiguration) {
        String sql = this.sqlStatementsSource.getExtendStatement();
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return (Boolean)this.transactionTemplate.execute(status -> {
            int updatedRows = this.jdbcTemplate.update(sql, this.params(lockConfiguration));
            return updatedRows > 0;
        });
    }

    public void unlock(final @NonNull LockConfiguration lockConfiguration) {
        final String sql = this.sqlStatementsSource.getUnlockStatement();
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JdbcTemplateStorageAccessor.this.jdbcTemplate.update(sql, JdbcTemplateStorageAccessor.this.params(lockConfiguration));
            }
        });
    }

    @NonNull
    private Map<String, Object> params(@NonNull LockConfiguration lockConfiguration) {
        return this.sqlStatementsSource.params(lockConfiguration);
    }
}

