/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.util.Objects;
import java.util.TimeZone;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.provider.jdbctemplate.JdbcTemplateStorageAccessor;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class JdbcTemplateLockProvider
extends StorageBasedLockProvider {
    private static final String DEFAULT_TABLE_NAME = "shedlock";

    public JdbcTemplateLockProvider(@NotNull JdbcTemplate jdbcTemplate) {
        this(jdbcTemplate, (PlatformTransactionManager)null);
    }

    public JdbcTemplateLockProvider(@NotNull JdbcTemplate jdbcTemplate, @Nullable PlatformTransactionManager transactionManager) {
        this(jdbcTemplate, transactionManager, DEFAULT_TABLE_NAME);
    }

    public JdbcTemplateLockProvider(@NotNull JdbcTemplate jdbcTemplate, @NotNull String tableName) {
        this(jdbcTemplate, null, tableName);
    }

    public JdbcTemplateLockProvider(@NotNull DataSource dataSource) {
        this(new JdbcTemplate(dataSource));
    }

    public JdbcTemplateLockProvider(@NotNull DataSource dataSource, @NotNull String tableName) {
        this(new JdbcTemplate(dataSource), tableName);
    }

    public JdbcTemplateLockProvider(@NotNull JdbcTemplate jdbcTemplate, @Nullable PlatformTransactionManager transactionManager, @NotNull String tableName) {
        this(Configuration.builder().withJdbcTemplate(jdbcTemplate).withTransactionManager(transactionManager).withTableName(tableName).build());
    }

    public JdbcTemplateLockProvider(@NotNull Configuration configuration) {
        super((StorageAccessor)new JdbcTemplateStorageAccessor(configuration));
    }

    public static class Configuration {
        private final JdbcTemplate jdbcTemplate;
        private final PlatformTransactionManager transactionManager;
        private final String tableName;
        private final TimeZone timeZone;

        Configuration(@NotNull JdbcTemplate jdbcTemplate, @Nullable PlatformTransactionManager transactionManager, @NotNull String tableName, @Nullable TimeZone timeZone) {
            this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate, "jdbcTemplate can not be null");
            this.transactionManager = transactionManager;
            this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
            this.timeZone = timeZone;
        }

        public JdbcTemplate getJdbcTemplate() {
            return this.jdbcTemplate;
        }

        public PlatformTransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public String getTableName() {
            return this.tableName;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private JdbcTemplate jdbcTemplate;
            private PlatformTransactionManager transactionManager;
            private String tableName = "shedlock";
            private TimeZone timeZone;

            public Builder withJdbcTemplate(@NotNull JdbcTemplate jdbcTemplate) {
                this.jdbcTemplate = jdbcTemplate;
                return this;
            }

            public Builder withTransactionManager(PlatformTransactionManager transactionManager) {
                this.transactionManager = transactionManager;
                return this;
            }

            public Builder withTableName(@NotNull String tableName) {
                this.tableName = tableName;
                return this;
            }

            public Builder withTimeZone(TimeZone timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            public Configuration build() {
                return new Configuration(this.jdbcTemplate, this.transactionManager, this.tableName, this.timeZone);
            }
        }
    }
}

