/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Objects;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

class JdbcTemplateStorageAccessor
extends AbstractStorageAccessor {
    private final String tableName;
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;

    JdbcTemplateStorageAccessor(JdbcTemplate jdbcTemplate, PlatformTransactionManager transactionManager, String tableName) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate, "jdbcTemplate can not be null");
        this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
        if (null == transactionManager) {
            transactionManager = new DataSourceTransactionManager(jdbcTemplate.getDataSource());
        }
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        String sql = "INSERT INTO " + this.tableName + "(name, lock_until, locked_at, locked_by) VALUES(?, ?, ?, ?)";
        return (Boolean)this.transactionTemplate.execute(status -> {
            try {
                int insertedRows = this.jdbcTemplate.update(sql, preparedStatement -> {
                    preparedStatement.setString(1, lockConfiguration.getName());
                    preparedStatement.setTimestamp(2, Timestamp.from(lockConfiguration.getLockAtMostUntil()));
                    preparedStatement.setTimestamp(3, Timestamp.from(Instant.now()));
                    preparedStatement.setString(4, this.getHostname());
                });
                return insertedRows > 0;
            }
            catch (DataIntegrityViolationException e) {
                return false;
            }
        });
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = ?, locked_at = ?, locked_by = ? WHERE name = ? AND lock_until <= ?";
        return (Boolean)this.transactionTemplate.execute(status -> {
            int updatedRows = this.jdbcTemplate.update(sql, statement -> {
                Timestamp now = Timestamp.from(Instant.now());
                statement.setTimestamp(1, Timestamp.from(lockConfiguration.getLockAtMostUntil()));
                statement.setTimestamp(2, now);
                statement.setString(3, this.getHostname());
                statement.setString(4, lockConfiguration.getName());
                statement.setTimestamp(5, now);
            });
            return updatedRows > 0;
        });
    }

    public void unlock(final LockConfiguration lockConfiguration) {
        final String sql = "UPDATE " + this.tableName + " SET lock_until = ? WHERE name = ?";
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JdbcTemplateStorageAccessor.this.jdbcTemplate.update(sql, statement -> {
                    statement.setTimestamp(1, Timestamp.from(lockConfiguration.getUnlockTime()));
                    statement.setString(2, lockConfiguration.getName());
                });
            }
        });
    }
}

