/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

class JdbcTemplateStorageAccessor
extends AbstractStorageAccessor {
    private final Logger logger = LoggerFactory.getLogger(JdbcTemplateStorageAccessor.class);
    private final NamedParameterJdbcOperations jdbcTemplate;
    private final String tableName;

    JdbcTemplateStorageAccessor(NamedParameterJdbcOperations jdbcTemplate, String tableName) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate, "jdbcTemplate can not be null");
        this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        try {
            Map<String, Object> params = this.createParams(lockConfiguration);
            this.logger.trace("Trying to insert lock record {}", params);
            int insertedRows = this.jdbcTemplate.update(this.getInsertStatement(), params);
            if (insertedRows > 0) {
                this.logger.trace("Lock record inserted");
                return true;
            }
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            // empty catch block
        }
        this.logger.trace("Lock record not inserted");
        return false;
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        Map<String, Object> params = this.createParams(lockConfiguration);
        this.logger.trace("Trying to update lock record {}", params);
        int updatedRows = this.jdbcTemplate.update(this.getUpdateStatement(), params);
        boolean updated = updatedRows > 0;
        this.logger.trace("Lock record updated={}", (Object)updated);
        return updated;
    }

    public void unlock(LockConfiguration lockConfiguration) {
        Instant now = Instant.now();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("lockName", lockConfiguration.getName());
        params.put("unlockTime", Date.from(lockConfiguration.getUnlockTime()));
        this.jdbcTemplate.update(this.getUnlockStatement(), params);
    }

    protected Map<String, Object> createParams(LockConfiguration lockConfiguration) {
        Instant now = Instant.now();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("lockName", lockConfiguration.getName());
        params.put("lockUntil", Timestamp.from(lockConfiguration.getLockAtMostUntil()));
        params.put("now", Timestamp.from(now));
        params.put("lockedBy", this.getHostname());
        return params;
    }

    protected String getInsertStatement() {
        return "INSERT INTO " + this.tableName + "(name, lock_until, locked_at, locked_by) VALUES(:lockName, :lockUntil, :now, :lockedBy)";
    }

    protected String getUpdateStatement() {
        return "UPDATE " + this.tableName + " SET lock_until = :lockUntil, locked_at = :now, locked_by = :lockedBy WHERE name = :lockName AND lock_until <= :now";
    }

    protected String getUnlockStatement() {
        return "UPDATE " + this.tableName + " SET lock_until = :unlockTime WHERE name = :lockName";
    }
}

