/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

class JdbcTemplateStorageAccessor
implements StorageBasedLockProvider.StorageAccessor {
    private final NamedParameterJdbcOperations jdbcTemplate;
    private final String tableName;

    JdbcTemplateStorageAccessor(NamedParameterJdbcOperations jdbcTemplate, String tableName) {
        this.jdbcTemplate = Objects.requireNonNull(jdbcTemplate, "jdbcTemplate can not be null");
        this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        try {
            int insertedRows = this.jdbcTemplate.update(this.getInsertStatement(), this.createParams(lockConfiguration));
            if (insertedRows > 0) {
                return true;
            }
        }
        catch (DuplicateKeyException duplicateKeyException) {
            // empty catch block
        }
        return false;
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        int updatedRows = this.jdbcTemplate.update(this.getUpdateStatement(), this.createParams(lockConfiguration));
        return updatedRows > 0;
    }

    public void unlock(LockConfiguration lockConfiguration) {
        Map<String, Object> params = this.createParams(lockConfiguration);
        this.jdbcTemplate.update(this.getUnlockStatement(), params);
    }

    protected Map<String, Object> createParams(LockConfiguration lockConfiguration) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("lockName", lockConfiguration.getName());
        params.put("lockUntil", Date.from(lockConfiguration.getLockUntil()));
        params.put("now", new Date());
        params.put("lockedBy", JdbcTemplateStorageAccessor.getHostname());
        return params;
    }

    protected String getInsertStatement() {
        return "INSERT INTO " + this.tableName + "(name, lock_until, locked_at, locked_by) VALUES(:lockName, :lockUntil, :now, :lockedBy)";
    }

    protected String getUpdateStatement() {
        return "UPDATE " + this.tableName + " SET lock_until = :lockUntil, locked_at = :now, locked_by = :lockedBy WHERE name = :lockName AND lock_until <= :now";
    }

    protected String getUnlockStatement() {
        return "UPDATE " + this.tableName + " SET lock_until = :now WHERE name = :lockName";
    }

    private static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }
}

