/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbctemplate;

import java.sql.SQLException;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.provider.jdbc.internal.AbstractJdbcStorageAccessor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;

class JdbcTemplateStorageAccessor
extends AbstractJdbcStorageAccessor {
    private final SQLExceptionTranslator exceptionTranslator;

    JdbcTemplateStorageAccessor(DataSource dataSource, String tableName) {
        super(dataSource, tableName);
        this.exceptionTranslator = new SQLErrorCodeSQLExceptionTranslator(dataSource);
    }

    protected void handleInsertionException(String sql, SQLException e) {
        DataAccessException translatedException = this.exceptionTranslator.translate("InsertLock", sql, e);
        if (!(translatedException instanceof DataIntegrityViolationException)) {
            throw translatedException;
        }
    }

    protected void handleUpdateException(String sql, SQLException e) {
        throw this.exceptionTranslator.translate("UpdateLock", sql, e);
    }

    protected void handleUnlockException(String sql, SQLException e) {
        throw this.exceptionTranslator.translate("Unlock", sql, e);
    }
}

