/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc.micronaut;

import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.BiFunction;
import net.javacrumbs.shedlock.provider.jdbc.internal.AbstractJdbcStorageAccessor;
import net.javacrumbs.shedlock.provider.jdbc.micronaut.MicronautJdbcLockProvider;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;

class MicronautJdbcStorageAccessor
extends AbstractJdbcStorageAccessor {
    private final TransactionOperations<Connection> transactionOperations;
    private final TransactionDefinition.Propagation propagation = TransactionDefinition.Propagation.REQUIRES_NEW;

    MicronautJdbcStorageAccessor(MicronautJdbcLockProvider.Configuration configuration) {
        super((SqlConfiguration)configuration);
        this.transactionOperations = configuration.getTransactionOperations();
    }

    protected <T> T executeCommand(String sql, AbstractJdbcStorageAccessor.SqlFunction<PreparedStatement, T> body, BiFunction<String, SQLException, T> exceptionHandler) {
        return (T)this.transactionOperations.execute(TransactionDefinition.of((TransactionDefinition.Propagation)this.propagation), status -> {
            Object object;
            block8: {
                PreparedStatement statement = ((Connection)status.getConnection()).prepareStatement(sql);
                try {
                    object = body.apply((Object)statement);
                    if (statement == null) break block8;
                }
                catch (Throwable t$) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable x2) {
                                t$.addSuppressed(x2);
                            }
                        }
                        throw t$;
                    }
                    catch (SQLException e) {
                        return exceptionHandler.apply(sql, e);
                    }
                }
                statement.close();
            }
            return object;
        });
    }
}

