/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc.micronaut;

import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.TransactionOperations;
import java.sql.Connection;
import java.util.Objects;
import net.javacrumbs.shedlock.provider.jdbc.micronaut.MicronautJdbcStorageAccessor;
import net.javacrumbs.shedlock.provider.sql.DatabaseProduct;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicronautJdbcLockProvider
extends StorageBasedLockProvider {
    public MicronautJdbcLockProvider(TransactionOperations<Connection> transactionOperations) {
        this(transactionOperations, "shedlock");
    }

    public MicronautJdbcLockProvider(TransactionOperations<Connection> transactionOperations, String tableName) {
        this(((Configuration.Builder)Configuration.builder(transactionOperations).withTableName(tableName)).build());
    }

    public MicronautJdbcLockProvider(Configuration configuration) {
        super((StorageAccessor)new MicronautJdbcStorageAccessor(configuration));
    }

    public static final class Configuration
    extends SqlConfiguration {
        private final TransactionOperations<Connection> transactionOperations;
        private static final Logger logger = LoggerFactory.getLogger(Configuration.class);

        Configuration(TransactionOperations<Connection> transactionOperations, @Nullable DatabaseProduct databaseProduct, boolean dbUpperCase, String tableName, SqlConfiguration.ColumnNames columnNames, String lockedByValue, boolean useDbTime) {
            super(databaseProduct, dbUpperCase, tableName, null, columnNames, lockedByValue, useDbTime);
            this.transactionOperations = Objects.requireNonNull(transactionOperations, "transactionOperations can not be null");
        }

        public TransactionOperations<Connection> getTransactionOperations() {
            return this.transactionOperations;
        }

        public DatabaseProduct getDatabaseProduct() {
            if (super.getDatabaseProduct() != null) {
                return super.getDatabaseProduct();
            }
            return (DatabaseProduct)this.transactionOperations.execute(TransactionDefinition.of((TransactionDefinition.Propagation)TransactionDefinition.Propagation.REQUIRES_NEW), connection -> {
                try {
                    String jdbcProductName = ((Connection)connection.getConnection()).getMetaData().getDatabaseProductName();
                    return DatabaseProduct.matchProductName((String)jdbcProductName);
                }
                catch (Exception e) {
                    logger.debug("Can not determine database product name {}", (Object)e.getMessage());
                    return DatabaseProduct.UNKNOWN;
                }
            });
        }

        public static Builder builder(TransactionOperations<Connection> transactionOperations) {
            return new Builder(transactionOperations);
        }

        public static final class Builder
        extends SqlConfiguration.SqlConfigurationBuilder<Builder> {
            private final TransactionOperations<Connection> transactionOperations;

            public Builder(TransactionOperations<Connection> transactionOperations) {
                this.transactionOperations = transactionOperations;
            }

            public Configuration build() {
                return new Configuration(this.transactionOperations, this.databaseProduct, this.dbUpperCase, this.tableName, this.columnNames, this.lockedByValue, this.useDbTime);
            }
        }
    }
}

