/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.jdbc.internal.NamedSqlTranslator;
import net.javacrumbs.shedlock.provider.sql.SqlConfiguration;
import net.javacrumbs.shedlock.provider.sql.SqlStatementsSource;
import net.javacrumbs.shedlock.provider.sql.internal.ErrorCodeUtils;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;
import org.jspecify.annotations.Nullable;

public abstract class AbstractJdbcStorageAccessor
extends AbstractStorageAccessor {
    private final SqlConfiguration configuration;
    private @Nullable SqlStatementsSource sqlStatementsSource;

    public AbstractJdbcStorageAccessor(SqlConfiguration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "Configuration is null");
    }

    public boolean insertRecord(LockConfiguration lockConfiguration) {
        SqlStatementsSource sqlStatementsSource = this.sqlStatementsSource();
        String sql = sqlStatementsSource.getInsertStatement();
        NamedSqlTranslator.SqlStatement sqlStatement = NamedSqlTranslator.translate(sql, sqlStatementsSource.params(lockConfiguration));
        return this.executeCommand(sqlStatement.sql(), statement -> {
            AbstractJdbcStorageAccessor.setParameters(statement, sqlStatement.parameters());
            int insertedRows = statement.executeUpdate();
            return insertedRows > 0;
        }, this::handleInsertionException);
    }

    public boolean updateRecord(LockConfiguration lockConfiguration) {
        SqlStatementsSource sqlStatementsSource = this.sqlStatementsSource();
        String sql = sqlStatementsSource.getUpdateStatement();
        NamedSqlTranslator.SqlStatement sqlStatement = NamedSqlTranslator.translate(sql, sqlStatementsSource.params(lockConfiguration));
        return this.executeCommand(sqlStatement.sql(), statement -> {
            AbstractJdbcStorageAccessor.setParameters(statement, sqlStatement.parameters());
            int updatedRows = statement.executeUpdate();
            return updatedRows > 0;
        }, this::handleUpdateException);
    }

    public boolean extend(LockConfiguration lockConfiguration) {
        SqlStatementsSource sqlStatementsSource = this.sqlStatementsSource();
        String sql = sqlStatementsSource.getExtendStatement();
        NamedSqlTranslator.SqlStatement sqlStatement = NamedSqlTranslator.translate(sql, sqlStatementsSource.params(lockConfiguration));
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return this.executeCommand(sqlStatement.sql(), statement -> {
            AbstractJdbcStorageAccessor.setParameters(statement, sqlStatement.parameters());
            return statement.executeUpdate() > 0;
        }, this::handleUnlockException);
    }

    public void unlock(LockConfiguration lockConfiguration) {
        SqlStatementsSource sqlStatementsSource = this.sqlStatementsSource();
        String sql = sqlStatementsSource.getUnlockStatement();
        NamedSqlTranslator.SqlStatement sqlStatement = NamedSqlTranslator.translate(sql, sqlStatementsSource.params(lockConfiguration));
        this.executeCommand(sqlStatement.sql(), statement -> {
            AbstractJdbcStorageAccessor.setParameters(statement, sqlStatement.parameters());
            return Integer.valueOf(statement.executeUpdate());
        }, this::handleUnlockException);
    }

    protected abstract <T> T executeCommand(String var1, SqlFunction<PreparedStatement, T> var2, BiFunction<String, SQLException, T> var3);

    boolean handleInsertionException(String sql, SQLException e) {
        if (e instanceof SQLIntegrityConstraintViolationException || ErrorCodeUtils.isConstraintViolation((String)e.getSQLState())) {
            this.logger.debug("Constraint violation, duplicate key error is expected here {}", (Object)e.getMessage());
            return false;
        }
        throw new LockException("Failed to execute SQL insertion", (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlStatementsSource sqlStatementsSource() {
        SqlConfiguration sqlConfiguration = this.configuration;
        synchronized (sqlConfiguration) {
            if (this.sqlStatementsSource == null) {
                this.sqlStatementsSource = SqlStatementsSource.create((SqlConfiguration)this.configuration);
            }
            return this.sqlStatementsSource;
        }
    }

    private static void setParameters(PreparedStatement statement, List<Object> parameters) throws SQLException {
        for (int i = 0; i < parameters.size(); ++i) {
            Object value = parameters.get(i);
            int paramIndex = i + 1;
            if (value instanceof Calendar) {
                Calendar cal = (Calendar)value;
                statement.setTimestamp(paramIndex, new Timestamp(cal.getTimeInMillis()), cal);
                continue;
            }
            statement.setObject(paramIndex, value);
        }
    }

    boolean handleUpdateException(String sql, SQLException e) {
        this.logger.debug("Unexpected exception when updating lock record", (Throwable)e);
        throw new LockException("Unexpected exception when locking", (Throwable)e);
    }

    boolean handleUnlockException(String sql, SQLException e) {
        throw new LockException("Unexpected exception when unlocking", (Throwable)e);
    }

    @FunctionalInterface
    public static interface SqlFunction<T, R> {
        public R apply(T var1) throws SQLException;
    }
}

