/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Objects;
import javax.sql.DataSource;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJdbcStorageAccessor
extends AbstractStorageAccessor {
    private final DataSource dataSource;
    private final String tableName;

    protected AbstractJdbcStorageAccessor(DataSource dataSource, String tableName) {
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource can not be null");
        this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean insertRecord(@NotNull LockConfiguration lockConfiguration) {
        String sql = "INSERT INTO " + this.tableName + "(name, lock_until, locked_at, locked_by) VALUES(?, ?, ?, ?)";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            connection.setAutoCommit(true);
            statement.setString(1, lockConfiguration.getName());
            statement.setTimestamp(2, Timestamp.from(lockConfiguration.getLockAtMostUntil()));
            statement.setTimestamp(3, Timestamp.from(ClockProvider.now()));
            statement.setString(4, this.getHostname());
            int insertedRows = statement.executeUpdate();
            if (insertedRows <= 0) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.handleInsertionException(sql, e);
        }
        return false;
    }

    protected abstract void handleInsertionException(String var1, SQLException var2);

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean updateRecord(@NotNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = ?, locked_at = ?, locked_by = ? WHERE name = ? AND lock_until <= ?";
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    connection.setAutoCommit(true);
                    Timestamp now = Timestamp.from(ClockProvider.now());
                    statement.setTimestamp(1, Timestamp.from(lockConfiguration.getLockAtMostUntil()));
                    statement.setTimestamp(2, now);
                    statement.setString(3, this.getHostname());
                    statement.setString(4, lockConfiguration.getName());
                    statement.setTimestamp(5, now);
                    int updatedRows = statement.executeUpdate();
                    boolean bl2 = bl = updatedRows > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.handleUpdateException(sql, e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean extend(@NotNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = ? WHERE name = ? AND locked_by = ? AND lock_until > ? ";
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    connection.setAutoCommit(true);
                    statement.setTimestamp(1, Timestamp.from(lockConfiguration.getLockAtMostUntil()));
                    statement.setString(2, lockConfiguration.getName());
                    statement.setString(3, this.getHostname());
                    statement.setTimestamp(4, Timestamp.from(ClockProvider.now()));
                    boolean bl2 = bl = statement.executeUpdate() > 0;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.handleUnlockException(sql, e);
            return false;
        }
    }

    protected abstract void handleUpdateException(String var1, SQLException var2);

    public void unlock(@NotNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = ? WHERE name = ?";
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(sql);){
            connection.setAutoCommit(true);
            statement.setTimestamp(1, Timestamp.from(lockConfiguration.getUnlockTime()));
            statement.setString(2, lockConfiguration.getName());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.handleUnlockException(sql, e);
        }
    }

    protected abstract void handleUnlockException(String var1, SQLException var2);
}

