/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.jdbc.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.function.BiFunction;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public abstract class AbstractJdbcStorageAccessor
extends AbstractStorageAccessor {
    private final String tableName;

    public AbstractJdbcStorageAccessor(@NonNull String tableName) {
        this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
    }

    public boolean insertRecord(@NonNull LockConfiguration lockConfiguration) {
        String sql = "INSERT INTO " + this.tableName + "(name, lock_until, locked_at, locked_by) VALUES(?, ?, ?, ?)";
        return this.executeCommand(sql, statement -> {
            statement.setString(1, lockConfiguration.getName());
            statement.setTimestamp(2, Timestamp.from(lockConfiguration.getLockAtMostUntil()));
            statement.setTimestamp(3, Timestamp.from(ClockProvider.now()));
            statement.setString(4, this.getHostname());
            int insertedRows = statement.executeUpdate();
            return insertedRows > 0;
        }, this::handleInsertionException);
    }

    public boolean updateRecord(@NonNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = ?, locked_at = ?, locked_by = ? WHERE name = ? AND lock_until <= ?";
        return this.executeCommand(sql, statement -> {
            Timestamp now = Timestamp.from(ClockProvider.now());
            statement.setTimestamp(1, Timestamp.from(lockConfiguration.getLockAtMostUntil()));
            statement.setTimestamp(2, now);
            statement.setString(3, this.getHostname());
            statement.setString(4, lockConfiguration.getName());
            statement.setTimestamp(5, now);
            int updatedRows = statement.executeUpdate();
            return updatedRows > 0;
        }, this::handleUpdateException);
    }

    public boolean extend(@NonNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = ? WHERE name = ? AND locked_by = ? AND lock_until > ? ";
        this.logger.debug("Extending lock={} until={}", (Object)lockConfiguration.getName(), (Object)lockConfiguration.getLockAtMostUntil());
        return this.executeCommand(sql, statement -> {
            statement.setTimestamp(1, Timestamp.from(lockConfiguration.getLockAtMostUntil()));
            statement.setString(2, lockConfiguration.getName());
            statement.setString(3, this.getHostname());
            statement.setTimestamp(4, Timestamp.from(ClockProvider.now()));
            return statement.executeUpdate() > 0;
        }, this::handleUnlockException);
    }

    public void unlock(@NonNull LockConfiguration lockConfiguration) {
        String sql = "UPDATE " + this.tableName + " SET lock_until = ? WHERE name = ?";
        this.executeCommand(sql, statement -> {
            statement.setTimestamp(1, Timestamp.from(lockConfiguration.getUnlockTime()));
            statement.setString(2, lockConfiguration.getName());
            statement.executeUpdate();
            return null;
        }, this::handleUnlockException);
    }

    protected abstract <T> T executeCommand(String var1, SqlFunction<PreparedStatement, T> var2, BiFunction<String, SQLException, T> var3);

    boolean handleInsertionException(String sql, SQLException e) {
        if (!(e instanceof SQLIntegrityConstraintViolationException)) {
            this.logger.debug("Exception thrown when inserting record", (Throwable)e);
        }
        return false;
    }

    boolean handleUpdateException(String sql, SQLException e) {
        throw new LockException("Unexpected exception when locking", (Throwable)e);
    }

    boolean handleUnlockException(String sql, SQLException e) {
        throw new LockException("Unexpected exception when unlocking", (Throwable)e);
    }

    @FunctionalInterface
    public static interface SqlFunction<T, R> {
        public R apply(T var1) throws SQLException;
    }
}

