/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.inmemory;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryLockProvider
implements ExtensibleLockProvider {
    private final Map<String, LockRecord> locks = new HashMap<String, LockRecord>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        Map<String, LockRecord> map = this.locks;
        synchronized (map) {
            String lockName = lockConfiguration.getName();
            if (this.isLocked(lockName)) {
                return Optional.empty();
            }
            LockRecord lockRecord = new LockRecord(lockConfiguration.getLockAtMostUntil());
            this.locks.put(lockName, lockRecord);
            this.logger.debug("Locked {}", (Object)lockConfiguration);
            return Optional.of(new InMemoryLock(lockConfiguration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLocked(String lockName) {
        Map<String, LockRecord> map = this.locks;
        synchronized (map) {
            LockRecord lockRecord = this.locks.get(lockName);
            return lockRecord != null && lockRecord.lockedUntil.isAfter(ClockProvider.now());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnlock(LockConfiguration lockConfiguration) {
        Map<String, LockRecord> map = this.locks;
        synchronized (map) {
            this.locks.put(lockConfiguration.getName(), new LockRecord(lockConfiguration.getLockAtLeastUntil()));
            this.logger.debug("Unlocked {}", (Object)lockConfiguration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<SimpleLock> doExtend(LockConfiguration newConfiguration) {
        Map<String, LockRecord> map = this.locks;
        synchronized (map) {
            String lockName = newConfiguration.getName();
            if (this.isLocked(lockName)) {
                this.locks.put(lockName, new LockRecord(newConfiguration.getLockAtMostUntil()));
                this.logger.debug("Extended {}", (Object)newConfiguration);
                return Optional.of(new InMemoryLock(newConfiguration));
            }
            return Optional.empty();
        }
    }

    private static class LockRecord {
        private final Instant lockedUntil;

        private LockRecord(Instant lockedUntil) {
            this.lockedUntil = lockedUntil;
        }
    }

    private class InMemoryLock
    extends AbstractSimpleLock {
        private InMemoryLock(LockConfiguration lockConfiguration) {
            super(lockConfiguration);
        }

        protected void doUnlock() {
            InMemoryLockProvider.this.doUnlock(this.lockConfiguration);
        }

        protected Optional<SimpleLock> doExtend(LockConfiguration newConfiguration) {
            return InMemoryLockProvider.this.doExtend(newConfiguration);
        }
    }
}

