/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.ignite;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.provider.ignite.LockValue;
import net.javacrumbs.shedlock.support.Utils;
import org.apache.ignite.Ignite;
import org.apache.ignite.table.KeyValueView;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.mapper.Mapper;

public class IgniteLockProvider
implements ExtensibleLockProvider {
    public static final String DEFAULT_SHEDLOCK_CACHE_NAME = "shedLock";
    public static final ZoneId UTC = ZoneId.of("UTC");
    private final KeyValueView<String, LockValue> keyValueView;

    public IgniteLockProvider(Ignite ignite) {
        this(ignite, DEFAULT_SHEDLOCK_CACHE_NAME);
    }

    public IgniteLockProvider(Ignite ignite, String shedLockTableName) {
        Table table = ignite.tables().table(shedLockTableName);
        if (table == null) {
            throw new IllegalArgumentException("Table '" + shedLockTableName + "' does not exist. Please create the table first or use the default table name.");
        }
        this.keyValueView = table.keyValueView(Mapper.of(String.class), Mapper.of(LockValue.class));
    }

    public Optional<SimpleLock> lock(LockConfiguration lockCfg) {
        LocalDateTime now = IgniteLockProvider.now();
        String key = lockCfg.getName();
        LockValue newVal = new LockValue(now, IgniteLockProvider.toLocalDateTime(lockCfg.getLockAtMostUntil()), Utils.getHostname());
        LockValue oldVal = (LockValue)this.keyValueView.get(null, (Object)key);
        if (oldVal == null) {
            if (this.keyValueView.putIfAbsent(null, (Object)key, (Object)newVal)) {
                return Optional.of(new IgniteLock(lockCfg, this));
            }
            return Optional.empty();
        }
        if (!now.isBefore(oldVal.getLockUntil()) && this.keyValueView.replace(null, (Object)key, (Object)oldVal, (Object)newVal)) {
            return Optional.of(new IgniteLock(lockCfg, this));
        }
        return Optional.empty();
    }

    private Optional<SimpleLock> extend(LockConfiguration lockCfg) {
        LocalDateTime now = IgniteLockProvider.now();
        String key = lockCfg.getName();
        LockValue oldVal = (LockValue)this.keyValueView.get(null, (Object)key);
        if (oldVal == null || !oldVal.getLockedBy().equals(Utils.getHostname()) || !oldVal.getLockUntil().isAfter(now)) {
            return Optional.empty();
        }
        LockValue newVal = oldVal.withLockUntil(IgniteLockProvider.toLocalDateTime(lockCfg.getLockAtMostUntil()));
        if (this.keyValueView.replace(null, (Object)key, (Object)oldVal, (Object)newVal)) {
            return Optional.of(new IgniteLock(lockCfg, this));
        }
        return Optional.empty();
    }

    private static LocalDateTime now() {
        return IgniteLockProvider.toLocalDateTime(Instant.now());
    }

    private void unlock(LockConfiguration lockCfg) {
        String key = lockCfg.getName();
        LockValue oldVal = (LockValue)this.keyValueView.get(null, (Object)key);
        if (oldVal != null && oldVal.getLockedBy().equals(Utils.getHostname())) {
            LockValue newVal = oldVal.withLockUntil(IgniteLockProvider.toLocalDateTime(lockCfg.getUnlockTime()));
            this.keyValueView.replace(null, (Object)key, (Object)oldVal, (Object)newVal);
        }
    }

    private static LocalDateTime toLocalDateTime(Instant instant) {
        return LocalDateTime.ofInstant(instant, UTC);
    }

    private static final class IgniteLock
    extends AbstractSimpleLock {
        private final IgniteLockProvider lockProvider;

        private IgniteLock(LockConfiguration lockCfg, IgniteLockProvider lockProvider) {
            super(lockCfg);
            this.lockProvider = lockProvider;
        }

        public void doUnlock() {
            this.lockProvider.unlock(this.lockConfiguration);
        }

        public Optional<SimpleLock> doExtend(LockConfiguration newLockConfiguration) {
            return this.lockProvider.extend(newLockConfiguration);
        }
    }
}

