/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.ignite;

import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ExtensibleLockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.provider.ignite.LockValue;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;

public class IgniteLockProvider
implements ExtensibleLockProvider {
    public static final String DEFAULT_SHEDLOCK_CACHE_NAME = "shedLock";
    private final IgniteCache<String, LockValue> cache;

    public IgniteLockProvider(@NonNull Ignite ignite) {
        this(ignite, DEFAULT_SHEDLOCK_CACHE_NAME);
    }

    public IgniteLockProvider(@NonNull Ignite ignite, @NonNull String shedLockCacheName) {
        this.cache = ignite.getOrCreateCache(shedLockCacheName);
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockCfg) {
        Instant now = Instant.now();
        String key = lockCfg.getName();
        LockValue newVal = new LockValue(now, lockCfg.getLockAtMostUntil(), Utils.getHostname());
        LockValue oldVal = (LockValue)this.cache.get((Object)key);
        if (oldVal == null) {
            if (this.cache.putIfAbsent((Object)key, (Object)newVal)) {
                return Optional.of(new IgniteLock(lockCfg, this));
            }
            return Optional.empty();
        }
        if (!now.isBefore(oldVal.getLockUntil()) && this.cache.replace((Object)key, (Object)oldVal, (Object)newVal)) {
            return Optional.of(new IgniteLock(lockCfg, this));
        }
        return Optional.empty();
    }

    private Optional<SimpleLock> extend(LockConfiguration lockCfg) {
        Instant now = Instant.now();
        String key = lockCfg.getName();
        LockValue oldVal = (LockValue)this.cache.get((Object)key);
        if (oldVal == null || !oldVal.getLockedBy().equals(Utils.getHostname()) || !oldVal.getLockUntil().isAfter(now)) {
            return Optional.empty();
        }
        LockValue newVal = oldVal.withLockUntil(lockCfg.getLockAtMostUntil());
        if (this.cache.replace((Object)key, (Object)oldVal, (Object)newVal)) {
            return Optional.of(new IgniteLock(lockCfg, this));
        }
        return Optional.empty();
    }

    private void unlock(LockConfiguration lockCfg) {
        String key = lockCfg.getName();
        LockValue oldVal = (LockValue)this.cache.get((Object)key);
        if (oldVal != null && oldVal.getLockedBy().equals(Utils.getHostname())) {
            LockValue newVal = oldVal.withLockUntil(lockCfg.getUnlockTime());
            this.cache.replace((Object)key, (Object)oldVal, (Object)newVal);
        }
    }

    private static final class IgniteLock
    extends AbstractSimpleLock {
        private final IgniteLockProvider lockProvider;

        private IgniteLock(LockConfiguration lockCfg, IgniteLockProvider lockProvider) {
            super(lockCfg);
            this.lockProvider = lockProvider;
        }

        public void doUnlock() {
            this.lockProvider.unlock(this.lockConfiguration);
        }

        public Optional<SimpleLock> doExtend(LockConfiguration newLockConfiguration) {
            return this.lockProvider.extend(newLockConfiguration);
        }
    }
}

