/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.exposed;

import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.time.Duration;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.exposed.CurrentTimestampExact;
import net.javacrumbs.shedlock.provider.exposed.ExposedIntervalExpressionKt;
import net.javacrumbs.shedlock.provider.exposed.Shedlock;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Case;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.OpBuilderKt;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.core.statements.UpdateStatement;
import org.jetbrains.exposed.v1.core.statements.UpsertBuilder;
import org.jetbrains.exposed.v1.core.statements.UpsertStatement;
import org.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.v1.exceptions.ExposedSQLException;
import org.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.QueriesKt;
import org.jetbrains.exposed.v1.jdbc.transactions.TransactionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\n*\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/javacrumbs/shedlock/provider/exposed/ExposedStorageAccessor;", "Lnet/javacrumbs/shedlock/support/AbstractStorageAccessor;", "database", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "<init>", "(Lorg/jetbrains/exposed/v1/jdbc/Database;)V", "now", "Lorg/jetbrains/exposed/v1/core/Expression;", "Ljava/time/LocalDateTime;", "insertRecord", "", "lockConfiguration", "Lnet/javacrumbs/shedlock/core/LockConfiguration;", "isConstraintViolation", "", "updateRecord", "unlock", "", "extend", "nowPlus", "duration", "Ljava/time/Duration;", "shedlock-provider-exposed"})
public final class ExposedStorageAccessor
extends AbstractStorageAccessor {
    @NotNull
    private final Database database;
    @NotNull
    private final Expression<LocalDateTime> now;

    public ExposedStorageAccessor(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.now = CurrentTimestampExact.INSTANCE;
    }

    public boolean insertRecord(@NotNull LockConfiguration lockConfiguration) {
        Intrinsics.checkNotNullParameter((Object)lockConfiguration, (String)"lockConfiguration");
        return (Boolean)TransactionsKt.transaction$default((Database)this.database, null, null, arg_0 -> ExposedStorageAccessor.insertRecord$lambda$0(this, lockConfiguration, arg_0), (int)6, null);
    }

    private final boolean isConstraintViolation(String $this$isConstraintViolation) {
        String string = $this$isConstraintViolation;
        return string != null ? StringsKt.startsWith$default((String)string, (String)"23", (boolean)false, (int)2, null) : false;
    }

    public boolean updateRecord(@NotNull LockConfiguration lockConfiguration) {
        Intrinsics.checkNotNullParameter((Object)lockConfiguration, (String)"lockConfiguration");
        return (Boolean)TransactionsKt.transaction$default((Database)this.database, null, null, arg_0 -> ExposedStorageAccessor.updateRecord$lambda$0(lockConfiguration, this, arg_0), (int)6, null);
    }

    public void unlock(@NotNull LockConfiguration lockConfiguration) {
        Intrinsics.checkNotNullParameter((Object)lockConfiguration, (String)"lockConfiguration");
        TransactionsKt.transaction$default((Database)this.database, null, null, arg_0 -> ExposedStorageAccessor.unlock$lambda$0(lockConfiguration, this, arg_0), (int)6, null);
    }

    public boolean extend(@NotNull LockConfiguration lockConfiguration) {
        Intrinsics.checkNotNullParameter((Object)lockConfiguration, (String)"lockConfiguration");
        return (Boolean)TransactionsKt.transaction$default((Database)this.database, null, null, arg_0 -> ExposedStorageAccessor.extend$lambda$0(lockConfiguration, this, arg_0), (int)6, null);
    }

    private final Expression<LocalDateTime> nowPlus(Duration duration) {
        return ExposedIntervalExpressionKt.plus(this.now, duration);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean insertRecord$lambda$0(ExposedStorageAccessor this$0, LockConfiguration $lockConfiguration, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        try {
            if (this$0.database.getDialect() instanceof PostgreSQLDialect) {
                if (QueriesKt.upsert$default((Table)Shedlock.INSTANCE, (Column[])new Column[0], (arg_0, arg_1) -> ExposedStorageAccessor.insertRecord$lambda$0$0(this$0, $lockConfiguration, arg_0, arg_1), null, () -> ExposedStorageAccessor.insertRecord$lambda$0$1($lockConfiguration, this$0), (arg_0, arg_1) -> ExposedStorageAccessor.insertRecord$lambda$0$2($lockConfiguration, this$0, arg_0, arg_1), (int)4, null).getInsertedCount() <= 0) return false;
                return true;
            }
            if (QueriesKt.insert((Table)Shedlock.INSTANCE, (arg_0, arg_1) -> ExposedStorageAccessor.insertRecord$lambda$0$3($lockConfiguration, this$0, arg_0, arg_1)).getInsertedCount() <= 0) return false;
            return true;
        }
        catch (ExposedSQLException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof SQLIntegrityConstraintViolationException) {
                return false;
            }
            if (throwable instanceof SQLException) {
                Throwable throwable2 = e.getCause();
                Intrinsics.checkNotNull((Object)throwable2, (String)"null cannot be cast to non-null type java.sql.SQLException");
                if (this$0.isConstraintViolation(((SQLException)throwable2).getSQLState())) {
                    this$0.logger.debug("Constraint violation, duplicate key error is expected here {}", (Object)e.getMessage());
                    return false;
                }
            }
            this$0.logger.debug("ExposedSQLException thrown when inserting record", (Throwable)e);
            throw new LockException("Unexpected exception when locking", (Throwable)e);
        }
        catch (Exception e) {
            this$0.logger.debug("Exception thrown when inserting record", (Throwable)e);
            throw new LockException("Unexpected exception when locking", (Throwable)e);
        }
    }

    private static final Unit insertRecord$lambda$0$0(ExposedStorageAccessor this$0, LockConfiguration $lockConfiguration, UpsertBuilder $this$upsert, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)$this$upsert, (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Column<LocalDateTime> column = Shedlock.INSTANCE.getLockUntil();
        Duration duration = $lockConfiguration.getLockAtMostFor();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getLockAtMostFor(...)");
        it.set(column, this$0.nowPlus(duration));
        it.set(Shedlock.INSTANCE.getLockedAt(), this$0.now);
        it.set(Shedlock.INSTANCE.getLockedBy(), (Object)this$0.getHostname());
        return Unit.INSTANCE;
    }

    private static final Op insertRecord$lambda$0$1(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0) {
        return OpBuilderKt.and((Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Shedlock.INSTANCE.getName()), (Object)$lockConfiguration.getName())), (Expression)((Expression)OpBuilderKt.lessEq((Expression)((Expression)Shedlock.INSTANCE.getLockUntil()), this$0.now)));
    }

    private static final Unit insertRecord$lambda$0$2(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0, Shedlock $this$upsert, UpsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$upsert), (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($this$upsert.getName(), (Object)$lockConfiguration.getName());
        Column<LocalDateTime> column = $this$upsert.getLockUntil();
        Duration duration = $lockConfiguration.getLockAtMostFor();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getLockAtMostFor(...)");
        it.set(column, this$0.nowPlus(duration));
        it.set($this$upsert.getLockedAt(), this$0.now);
        it.set($this$upsert.getLockedBy(), (Object)this$0.getHostname());
        return Unit.INSTANCE;
    }

    private static final Unit insertRecord$lambda$0$3(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0, Shedlock $this$insert, InsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$insert), (String)"$this$insert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($this$insert.getName(), (Object)$lockConfiguration.getName());
        Column<LocalDateTime> column = $this$insert.getLockUntil();
        Duration duration = $lockConfiguration.getLockAtMostFor();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getLockAtMostFor(...)");
        it.set(column, this$0.nowPlus(duration));
        it.set($this$insert.getLockedAt(), this$0.now);
        it.set($this$insert.getLockedBy(), (Object)this$0.getHostname());
        return Unit.INSTANCE;
    }

    private static final boolean updateRecord$lambda$0(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0, JdbcTransaction $this$transaction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        try {
            bl = QueriesKt.update$default((Table)Shedlock.INSTANCE, () -> ExposedStorageAccessor.updateRecord$lambda$0$0($lockConfiguration, this$0), null, (arg_0, arg_1) -> ExposedStorageAccessor.updateRecord$lambda$0$1(this$0, $lockConfiguration, arg_0, arg_1), (int)2, null) > 0;
        }
        catch (Exception e) {
            throw new LockException("Unexpected exception when locking", (Throwable)e);
        }
        return bl;
    }

    private static final Op updateRecord$lambda$0$0(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0) {
        return OpBuilderKt.and((Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Shedlock.INSTANCE.getName()), (Object)$lockConfiguration.getName())), (Expression)((Expression)OpBuilderKt.lessEq((Expression)((Expression)Shedlock.INSTANCE.getLockUntil()), this$0.now)));
    }

    private static final Unit updateRecord$lambda$0$1(ExposedStorageAccessor this$0, LockConfiguration $lockConfiguration, Shedlock $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Column<LocalDateTime> column = $this$update.getLockUntil();
        Duration duration = $lockConfiguration.getLockAtMostFor();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getLockAtMostFor(...)");
        it.set(column, this$0.nowPlus(duration));
        it.set($this$update.getLockedAt(), this$0.now);
        it.set($this$update.getLockedBy(), (Object)this$0.getHostname());
        return Unit.INSTANCE;
    }

    private static final int unlock$lambda$0(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0, JdbcTransaction $this$transaction) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        try {
            Expression expression = (Expression)Shedlock.INSTANCE.getLockedAt();
            Duration duration = $lockConfiguration.getLockAtLeastFor();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getLockAtLeastFor(...)");
            Expression<LocalDateTime> lockAtLeastUntil = ExposedIntervalExpressionKt.plus((Expression<LocalDateTime>)expression, duration);
            n = QueriesKt.update$default((Table)Shedlock.INSTANCE, () -> ExposedStorageAccessor.unlock$lambda$0$0($lockConfiguration, this$0), null, (arg_0, arg_1) -> ExposedStorageAccessor.unlock$lambda$0$1(lockAtLeastUntil, this$0, arg_0, arg_1), (int)2, null);
        }
        catch (Exception e) {
            throw new LockException("Unexpected exception when unlocking", (Throwable)e);
        }
        return n;
    }

    private static final Op unlock$lambda$0$0(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0) {
        return OpBuilderKt.and((Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Shedlock.INSTANCE.getName()), (Object)$lockConfiguration.getName())), (Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Shedlock.INSTANCE.getLockedBy()), (Object)this$0.getHostname())));
    }

    private static final Unit unlock$lambda$0$1(Expression $lockAtLeastUntil, ExposedStorageAccessor this$0, Shedlock $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set($this$update.getLockUntil(), (Expression)new Case().When((Expression)OpBuilderKt.greater((Expression)$lockAtLeastUntil, this$0.now), $lockAtLeastUntil).Else(this$0.now));
        return Unit.INSTANCE;
    }

    private static final boolean extend$lambda$0(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0, JdbcTransaction $this$transaction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        try {
            bl = QueriesKt.update$default((Table)Shedlock.INSTANCE, () -> ExposedStorageAccessor.extend$lambda$0$0($lockConfiguration, this$0), null, (arg_0, arg_1) -> ExposedStorageAccessor.extend$lambda$0$1(this$0, $lockConfiguration, arg_0, arg_1), (int)2, null) > 0;
        }
        catch (Exception e) {
            throw new LockException("Unexpected exception when extending", (Throwable)e);
        }
        return bl;
    }

    private static final Op extend$lambda$0$0(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0) {
        return OpBuilderKt.and((Expression)((Expression)OpBuilderKt.and((Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Shedlock.INSTANCE.getName()), (Object)$lockConfiguration.getName())), (Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)Shedlock.INSTANCE.getLockedBy()), (Object)this$0.getHostname())))), (Expression)((Expression)OpBuilderKt.greater((Expression)((Expression)Shedlock.INSTANCE.getLockUntil()), this$0.now)));
    }

    private static final Unit extend$lambda$0$1(ExposedStorageAccessor this$0, LockConfiguration $lockConfiguration, Shedlock $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Column<LocalDateTime> column = $this$update.getLockUntil();
        Duration duration = $lockConfiguration.getLockAtMostFor();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getLockAtMostFor(...)");
        it.set(column, this$0.nowPlus(duration));
        return Unit.INSTANCE;
    }
}

