/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.exposed;

import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.time.Duration;
import java.time.LocalDateTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.exposed.ExposedIntervalExpressionKt;
import net.javacrumbs.shedlock.provider.exposed.Shedlock;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.LockException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Case;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.javatime.CurrentDateTime;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.statements.UpdateStatement;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/javacrumbs/shedlock/provider/exposed/ExposedStorageAccessor;", "Lnet/javacrumbs/shedlock/support/AbstractStorageAccessor;", "database", "Lorg/jetbrains/exposed/sql/Database;", "<init>", "(Lorg/jetbrains/exposed/sql/Database;)V", "now", "Lorg/jetbrains/exposed/sql/Expression;", "Ljava/time/LocalDateTime;", "insertRecord", "", "lockConfiguration", "Lnet/javacrumbs/shedlock/core/LockConfiguration;", "updateRecord", "unlock", "", "extend", "nowPlus", "duration", "Ljava/time/Duration;", "shedlock-provider-exposed"})
@SourceDebugExtension(value={"SMAP\nExposedStorageAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedStorageAccessor.kt\nnet/javacrumbs/shedlock/provider/exposed/ExposedStorageAccessor\n+ 2 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n*L\n1#1,87:1\n296#2,4:88\n595#2,11:92\n595#2,11:103\n595#2,11:114\n*S KotlinDebug\n*F\n+ 1 ExposedStorageAccessor.kt\nnet/javacrumbs/shedlock/provider/exposed/ExposedStorageAccessor\n*L\n27#1:88,4\n46#1:92,11\n61#1:103,11\n73#1:114,11\n*E\n"})
public final class ExposedStorageAccessor
extends AbstractStorageAccessor {
    @NotNull
    private final Database database;
    @NotNull
    private final Expression<LocalDateTime> now;

    public ExposedStorageAccessor(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.now = (Expression)CurrentDateTime.INSTANCE;
    }

    public boolean insertRecord(@NotNull LockConfiguration lockConfiguration) {
        Intrinsics.checkNotNullParameter((Object)lockConfiguration, (String)"lockConfiguration");
        return (Boolean)ThreadLocalTransactionManagerKt.transaction((Database)this.database, arg_0 -> ExposedStorageAccessor.insertRecord$lambda$1(this, lockConfiguration, arg_0));
    }

    public boolean updateRecord(@NotNull LockConfiguration lockConfiguration) {
        Intrinsics.checkNotNullParameter((Object)lockConfiguration, (String)"lockConfiguration");
        return (Boolean)ThreadLocalTransactionManagerKt.transaction((Database)this.database, arg_0 -> ExposedStorageAccessor.updateRecord$lambda$4(lockConfiguration, this, arg_0));
    }

    public void unlock(@NotNull LockConfiguration lockConfiguration) {
        Intrinsics.checkNotNullParameter((Object)lockConfiguration, (String)"lockConfiguration");
        ThreadLocalTransactionManagerKt.transaction((Database)this.database, arg_0 -> ExposedStorageAccessor.unlock$lambda$7(lockConfiguration, this, arg_0));
    }

    public boolean extend(@NotNull LockConfiguration lockConfiguration) {
        Intrinsics.checkNotNullParameter((Object)lockConfiguration, (String)"lockConfiguration");
        return (Boolean)ThreadLocalTransactionManagerKt.transaction((Database)this.database, arg_0 -> ExposedStorageAccessor.extend$lambda$10(lockConfiguration, this, arg_0));
    }

    private final Expression<LocalDateTime> nowPlus(Duration duration) {
        return ExposedIntervalExpressionKt.plus(this.now, duration);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean insertRecord$lambda$1(ExposedStorageAccessor this$0, LockConfiguration $lockConfiguration, Transaction $this$transaction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        try {
            void it;
            InsertStatement insertStatement;
            Table $this$insert$iv = Shedlock.INSTANCE;
            boolean $i$f$insert = false;
            InsertStatement $this$insert_u24lambda_u243$iv = insertStatement = new InsertStatement($this$insert$iv, false, 2, null);
            boolean bl2 = false;
            InsertStatement insertStatement2 = $this$insert_u24lambda_u243$iv;
            Shedlock $this$insertRecord_u24lambda_u241_u24lambda_u240 = (Shedlock)$this$insert$iv;
            boolean bl3 = false;
            it.set($this$insertRecord_u24lambda_u241_u24lambda_u240.getName(), (Object)$lockConfiguration.getName());
            Column<LocalDateTime> column = $this$insertRecord_u24lambda_u241_u24lambda_u240.getLockUntil();
            Duration duration = $lockConfiguration.getLockAtMostFor();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getLockAtMostFor(...)");
            it.set(column, this$0.nowPlus(duration));
            it.set($this$insertRecord_u24lambda_u241_u24lambda_u240.getLockedAt(), this$0.now);
            it.set($this$insertRecord_u24lambda_u241_u24lambda_u240.getLockedBy(), (Object)this$0.getHostname());
            $this$insert_u24lambda_u243$iv.execute(TransactionManager.Companion.current());
            bl = true;
        }
        catch (SQLIntegrityConstraintViolationException sQLIntegrityConstraintViolationException) {
            bl = false;
        }
        catch (SQLException e) {
            this$0.logger.debug("Exception thrown when inserting record", (Throwable)e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean updateRecord$lambda$4(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0, Transaction $this$transaction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        try {
            void it;
            UpdateStatement query$iv;
            void $this$updateRecord_u24lambda_u244_u24lambda_u242;
            Op op;
            Table $this$update_u24default$iv = Shedlock.INSTANCE;
            Integer limit$iv = null;
            boolean $i$f$update = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Integer n = limit$iv;
            ColumnSet columnSet = (ColumnSet)$this$update_u24default$iv;
            boolean $i$a$-update$default-ExposedStorageAccessor$updateRecord$1$32 = false;
            Op op2 = op = OpKt.and((Expression)((Expression)$this$updateRecord_u24lambda_u244_u24lambda_u242.eq((ExpressionWithColumnType)Shedlock.INSTANCE.getName(), (Object)$lockConfiguration.getName())), (Expression)((Expression)$this$updateRecord_u24lambda_u244_u24lambda_u242.lessEq((Expression)Shedlock.INSTANCE.getLockUntil(), this$0.now)));
            Integer n2 = n;
            ColumnSet columnSet2 = columnSet;
            UpdateStatement $i$a$-update$default-ExposedStorageAccessor$updateRecord$1$32 = query$iv = new UpdateStatement(columnSet2, n2, op2);
            Shedlock $this$updateRecord_u24lambda_u244_u24lambda_u243 = (Shedlock)$this$update_u24default$iv;
            boolean bl2 = false;
            Column<LocalDateTime> column = $this$updateRecord_u24lambda_u244_u24lambda_u243.getLockUntil();
            Duration duration = $lockConfiguration.getLockAtMostFor();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getLockAtMostFor(...)");
            it.set(column, this$0.nowPlus(duration));
            it.set($this$updateRecord_u24lambda_u244_u24lambda_u243.getLockedAt(), this$0.now);
            it.set($this$updateRecord_u24lambda_u244_u24lambda_u243.getLockedBy(), (Object)this$0.getHostname());
            Integer n3 = (Integer)query$iv.execute(TransactionManager.Companion.current());
            bl = (n3 != null ? n3 : 0) > 0;
        }
        catch (SQLException e) {
            throw new LockException("Unexpected exception when locking", (Throwable)e);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final int unlock$lambda$7(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0, Transaction $this$transaction) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        try {
            void it;
            UpdateStatement query$iv;
            void $this$unlock_u24lambda_u247_u24lambda_u245;
            Op op;
            Expression expression = (Expression)Shedlock.INSTANCE.getLockedAt();
            Duration duration = $lockConfiguration.getLockAtLeastFor();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getLockAtLeastFor(...)");
            Expression<LocalDateTime> lockAtLeastUntil = ExposedIntervalExpressionKt.plus((Expression<LocalDateTime>)expression, duration);
            Table $this$update_u24default$iv = Shedlock.INSTANCE;
            Integer limit$iv = null;
            boolean $i$f$update = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Integer n2 = limit$iv;
            ColumnSet columnSet = (ColumnSet)$this$update_u24default$iv;
            boolean $i$a$-update$default-ExposedStorageAccessor$unlock$1$32 = false;
            Op op2 = op = OpKt.and((Expression)((Expression)$this$unlock_u24lambda_u247_u24lambda_u245.eq((ExpressionWithColumnType)Shedlock.INSTANCE.getName(), (Object)$lockConfiguration.getName())), (Expression)((Expression)$this$unlock_u24lambda_u247_u24lambda_u245.eq((ExpressionWithColumnType)Shedlock.INSTANCE.getLockedBy(), (Object)this$0.getHostname())));
            Integer n3 = n2;
            ColumnSet columnSet2 = columnSet;
            UpdateStatement $i$a$-update$default-ExposedStorageAccessor$unlock$1$32 = query$iv = new UpdateStatement(columnSet2, n3, op2);
            Shedlock $this$unlock_u24lambda_u247_u24lambda_u246 = (Shedlock)$this$update_u24default$iv;
            boolean bl = false;
            it.set($this$unlock_u24lambda_u247_u24lambda_u246.getLockUntil(), (Expression)new Case(null, 1, null).When((Expression)SqlExpressionBuilder.INSTANCE.greater(lockAtLeastUntil, this$0.now), lockAtLeastUntil).Else(this$0.now));
            Integer n4 = (Integer)query$iv.execute(TransactionManager.Companion.current());
            n = n4 != null ? n4 : 0;
        }
        catch (SQLException e) {
            throw new LockException("Unexpected exception when unlocking", (Throwable)e);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean extend$lambda$10(LockConfiguration $lockConfiguration, ExposedStorageAccessor this$0, Transaction $this$transaction) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        try {
            void it;
            UpdateStatement query$iv;
            void $this$extend_u24lambda_u2410_u24lambda_u248;
            Op op;
            Table $this$update_u24default$iv = Shedlock.INSTANCE;
            Integer limit$iv = null;
            boolean $i$f$update = false;
            SqlExpressionBuilder sqlExpressionBuilder = SqlExpressionBuilder.INSTANCE;
            Integer n = limit$iv;
            ColumnSet columnSet = (ColumnSet)$this$update_u24default$iv;
            boolean $i$a$-update$default-ExposedStorageAccessor$extend$1$32 = false;
            Op op2 = op = OpKt.and((Expression)((Expression)OpKt.and((Expression)((Expression)$this$extend_u24lambda_u2410_u24lambda_u248.eq((ExpressionWithColumnType)Shedlock.INSTANCE.getName(), (Object)$lockConfiguration.getName())), (Expression)((Expression)$this$extend_u24lambda_u2410_u24lambda_u248.eq((ExpressionWithColumnType)Shedlock.INSTANCE.getLockedBy(), (Object)this$0.getHostname())))), (Expression)((Expression)$this$extend_u24lambda_u2410_u24lambda_u248.greater((Expression)Shedlock.INSTANCE.getLockUntil(), this$0.now)));
            Integer n2 = n;
            ColumnSet columnSet2 = columnSet;
            UpdateStatement $i$a$-update$default-ExposedStorageAccessor$extend$1$32 = query$iv = new UpdateStatement(columnSet2, n2, op2);
            Shedlock $this$extend_u24lambda_u2410_u24lambda_u249 = (Shedlock)$this$update_u24default$iv;
            boolean bl2 = false;
            Column<LocalDateTime> column = $this$extend_u24lambda_u2410_u24lambda_u249.getLockUntil();
            Duration duration = $lockConfiguration.getLockAtMostFor();
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"getLockAtMostFor(...)");
            it.set(column, this$0.nowPlus(duration));
            Integer n3 = (Integer)query$iv.execute(TransactionManager.Companion.current());
            bl = (n3 != null ? n3 : 0) > 0;
        }
        catch (SQLException e) {
            throw new LockException("Unexpected exception when extending", (Throwable)e);
        }
        return bl;
    }
}

