/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.etcd.jetcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.Lease;
import io.etcd.jetcd.Txn;
import io.etcd.jetcd.kv.TxnResponse;
import io.etcd.jetcd.lease.LeaseGrantResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.CmpTarget;
import io.etcd.jetcd.op.Op;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;

public class EtcdLockProvider
implements LockProvider {
    private static final double MILLIS_IN_SECOND = 1000.0;
    private static final String KEY_PREFIX = "shedlock";
    private static final String ENV_DEFAULT = "default";
    private final EtcdTemplate etcdTemplate;
    private final String environment;

    public EtcdLockProvider(Client client) {
        this(client, ENV_DEFAULT);
    }

    public EtcdLockProvider(Client client, String environment) {
        this.etcdTemplate = new EtcdTemplate(client);
        this.environment = environment;
    }

    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        String key = this.buildKey(lockConfiguration.getName());
        String value = this.buildValue();
        Optional<Long> leaseIdOpt = this.etcdTemplate.tryToLock(key, value, lockConfiguration.getLockAtMostUntil());
        return leaseIdOpt.map(leaseId -> new EtcdLock(key, value, (Long)leaseId, this.etcdTemplate, lockConfiguration));
    }

    private static long getSecondsUntil(Instant instant) {
        return (long)Math.ceil((double)EtcdLockProvider.getMsUntil(instant) / 1000.0);
    }

    private static long getMsUntil(Instant instant) {
        return Duration.between(ClockProvider.now(), instant).toMillis();
    }

    private String buildValue() {
        return String.format("ADDED:%s@%s", Utils.toIsoString((Instant)ClockProvider.now()), Utils.getHostname());
    }

    String buildKey(String lockName) {
        return String.format("%s:%s:%s", KEY_PREFIX, this.environment, lockName);
    }

    private static class EtcdTemplate {
        private final KV kvClient;
        private final Lease leaseClient;

        private EtcdTemplate(Client client) {
            this.kvClient = client.getKVClient();
            this.leaseClient = client.getLeaseClient();
        }

        public Long createLease(long lockUntilInSeconds) {
            try {
                return ((LeaseGrantResponse)this.leaseClient.grant(lockUntilInSeconds).get()).getID();
            }
            catch (Exception e) {
                throw new LockException("Failed create lease", (Throwable)e);
            }
        }

        public Optional<Long> tryToLock(String key, String value, Instant lockAtMostUntil) {
            Long leaseId = this.createLease(EtcdLockProvider.getSecondsUntil(lockAtMostUntil));
            try {
                ByteSequence lockKey = this.toByteSequence(key);
                PutOption putOption = this.putOptionWithLeaseId(leaseId);
                Txn txn = this.kvClient.txn().If(new Cmp[]{new Cmp(lockKey, Cmp.Op.EQUAL, (CmpTarget)CmpTarget.version((long)0L))}).Then(new Op[]{Op.put((ByteSequence)lockKey, (ByteSequence)this.toByteSequence(value), (PutOption)putOption)}).Else(new Op[]{Op.get((ByteSequence)lockKey, (GetOption)GetOption.DEFAULT)});
                TxnResponse tr = (TxnResponse)txn.commit().get();
                if (tr.isSucceeded()) {
                    return Optional.of(leaseId);
                }
                this.revoke(leaseId);
                return Optional.empty();
            }
            catch (Exception e) {
                this.revoke(leaseId);
                throw new LockException("Failed to set lock " + key, (Throwable)e);
            }
        }

        public void revoke(Long leaseId) {
            try {
                this.leaseClient.revoke(leaseId.longValue()).get();
            }
            catch (Exception e) {
                throw new LockException("Failed to revoke lease " + leaseId, (Throwable)e);
            }
        }

        public void putWithLeaseId(String key, String value, Long leaseId) {
            ByteSequence lockKey = this.toByteSequence(key);
            ByteSequence lockValue = this.toByteSequence(value);
            PutOption putOption = this.putOptionWithLeaseId(leaseId);
            this.kvClient.put(lockKey, lockValue, putOption);
        }

        private ByteSequence toByteSequence(String key) {
            return ByteSequence.from((byte[])key.getBytes(StandardCharsets.UTF_8));
        }

        private PutOption putOptionWithLeaseId(Long leaseId) {
            return PutOption.builder().withLeaseId(leaseId.longValue()).build();
        }
    }

    private static final class EtcdLock
    extends AbstractSimpleLock {
        private final String key;
        private final String value;
        private final Long successLeaseId;
        private final EtcdTemplate etcdTemplate;

        private EtcdLock(String key, String value, Long successLeaseId, EtcdTemplate etcdTemplate, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.key = key;
            this.value = value;
            this.successLeaseId = successLeaseId;
            this.etcdTemplate = etcdTemplate;
        }

        public void doUnlock() {
            long keepLockFor = EtcdLockProvider.getSecondsUntil(this.lockConfiguration.getLockAtLeastUntil());
            if (keepLockFor <= 0L) {
                try {
                    this.etcdTemplate.revoke(this.successLeaseId);
                }
                catch (Exception e) {
                    throw new LockException("Can not revoke old leaseId " + this.successLeaseId, (Throwable)e);
                }
            } else {
                Long leaseId = this.etcdTemplate.createLease(keepLockFor);
                this.etcdTemplate.putWithLeaseId(this.key, this.value, leaseId);
                this.etcdTemplate.revoke(this.successLeaseId);
            }
        }
    }
}

