/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.elasticsearch8;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import org.elasticsearch.client.ResponseException;

public class ElasticsearchLockProvider
implements LockProvider {
    static final String SCHEDLOCK_DEFAULT_INDEX = "shedlock";
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String NAME = "name";
    private static final String UPDATE_SCRIPT = "if (ctx._source.lockUntil <= params.lockedAt) { ctx._source.lockedBy = params.lockedBy; ctx._source.lockedAt = params.lockedAt; ctx._source.lockUntil =  params.lockUntil; } else { ctx.op = 'none' }";
    private final ElasticsearchClient client;
    private final String hostname;
    private final String index;

    private ElasticsearchLockProvider(@NonNull ElasticsearchClient client, @NonNull String index) {
        this.client = client;
        this.hostname = Utils.getHostname();
        this.index = index;
    }

    public ElasticsearchLockProvider(@NonNull ElasticsearchClient client) {
        this(client, SCHEDLOCK_DEFAULT_INDEX);
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        try {
            Instant now = ClockProvider.now();
            Instant lockAtMostUntil = lockConfiguration.getLockAtMostUntil();
            Map<String, JsonData> lockObject = this.lockObject(lockConfiguration.getName(), lockAtMostUntil, now);
            Lock pojo = new Lock(lockConfiguration.getName(), this.hostname, now, lockAtMostUntil);
            UpdateRequest updateRequest = UpdateRequest.of(ur -> ur.index(this.index).id(lockConfiguration.getName()).refresh(Refresh.True).script(sc -> sc.inline(in -> (ObjectBuilder)in.lang("painless").source(UPDATE_SCRIPT).params(lockObject))).upsert((Object)pojo));
            UpdateResponse res = this.client.update(updateRequest, Lock.class);
            if (res.result() != Result.NoOp) {
                return Optional.of(new ElasticsearchSimpleLock(lockConfiguration));
            }
            return Optional.empty();
        }
        catch (ElasticsearchException | IOException e) {
            if (e instanceof ElasticsearchException && ((ElasticsearchException)e).status() == 409 || e instanceof ResponseException && ((ResponseException)e).getResponse().getStatusLine().getStatusCode() == 409) {
                return Optional.empty();
            }
            throw new LockException("Unexpected exception occurred", e);
        }
    }

    private Map<String, JsonData> lockObject(String name, Instant lockUntil, Instant lockedAt) {
        HashMap<String, JsonData> lock = new HashMap<String, JsonData>();
        lock.put(NAME, JsonData.of((Object)name));
        lock.put(LOCKED_BY, JsonData.of((Object)this.hostname));
        lock.put(LOCKED_AT, JsonData.of((Object)lockedAt.toEpochMilli()));
        lock.put(LOCK_UNTIL, JsonData.of((Object)lockUntil.toEpochMilli()));
        return lock;
    }

    private static final class Lock {
        private final String name;
        private final String lockedBy;
        private final long lockedAt;
        private final long lockUntil;

        public Lock(String name, String lockedBy, Instant lockedAt, Instant lockUntil) {
            this.name = name;
            this.lockedBy = lockedBy;
            this.lockedAt = lockedAt.toEpochMilli();
            this.lockUntil = lockUntil.toEpochMilli();
        }

        public String getName() {
            return this.name;
        }

        public String getLockedBy() {
            return this.lockedBy;
        }

        public long getLockedAt() {
            return this.lockedAt;
        }

        public long getLockUntil() {
            return this.lockUntil;
        }
    }

    private final class ElasticsearchSimpleLock
    extends AbstractSimpleLock {
        private ElasticsearchSimpleLock(LockConfiguration lockConfiguration) {
            super(lockConfiguration);
        }

        public void doUnlock() {
            try {
                Map<String, JsonData> lockObject = Collections.singletonMap("unlockTime", JsonData.of((Object)this.lockConfiguration.getUnlockTime().toEpochMilli()));
                UpdateRequest updateRequest = UpdateRequest.of(ur -> ur.index(ElasticsearchLockProvider.this.index).id(this.lockConfiguration.getName()).refresh(Refresh.True).script(sc -> sc.inline(in -> (ObjectBuilder)in.lang("painless").source("ctx._source.lockUntil = params.unlockTime").params(lockObject))));
                ElasticsearchLockProvider.this.client.update(updateRequest, Lock.class);
            }
            catch (ElasticsearchException | IOException e) {
                throw new LockException("Unexpected exception occurred", e);
            }
        }
    }
}

