/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.dynamodb2;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.utils.StringUtils;

public class DynamoDBLockProvider
implements LockProvider {
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String ID = "_id";
    static final String SORT = "_SortKey";
    private static final String OBTAIN_LOCK_QUERY = "set lockUntil = :lockUntil, lockedAt = :lockedAt, lockedBy = :lockedBy";
    private static final String OBTAIN_LOCK_CONDITION = "lockUntil <= :lockedAt or attribute_not_exists(lockUntil)";
    private static final String RELEASE_LOCK_QUERY = "set lockUntil = :lockUntil";
    private final String hostname;
    private final DynamoDbClient dynamoDbClient;
    private final String tableName;
    private final String partitionKeyName;
    private final String sortKeyName;

    public DynamoDBLockProvider(@NonNull DynamoDbClient dynamoDbClient, @NonNull String tableName) {
        this(dynamoDbClient, tableName, ID);
    }

    public DynamoDBLockProvider(@NonNull DynamoDbClient dynamoDbClient, @NonNull String tableName, @NonNull String partitionKeyName) {
        this(dynamoDbClient, tableName, partitionKeyName, null);
    }

    public DynamoDBLockProvider(@NonNull DynamoDbClient dynamoDbClient, @NonNull String tableName, @NonNull String partitionKeyName, String sortKeyName) {
        this.dynamoDbClient = Objects.requireNonNull(dynamoDbClient, "dynamoDbClient can not be null");
        this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
        this.partitionKeyName = Objects.requireNonNull(partitionKeyName, "partitionKeyName can not be null");
        this.sortKeyName = sortKeyName;
        this.hostname = Utils.getHostname();
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        String nowIso = Utils.toIsoString((Instant)ClockProvider.now());
        String lockUntilIso = Utils.toIsoString((Instant)lockConfiguration.getLockAtMostUntil());
        Map<String, AttributeValue> key = this.getKey(lockConfiguration);
        Map<String, AttributeValue> attributeUpdates = Map.of(":lockUntil", DynamoDBLockProvider.attr(lockUntilIso), ":lockedAt", DynamoDBLockProvider.attr(nowIso), ":lockedBy", DynamoDBLockProvider.attr(this.hostname));
        UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.tableName).key(key).updateExpression(OBTAIN_LOCK_QUERY).conditionExpression(OBTAIN_LOCK_CONDITION).expressionAttributeValues(attributeUpdates).returnValues(ReturnValue.UPDATED_NEW).build();
        try {
            this.dynamoDbClient.updateItem(request);
            return Optional.of(new DynamoDBLock(this.dynamoDbClient, this.tableName, lockConfiguration, key));
        }
        catch (ConditionalCheckFailedException e) {
            return Optional.empty();
        }
    }

    private Map<String, AttributeValue> getKey(LockConfiguration lockConfiguration) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put(this.partitionKeyName, DynamoDBLockProvider.attr(lockConfiguration.getName()));
        if (StringUtils.isNotBlank((CharSequence)this.sortKeyName)) {
            key.put(this.sortKeyName, DynamoDBLockProvider.attr(lockConfiguration.getName().concat(SORT)));
        }
        return key;
    }

    private static AttributeValue attr(String lockUntilIso) {
        return (AttributeValue)AttributeValue.builder().s(lockUntilIso).build();
    }

    private static final class DynamoDBLock
    extends AbstractSimpleLock {
        private final DynamoDbClient dynamoDbClient;
        private final String tableName;
        private final Map<String, AttributeValue> key;

        private DynamoDBLock(DynamoDbClient dynamoDbClient, String tableName, LockConfiguration lockConfiguration, Map<String, AttributeValue> key) {
            super(lockConfiguration);
            this.dynamoDbClient = dynamoDbClient;
            this.tableName = tableName;
            this.key = key;
        }

        public void doUnlock() {
            String unlockTimeIso = Utils.toIsoString((Instant)this.lockConfiguration.getUnlockTime());
            Map<String, AttributeValue> attributeUpdates = Collections.singletonMap(":lockUntil", DynamoDBLockProvider.attr(unlockTimeIso));
            UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.tableName).key(this.key).updateExpression(DynamoDBLockProvider.RELEASE_LOCK_QUERY).expressionAttributeValues(attributeUpdates).returnValues(ReturnValue.UPDATED_NEW).build();
            this.dynamoDbClient.updateItem(request);
        }
    }
}

