/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.dynamodb2;

import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class DynamoDBLockProvider
implements LockProvider {
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String ID = "_id";
    private static final String OBTAIN_LOCK_QUERY = "set lockUntil = :lockUntil, lockedAt = :lockedAt, lockedBy = :lockedBy";
    private static final String OBTAIN_LOCK_CONDITION = "lockUntil <= :lockedAt or attribute_not_exists(lockUntil)";
    private static final String RELEASE_LOCK_QUERY = "set lockUntil = :lockUntil";
    private final String hostname;
    private final DynamoDbClient dynamoDbClient;
    private final String tableName;

    public DynamoDBLockProvider(@NonNull DynamoDbClient dynamoDbClient, @NonNull String tableName) {
        this.dynamoDbClient = Objects.requireNonNull(dynamoDbClient, "dynamoDbClient can not be null");
        this.tableName = Objects.requireNonNull(tableName, "tableName can not be null");
        this.hostname = Utils.getHostname();
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        String nowIso = Utils.toIsoString((Instant)this.now());
        String lockUntilIso = Utils.toIsoString((Instant)lockConfiguration.getLockAtMostUntil());
        Map<String, AttributeValue> key = Collections.singletonMap(ID, DynamoDBLockProvider.attr(lockConfiguration.getName()));
        HashMap<String, AttributeValue> attributeUpdates = new HashMap<String, AttributeValue>(3);
        attributeUpdates.put(":lockUntil", DynamoDBLockProvider.attr(lockUntilIso));
        attributeUpdates.put(":lockedAt", DynamoDBLockProvider.attr(nowIso));
        attributeUpdates.put(":lockedBy", DynamoDBLockProvider.attr(this.hostname));
        UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.tableName).key(key).updateExpression(OBTAIN_LOCK_QUERY).conditionExpression(OBTAIN_LOCK_CONDITION).expressionAttributeValues(attributeUpdates).returnValues(ReturnValue.UPDATED_NEW).build();
        try {
            this.dynamoDbClient.updateItem(request);
            return Optional.of(new DynamoDBLock(this.dynamoDbClient, this.tableName, lockConfiguration));
        }
        catch (ConditionalCheckFailedException e) {
            return Optional.empty();
        }
    }

    private static AttributeValue attr(String lockUntilIso) {
        return (AttributeValue)AttributeValue.builder().s(lockUntilIso).build();
    }

    private Instant now() {
        return ClockProvider.now();
    }

    private static final class DynamoDBLock
    extends AbstractSimpleLock {
        private final DynamoDbClient dynamoDbClient;
        private final String tableName;

        private DynamoDBLock(DynamoDbClient dynamoDbClient, String tableName, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.dynamoDbClient = dynamoDbClient;
            this.tableName = tableName;
        }

        public void doUnlock() {
            String unlockTimeIso = Utils.toIsoString((Instant)this.lockConfiguration.getUnlockTime());
            Map<String, AttributeValue> key = Collections.singletonMap(DynamoDBLockProvider.ID, DynamoDBLockProvider.attr(this.lockConfiguration.getName()));
            Map<String, AttributeValue> attributeUpdates = Collections.singletonMap(":lockUntil", DynamoDBLockProvider.attr(unlockTimeIso));
            UpdateItemRequest request = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.tableName).key(key).updateExpression(DynamoDBLockProvider.RELEASE_LOCK_QUERY).expressionAttributeValues(attributeUpdates).returnValues(ReturnValue.UPDATED_NEW).build();
            this.dynamoDbClient.updateItem(request);
        }
    }
}

