/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.datastore;

import com.google.cloud.datastore.Datastore;
import java.util.Objects;
import net.javacrumbs.shedlock.provider.datastore.DatastoreStorageAccessor;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;

public class DatastoreLockProvider
extends StorageBasedLockProvider {
    public DatastoreLockProvider(Datastore datastore) {
        super((StorageAccessor)new DatastoreStorageAccessor(Configuration.builder().withDatastore(datastore).build()));
    }

    public DatastoreLockProvider(Configuration configuration) {
        super((StorageAccessor)new DatastoreStorageAccessor(configuration));
    }

    public static class Configuration {
        private final String entityName;
        private final FieldNames fieldNames;
        private final Datastore datastore;

        Configuration(String entityName, FieldNames fieldNames, Datastore datastore) {
            this.entityName = Objects.requireNonNull(entityName);
            this.fieldNames = Objects.requireNonNull(fieldNames);
            this.datastore = Objects.requireNonNull(datastore);
        }

        public String getEntityName() {
            return this.entityName;
        }

        public FieldNames getFieldNames() {
            return this.fieldNames;
        }

        public Datastore getDatastore() {
            return this.datastore;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String entityName = "lock";
            private FieldNames fieldNames = new FieldNames("lock_until", "locked_at", "locked_by");
            private Datastore datastore;

            public Builder withEntityName(String entityName) {
                this.entityName = entityName;
                return this;
            }

            public Builder withFieldNames(FieldNames fieldNames) {
                this.fieldNames = fieldNames;
                return this;
            }

            public Builder withDatastore(Datastore datastore) {
                this.datastore = datastore;
                return this;
            }

            public Configuration build() {
                return new Configuration(this.entityName, this.fieldNames, this.datastore);
            }
        }
    }

    public record FieldNames(String lockUntil, String lockedAt, String lockedBy) {
        public FieldNames(String lockUntil, String lockedAt, String lockedBy) {
            this.lockUntil = Objects.requireNonNull(lockUntil);
            this.lockedAt = Objects.requireNonNull(lockedAt);
            this.lockedBy = Objects.requireNonNull(lockedBy);
        }
    }
}

