/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.datastore;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.Transaction;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.datastore.DatastoreLockProvider;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatastoreStorageAccessor
extends AbstractStorageAccessor {
    private static final Logger log = LoggerFactory.getLogger(DatastoreStorageAccessor.class);
    private final Datastore datastore;
    private final String hostname;
    private final String entityName;
    private final DatastoreLockProvider.FieldNames fieldNames;

    public DatastoreStorageAccessor(DatastoreLockProvider.Configuration configuration) {
        Objects.requireNonNull(configuration);
        this.datastore = configuration.getDatastore();
        this.hostname = Utils.getHostname();
        this.entityName = configuration.getEntityName();
        this.fieldNames = configuration.getFieldNames();
    }

    public boolean insertRecord(LockConfiguration config) {
        return this.insert(config.getName(), config.getLockAtMostUntil());
    }

    public boolean updateRecord(LockConfiguration config) {
        return this.updateExisting(config.getName(), config.getLockAtMostUntil());
    }

    public void unlock(LockConfiguration config) {
        this.updateOwn(config.getName(), config.getUnlockTime());
    }

    public boolean extend(LockConfiguration config) {
        return this.updateOwn(config.getName(), config.getLockAtMostUntil());
    }

    private boolean insert(String name, Instant until) {
        return this.doInTxn(txn -> {
            KeyFactory keyFactory = (KeyFactory)this.datastore.newKeyFactory().setKind(this.entityName);
            Key key = keyFactory.newKey(name);
            Entity entity = ((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.newBuilder((Key)key).set(this.fieldNames.lockUntil(), DatastoreStorageAccessor.fromInstant(until))).set(this.fieldNames.lockedAt(), DatastoreStorageAccessor.fromInstant(ClockProvider.now()))).set(this.fieldNames.lockedBy(), this.hostname)).build();
            txn.add((FullEntity)entity);
            return Optional.of(true);
        }).orElse(false);
    }

    private boolean updateExisting(String name, Instant until) {
        return this.doInTxn(txn -> this.get(name, (Transaction)txn).filter(entity -> {
            Instant now = ClockProvider.now();
            Instant lockUntilTs = DatastoreStorageAccessor.nullableTimestamp(entity, this.fieldNames.lockUntil());
            return lockUntilTs != null && lockUntilTs.isBefore(now);
        }).map(entity -> {
            txn.put((FullEntity)((Entity.Builder)((Entity.Builder)((Entity.Builder)Entity.newBuilder((Entity)entity).set(this.fieldNames.lockUntil(), DatastoreStorageAccessor.fromInstant(until))).set(this.fieldNames.lockedAt(), DatastoreStorageAccessor.fromInstant(ClockProvider.now()))).set(this.fieldNames.lockedBy(), this.hostname)).build());
            return true;
        })).orElse(false);
    }

    private boolean updateOwn(String name, Instant until) {
        return this.doInTxn(txn -> this.get(name, (Transaction)txn).filter(entity -> this.hostname.equals(DatastoreStorageAccessor.nullableString(entity, this.fieldNames.lockedBy()))).filter(entity -> {
            Instant now = ClockProvider.now();
            Instant lockUntilTs = DatastoreStorageAccessor.nullableTimestamp(entity, this.fieldNames.lockUntil());
            return lockUntilTs != null && (lockUntilTs.isAfter(now) || lockUntilTs.equals(now));
        }).map(entity -> {
            txn.put((FullEntity)((Entity.Builder)Entity.newBuilder((Entity)entity).set(this.fieldNames.lockUntil(), DatastoreStorageAccessor.fromInstant(until))).build());
            return true;
        })).orElse(false);
    }

    public Optional<Lock> findLock(String name) {
        return this.get(name).map(entity -> new Lock(((Key)entity.getKey()).getName(), DatastoreStorageAccessor.nullableTimestamp(entity, this.fieldNames.lockedAt()), DatastoreStorageAccessor.nullableTimestamp(entity, this.fieldNames.lockUntil()), DatastoreStorageAccessor.nullableString(entity, this.fieldNames.lockedBy())));
    }

    private Optional<Entity> get(String name) {
        KeyFactory keyFactory = (KeyFactory)this.datastore.newKeyFactory().setKind(this.entityName);
        Key key = keyFactory.newKey(name);
        return Optional.ofNullable(this.datastore.get(key));
    }

    private Optional<Entity> get(String name, Transaction txn) {
        KeyFactory keyFactory = (KeyFactory)this.datastore.newKeyFactory().setKind(this.entityName);
        Key key = keyFactory.newKey(name);
        return Optional.ofNullable(txn.get(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Optional<T> doInTxn(Function<Transaction, Optional<T>> work) {
        Transaction txn = this.datastore.newTransaction();
        try {
            Optional<T> result = work.apply(txn);
            txn.commit();
            Optional<T> optional = result;
            return optional;
        }
        catch (DatastoreException ex) {
            log.debug("Unable to perform a transactional unit of work: {}", (Object)ex.getMessage());
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            if (txn.isActive()) {
                txn.rollback();
            }
        }
    }

    private static String nullableString(Entity entity, String property) {
        return entity.contains(property) ? entity.getString(property) : null;
    }

    private static Instant nullableTimestamp(Entity entity, String property) {
        return entity.contains(property) ? DatastoreStorageAccessor.toInstant(entity.getTimestamp(property)) : null;
    }

    private static com.google.cloud.Timestamp fromInstant(Instant instant) {
        return com.google.cloud.Timestamp.of((Timestamp)Timestamp.from(Objects.requireNonNull(instant)));
    }

    private static Instant toInstant(com.google.cloud.Timestamp timestamp) {
        return Objects.requireNonNull(timestamp).toSqlTimestamp().toInstant();
    }

    public record Lock(String name, Instant lockedAt, Instant lockedUntil, String lockedBy) {
    }
}

