/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.couchbase.javaclient3;

import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.ReplaceOptions;
import java.time.Instant;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public class CouchbaseLockProvider
extends StorageBasedLockProvider {
    private static final String LOCK_NAME = "name";
    static final String LOCK_UNTIL = "lockedUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";

    public CouchbaseLockProvider(Bucket bucket) {
        this(new CouchbaseAccessor(bucket));
    }

    CouchbaseLockProvider(CouchbaseAccessor couchbaseAccessor) {
        super((StorageAccessor)couchbaseAccessor);
    }

    private static class CouchbaseAccessor
    extends AbstractStorageAccessor {
        private final Bucket bucket;

        CouchbaseAccessor(Bucket bucket) {
            this.bucket = bucket;
        }

        public boolean insertRecord(@NonNull LockConfiguration lockConfiguration) {
            JsonObject content = JsonObject.create().put(CouchbaseLockProvider.LOCK_NAME, lockConfiguration.getName()).put(CouchbaseLockProvider.LOCK_UNTIL, Utils.toIsoString((Instant)lockConfiguration.getLockAtMostUntil())).put(CouchbaseLockProvider.LOCKED_AT, Utils.toIsoString((Instant)ClockProvider.now())).put(CouchbaseLockProvider.LOCKED_BY, this.getHostname());
            try {
                this.bucket.defaultCollection().insert(lockConfiguration.getName(), (Object)content);
            }
            catch (DocumentExistsException e) {
                return false;
            }
            return true;
        }

        private Instant parse(Object instant) {
            return Instant.parse((String)instant);
        }

        public boolean updateRecord(@NonNull LockConfiguration lockConfiguration) {
            Instant now;
            Collection collection = this.bucket.defaultCollection();
            GetResult result = collection.get(lockConfiguration.getName());
            JsonObject document = result.contentAsObject();
            Instant lockUntil = this.parse(document.get(CouchbaseLockProvider.LOCK_UNTIL));
            if (lockUntil.isAfter(now = ClockProvider.now())) {
                return false;
            }
            document.put(CouchbaseLockProvider.LOCK_UNTIL, Utils.toIsoString((Instant)lockConfiguration.getLockAtMostUntil()));
            document.put(CouchbaseLockProvider.LOCKED_AT, Utils.toIsoString((Instant)now));
            document.put(CouchbaseLockProvider.LOCKED_BY, this.getHostname());
            try {
                collection.replace(lockConfiguration.getName(), (Object)document, ReplaceOptions.replaceOptions().cas(result.cas()));
            }
            catch (CasMismatchException e) {
                return false;
            }
            return true;
        }

        public boolean extend(@NonNull LockConfiguration lockConfiguration) {
            Instant now;
            Collection collection = this.bucket.defaultCollection();
            GetResult result = collection.get(lockConfiguration.getName());
            JsonObject document = result.contentAsObject();
            Instant lockUntil = this.parse(document.get(CouchbaseLockProvider.LOCK_UNTIL));
            if (lockUntil.isBefore(now = ClockProvider.now()) || !document.get(CouchbaseLockProvider.LOCKED_BY).equals(this.getHostname())) {
                return false;
            }
            document.put(CouchbaseLockProvider.LOCK_UNTIL, Utils.toIsoString((Instant)lockConfiguration.getLockAtMostUntil()));
            try {
                collection.replace(lockConfiguration.getName(), (Object)document, ReplaceOptions.replaceOptions().cas(result.cas()));
            }
            catch (CasMismatchException e) {
                return false;
            }
            return true;
        }

        public void unlock(@NonNull LockConfiguration lockConfiguration) {
            Collection collection = this.bucket.defaultCollection();
            GetResult result = collection.get(lockConfiguration.getName());
            JsonObject document = result.contentAsObject();
            document.put(CouchbaseLockProvider.LOCK_UNTIL, Utils.toIsoString((Instant)lockConfiguration.getUnlockTime()));
            collection.replace(lockConfiguration.getName(), (Object)document);
        }
    }
}

