/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import java.util.Objects;
import net.javacrumbs.shedlock.provider.cassandra.CassandraStorageAccessor;
import net.javacrumbs.shedlock.support.StorageAccessor;
import net.javacrumbs.shedlock.support.StorageBasedLockProvider;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public class CassandraLockProvider
extends StorageBasedLockProvider {
    static final String DEFAULT_TABLE = "lock";

    public CassandraLockProvider(@NonNull CqlSession cqlSession) {
        this(cqlSession, DEFAULT_TABLE, ConsistencyLevel.QUORUM);
    }

    public CassandraLockProvider(@NonNull CqlSession cqlSession, @NonNull String table, @NonNull ConsistencyLevel consistencyLevel) {
        this(Configuration.builder().withCqlSession(cqlSession).withTableName(table).withConsistencyLevel(consistencyLevel).build());
    }

    public CassandraLockProvider(@NonNull Configuration configuration) {
        super((StorageAccessor)new CassandraStorageAccessor(configuration));
    }

    public static final class Configuration {
        private final String table;
        private final ColumnNames columnNames;
        private final CqlSession cqlSession;
        private final ConsistencyLevel consistencyLevel;

        Configuration(@NonNull CqlSession cqlSession, @NonNull String table, @NonNull ColumnNames columnNames, @NonNull ConsistencyLevel consistencyLevel) {
            this.table = Objects.requireNonNull(table, "table can not be null");
            this.columnNames = Objects.requireNonNull(columnNames, "columnNames can not be null");
            this.cqlSession = Objects.requireNonNull(cqlSession, "cqlSession can not be null");
            this.consistencyLevel = Objects.requireNonNull(consistencyLevel, "consistencyLevel column can not be null");
        }

        public ColumnNames getColumnNames() {
            return this.columnNames;
        }

        public String getTable() {
            return this.table;
        }

        public CqlSession getCqlSession() {
            return this.cqlSession;
        }

        public ConsistencyLevel getConsistencyLevel() {
            return this.consistencyLevel;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String table;
            private ColumnNames columnNames = new ColumnNames("name", "lockUntil", "lockedAt", "lockedBy");
            private CqlSession cqlSession;
            private ConsistencyLevel consistencyLevel;

            public Builder withTableName(@NonNull String table) {
                this.table = table;
                return this;
            }

            public Builder withColumnNames(ColumnNames columnNames) {
                this.columnNames = columnNames;
                return this;
            }

            public Builder withCqlSession(@NonNull CqlSession cqlSession) {
                this.cqlSession = cqlSession;
                return this;
            }

            public Builder withConsistencyLevel(@NonNull ConsistencyLevel consistencyLevel) {
                this.consistencyLevel = consistencyLevel;
                return this;
            }

            public Configuration build() {
                return new Configuration(this.cqlSession, this.table, this.columnNames, this.consistencyLevel);
            }
        }
    }

    public static final class ColumnNames {
        private final String lockName;
        private final String lockUntil;
        private final String lockedAt;
        private final String lockedBy;

        public ColumnNames(String lockName, String lockUntil, String lockedAt, String lockedBy) {
            this.lockName = Objects.requireNonNull(lockName, "'lockName' column name can not be null");
            this.lockUntil = Objects.requireNonNull(lockUntil, "'lockUntil' column name can not be null");
            this.lockedAt = Objects.requireNonNull(lockedAt, "'lockedAt' column name can not be null");
            this.lockedBy = Objects.requireNonNull(lockedBy, "'lockedBy' column name can not be null");
        }

        public String getLockName() {
            return this.lockName;
        }

        public String getLockUntil() {
            return this.lockUntil;
        }

        public String getLockedAt() {
            return this.lockedAt;
        }

        public String getLockedBy() {
            return this.lockedBy;
        }
    }
}

