/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.provider.cassandra.Lock;
import net.javacrumbs.shedlock.support.AbstractStorageAccessor;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;

class CassandraStorageAccessor
extends AbstractStorageAccessor {
    private static final String LOCK_NAME = "name";
    private static final String LOCK_UNTIL = "lockUntil";
    private static final String LOCKED_AT = "lockedAt";
    private static final String LOCKED_BY = "lockedBy";
    private final String hostname = Utils.getHostname();
    private final String table;
    private final CqlSession cqlSession;
    private final ConsistencyLevel consistencyLevel;

    CassandraStorageAccessor(@NonNull CqlSession cqlSession, @NonNull String table, @NonNull ConsistencyLevel consistencyLevel) {
        this.table = table;
        this.cqlSession = cqlSession;
        this.consistencyLevel = consistencyLevel;
    }

    public boolean insertRecord(@NonNull LockConfiguration lockConfiguration) {
        if (this.find(lockConfiguration.getName()).isPresent()) {
            return false;
        }
        return this.insert(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil());
    }

    public boolean updateRecord(@NonNull LockConfiguration lockConfiguration) {
        Optional<Lock> lock = this.find(lockConfiguration.getName());
        if (!lock.isPresent() || lock.get().getLockUntil().isAfter(ClockProvider.now())) {
            return false;
        }
        return this.update(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil());
    }

    public void unlock(@NonNull LockConfiguration lockConfiguration) {
        this.updateUntil(lockConfiguration.getName(), lockConfiguration.getUnlockTime());
    }

    public boolean extend(@NonNull LockConfiguration lockConfiguration) {
        Optional<Lock> lock = this.find(lockConfiguration.getName());
        if (!lock.isPresent() || lock.get().getLockUntil().isBefore(ClockProvider.now()) || !lock.get().getLockedBy().equals(this.hostname)) {
            this.logger.trace("extend false");
            return false;
        }
        return this.updateUntil(lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil());
    }

    Optional<Lock> find(String name) {
        SimpleStatement selectStatement = (SimpleStatement)((Select)QueryBuilder.selectFrom((String)this.table).column(LOCK_UNTIL).column(LOCKED_AT).column(LOCKED_BY).whereColumn(LOCK_NAME).isEqualTo((Term)QueryBuilder.literal((Object)name))).build().setConsistencyLevel(this.consistencyLevel);
        ResultSet resultSet = this.cqlSession.execute((Statement)selectStatement);
        Row row = (Row)resultSet.one();
        if (row != null) {
            return Optional.of(new Lock(row.getInstant(LOCK_UNTIL), row.getInstant(LOCKED_AT), row.getString(LOCKED_BY)));
        }
        return Optional.empty();
    }

    private boolean insert(String name, Instant until) {
        return this.execute(QueryBuilder.insertInto((String)this.table).value(LOCK_NAME, (Term)QueryBuilder.literal((Object)name)).value(LOCK_UNTIL, (Term)QueryBuilder.literal((Object)until)).value(LOCKED_AT, (Term)QueryBuilder.literal((Object)ClockProvider.now())).value(LOCKED_BY, (Term)QueryBuilder.literal((Object)this.hostname)).ifNotExists().build());
    }

    private boolean update(String name, Instant until) {
        return this.execute(((Update)((Update)QueryBuilder.update((String)this.table).setColumn(LOCK_UNTIL, (Term)QueryBuilder.literal((Object)until)).setColumn(LOCKED_AT, (Term)QueryBuilder.literal((Object)ClockProvider.now())).setColumn(LOCKED_BY, (Term)QueryBuilder.literal((Object)this.hostname)).whereColumn(LOCK_NAME).isEqualTo((Term)QueryBuilder.literal((Object)name))).ifColumn(LOCK_UNTIL).isLessThan((Term)QueryBuilder.literal((Object)ClockProvider.now()))).build());
    }

    private boolean updateUntil(String name, Instant until) {
        return this.execute(((Update)((Update)((Update)QueryBuilder.update((String)this.table).setColumn(LOCK_UNTIL, (Term)QueryBuilder.literal((Object)until)).whereColumn(LOCK_NAME).isEqualTo((Term)QueryBuilder.literal((Object)name))).ifColumn(LOCK_UNTIL).isGreaterThanOrEqualTo((Term)QueryBuilder.literal((Object)ClockProvider.now()))).ifColumn(LOCKED_BY).isEqualTo((Term)QueryBuilder.literal((Object)this.hostname))).build());
    }

    private boolean execute(SimpleStatement statement) {
        return this.cqlSession.execute(statement.setConsistencyLevel(this.consistencyLevel)).wasApplied();
    }
}

