/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.provider.arangodb;

import com.arangodb.ArangoCollection;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.StreamTransactionEntity;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.StreamTransactionOptions;
import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.AbstractSimpleLock;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockException;
import net.javacrumbs.shedlock.support.Utils;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public class ArangoLockProvider
implements LockProvider {
    static final String LOCK_UNTIL = "lockUntil";
    static final String LOCKED_AT = "lockedAt";
    static final String LOCKED_BY = "lockedBy";
    static final String COLLECTION_NAME = "shedLock";
    private final ArangoCollection arangoCollection;

    public ArangoLockProvider(@NonNull ArangoDatabase arangoDatabase) {
        this(arangoDatabase.collection(COLLECTION_NAME));
    }

    public ArangoLockProvider(@NonNull ArangoCollection arangoCollection) {
        this.arangoCollection = arangoCollection;
    }

    @NonNull
    public Optional<SimpleLock> lock(@NonNull LockConfiguration lockConfiguration) {
        Optional<SimpleLock> optional;
        block12: {
            String transactionId;
            block10: {
                Optional<ArangoLock> optional2;
                block11: {
                    BaseDocument existingDocument;
                    block8: {
                        Optional<ArangoLock> optional3;
                        block9: {
                            transactionId = null;
                            StreamTransactionEntity streamTransactionEntity = this.arangoCollection.db().beginStreamTransaction(new StreamTransactionOptions().exclusiveCollections(new String[]{this.arangoCollection.name()}));
                            transactionId = streamTransactionEntity.getId();
                            existingDocument = (BaseDocument)this.arangoCollection.getDocument(lockConfiguration.getName(), BaseDocument.class, (DocumentReadOptions)new DocumentReadOptions().streamTransactionId(transactionId));
                            if (existingDocument != null) break block8;
                            BaseDocument newDocument = this.insertNewLock(transactionId, lockConfiguration.getName(), lockConfiguration.getLockAtMostUntil());
                            optional3 = Optional.of(new ArangoLock(this.arangoCollection, newDocument, lockConfiguration));
                            if (transactionId == null) break block9;
                            this.arangoCollection.db().commitStreamTransaction(transactionId);
                        }
                        return optional3;
                    }
                    Instant lockUntil = Instant.parse(existingDocument.getAttribute(LOCK_UNTIL).toString());
                    if (lockUntil.compareTo(ClockProvider.now()) > 0) break block10;
                    this.updateLockAtMostUntil(transactionId, existingDocument, lockConfiguration.getLockAtMostUntil());
                    optional2 = Optional.of(new ArangoLock(this.arangoCollection, existingDocument, lockConfiguration));
                    if (transactionId == null) break block11;
                    this.arangoCollection.db().commitStreamTransaction(transactionId);
                }
                return optional2;
            }
            try {
                optional = Optional.empty();
                if (transactionId == null) break block12;
            }
            catch (ArangoDBException e) {
                try {
                    if (transactionId != null) {
                        this.arangoCollection.db().abortStreamTransaction(transactionId);
                    }
                    throw new LockException("Unexpected error occured", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (transactionId != null) {
                        this.arangoCollection.db().commitStreamTransaction(transactionId);
                    }
                    throw throwable;
                }
            }
            this.arangoCollection.db().commitStreamTransaction(transactionId);
        }
        return optional;
    }

    private BaseDocument insertNewLock(String transactionId, String documentKey, Instant lockAtMostUntil) throws ArangoDBException {
        BaseDocument newDocument = new BaseDocument();
        newDocument.setKey(documentKey);
        this.setDocumentAttributes(newDocument, lockAtMostUntil);
        DocumentCreateEntity document = this.arangoCollection.insertDocument((Object)newDocument, ((DocumentCreateOptions)new DocumentCreateOptions().streamTransactionId(transactionId)).returnNew(Boolean.valueOf(true)));
        return (BaseDocument)document.getNew();
    }

    private void updateLockAtMostUntil(String transactionId, BaseDocument existingDocument, Instant lockAtMostUntil) {
        this.setDocumentAttributes(existingDocument, lockAtMostUntil);
        this.arangoCollection.updateDocument(existingDocument.getKey(), (Object)existingDocument, (DocumentUpdateOptions)new DocumentUpdateOptions().streamTransactionId(transactionId));
    }

    private void setDocumentAttributes(BaseDocument baseDocument, Instant lockAtMostUntil) {
        baseDocument.addAttribute(LOCK_UNTIL, (Object)Utils.toIsoString((Instant)lockAtMostUntil));
        baseDocument.addAttribute(LOCKED_AT, (Object)Utils.toIsoString((Instant)ClockProvider.now()));
        baseDocument.addAttribute(LOCKED_BY, (Object)Utils.getHostname());
    }

    private static final class ArangoLock
    extends AbstractSimpleLock {
        private final ArangoCollection arangoCollection;
        private final BaseDocument document;

        public ArangoLock(ArangoCollection arangoCollection, BaseDocument document, LockConfiguration lockConfiguration) {
            super(lockConfiguration);
            this.arangoCollection = arangoCollection;
            this.document = document;
        }

        protected void doUnlock() {
            try {
                this.document.addAttribute(ArangoLockProvider.LOCK_UNTIL, (Object)Utils.toIsoString((Instant)this.lockConfiguration.getUnlockTime()));
                this.arangoCollection.updateDocument(this.lockConfiguration.getName(), (Object)this.document);
            }
            catch (ArangoDBException e) {
                throw new LockException("Unexpected error occured", (Throwable)e);
            }
        }
    }
}

