/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.util.Deque;
import java.util.LinkedList;

public final class LockAssert {
    private static final ThreadLocal<Deque<String>> activeLocksTL = ThreadLocal.withInitial(() -> null);

    private LockAssert() {
    }

    static void startLock(String name) {
        LockAssert.activeLocks().add(name);
    }

    static boolean alreadyLockedBy(String name) {
        Deque<String> activeLocks = activeLocksTL.get();
        return activeLocks != null && activeLocks.contains(name);
    }

    static void endLock() {
        Deque<String> activeLocks = LockAssert.activeLocks();
        activeLocks.removeLast();
        if (activeLocks.isEmpty()) {
            activeLocksTL.remove();
        }
    }

    private static Deque<String> activeLocks() {
        if (activeLocksTL.get() == null) {
            activeLocksTL.set(new LinkedList());
        }
        return activeLocksTL.get();
    }

    public static void assertLocked() {
        Deque<String> activeLocks = activeLocksTL.get();
        if (activeLocks == null || activeLocks.isEmpty()) {
            throw new IllegalStateException("The task is not locked.");
        }
    }

    public static class TestHelper {
        private static final String TEST_LOCK_NAME = "net.javacrumbs.shedlock.core.test-lock";

        public static void makeAllAssertsPass(boolean pass) {
            if (pass) {
                LockAssert.startLock(TEST_LOCK_NAME);
            } else {
                LockAssert.endLock();
            }
        }
    }
}

