/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import net.javacrumbs.shedlock.core.LockConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LockingTaskExecutor {
    public void executeWithLock(@NotNull Runnable var1, @NotNull LockConfiguration var2);

    public void executeWithLock(@NotNull Task var1, @NotNull LockConfiguration var2) throws Throwable;

    @NotNull
    default public <T> TaskResult<T> executeWithLock(@NotNull TaskWithResult<T> task, @NotNull LockConfiguration lockConfig) throws Throwable {
        throw new UnsupportedOperationException();
    }

    public static final class TaskResult<T> {
        private final boolean executed;
        private final T result;

        private TaskResult(boolean executed, @Nullable T result) {
            this.executed = executed;
            this.result = result;
        }

        public boolean wasExecuted() {
            return this.executed;
        }

        @Nullable
        public T getResult() {
            return this.result;
        }

        static <T> TaskResult<T> result(@Nullable T result) {
            return new TaskResult<T>(true, result);
        }

        static <T> TaskResult<T> notExecuted() {
            return new TaskResult<Object>(false, null);
        }
    }

    @FunctionalInterface
    public static interface TaskWithResult<T> {
        public T call() throws Throwable;
    }

    @FunctionalInterface
    public static interface Task {
        public void call() throws Throwable;
    }
}

