/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import org.jetbrains.annotations.NotNull;

public class LockAssert {
    private static final ThreadLocal<String> currentLockName = ThreadLocal.withInitial(() -> null);

    static void startLock(String name) {
        currentLockName.set(name);
    }

    static boolean alreadyLockedBy(@NotNull String name) {
        return name.equals(currentLockName.get());
    }

    static void endLock() {
        currentLockName.remove();
    }

    public static void assertLocked() {
        if (currentLockName.get() == null) {
            throw new IllegalStateException("The task is not locked.");
        }
    }
}

