/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.time.Duration;
import java.util.Optional;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.annotation.NonNull;

public final class LockExtender {
    private static final ThreadLocal<SimpleLock> activeLock = ThreadLocal.withInitial(() -> null);

    private LockExtender() {
    }

    public static void extendActiveLock(@NonNull Duration lockAtMostFor, @NonNull Duration lockAtLeastFor) {
        SimpleLock lock = activeLock.get();
        if (lock == null) {
            throw new NoActiveLockException();
        }
        Optional<SimpleLock> newLock = lock.extend(lockAtMostFor, lockAtLeastFor);
        if (!newLock.isPresent()) {
            throw new LockCanNotBeExtendedException();
        }
        activeLock.set(newLock.get());
    }

    static void startLock(@NonNull SimpleLock lock) {
        activeLock.set(lock);
    }

    static SimpleLock endLock() {
        SimpleLock lock = activeLock.get();
        activeLock.remove();
        return lock;
    }

    public static class NoActiveLockException
    extends LockExtensionException {
        public NoActiveLockException() {
            super("No active lock in current thread, please make sure that you execute LockExtender.extendActiveLock in locked context.");
        }
    }

    public static class LockCanNotBeExtendedException
    extends LockExtensionException {
        public LockCanNotBeExtendedException() {
            super("Lock can not be extended, most likely it already expired.");
        }
    }

    public static class LockExtensionException
    extends RuntimeException {
        public LockExtensionException(String message) {
            super(message);
        }
    }
}

