/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.time.Instant;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.SimpleLock;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSimpleLock
implements SimpleLock {
    private boolean valid = true;
    protected final LockConfiguration lockConfiguration;

    protected AbstractSimpleLock(LockConfiguration lockConfiguration) {
        this.lockConfiguration = lockConfiguration;
    }

    @Override
    public final void unlock() {
        this.checkValidity();
        this.doUnlock();
        this.valid = false;
    }

    protected abstract void doUnlock();

    @Override
    @NotNull
    public final Optional<SimpleLock> extend(@NotNull Instant lockAtMostUntil, @NotNull Instant lockAtLeastUntil) {
        this.checkValidity();
        Optional<SimpleLock> result = this.doExtend(new LockConfiguration(this.lockConfiguration.getName(), lockAtMostUntil, lockAtLeastUntil));
        this.valid = false;
        return result;
    }

    protected Optional<SimpleLock> doExtend(LockConfiguration newConfiguration) {
        throw new UnsupportedOperationException();
    }

    private void checkValidity() {
        if (!this.valid) {
            throw new IllegalStateException("Lock is not valid, it has already been unlocked or extended");
        }
    }
}

