/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.support;

import java.util.Date;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import net.javacrumbs.shedlock.support.LockRecordRegistry;
import net.javacrumbs.shedlock.support.StorageAccessor;

public class StorageBasedLockProvider
implements LockProvider {
    private final StorageAccessor storageAccessor;
    private final LockRecordRegistry lockRecordRegistry = new LockRecordRegistry();

    protected StorageBasedLockProvider(StorageAccessor storageAccessor) {
        this.storageAccessor = storageAccessor;
    }

    @Override
    public Optional<SimpleLock> lock(LockConfiguration lockConfiguration) {
        boolean lockObtained = this.doLock(lockConfiguration);
        if (lockObtained) {
            return Optional.of(new StorageLock(lockConfiguration, this.storageAccessor));
        }
        return Optional.empty();
    }

    protected boolean doLock(LockConfiguration lockConfiguration) {
        String name = lockConfiguration.getName();
        if (!this.lockRecordRegistry.lockRecordRecentlyCreated(name)) {
            if (this.storageAccessor.insertRecord(lockConfiguration)) {
                this.lockRecordRegistry.addLockRecord(name);
                return true;
            }
            this.lockRecordRegistry.addLockRecord(name);
        }
        return this.storageAccessor.updateRecord(lockConfiguration);
    }

    protected static Date now() {
        return new Date();
    }

    private static class StorageLock
    implements SimpleLock {
        private final LockConfiguration lockConfiguration;
        private final StorageAccessor storageAccessor;

        StorageLock(LockConfiguration lockConfiguration, StorageAccessor storageAccessor) {
            this.lockConfiguration = lockConfiguration;
            this.storageAccessor = storageAccessor;
        }

        @Override
        public void unlock() {
            this.storageAccessor.unlock(this.lockConfiguration);
        }
    }
}

