/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.time.Instant;
import java.util.Objects;

public class LockConfiguration {
    private final String name;
    private final Instant lockAtMostUntil;
    private final Instant lockAtLeastUntil;

    public LockConfiguration(String name, Instant lockAtMostUntil) {
        this(name, lockAtMostUntil, Instant.now());
    }

    public LockConfiguration(String name, Instant lockAtMostUntil, Instant lockAtLeastUntil) {
        this.name = Objects.requireNonNull(name);
        this.lockAtMostUntil = Objects.requireNonNull(lockAtMostUntil);
        this.lockAtLeastUntil = Objects.requireNonNull(lockAtLeastUntil);
        if (lockAtLeastUntil.isAfter(lockAtMostUntil)) {
            throw new IllegalArgumentException("lockAtMostUntil is before lockAtLeastUntil for lock '" + name + "'.");
        }
        if (lockAtMostUntil.isBefore(Instant.now())) {
            throw new IllegalArgumentException("lockAtMostUntil is in the past for lock '" + name + "'.");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("lock name can not be empty");
        }
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public Instant getLockUntil() {
        return this.lockAtMostUntil;
    }

    public Instant getLockAtMostUntil() {
        return this.lockAtMostUntil;
    }

    public Instant getLockAtLeastUntil() {
        return this.lockAtLeastUntil;
    }

    public Instant getUnlockTime() {
        Instant now = Instant.now();
        return this.lockAtLeastUntil.isAfter(now) ? this.lockAtLeastUntil : now;
    }

    public String toString() {
        return "LockConfiguration{name='" + this.name + '\'' + ", lockAtMostUntil=" + this.lockAtMostUntil + ", lockAtLeastUntil=" + this.lockAtLeastUntil + '}';
    }
}

