/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.core;

import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockConfigurationExtractor;
import net.javacrumbs.shedlock.core.LockManager;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.SimpleLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLockManager
implements LockManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultLockManager.class);
    private final LockProvider lockProvider;
    private final LockConfigurationExtractor lockConfigurationExtractor;

    public DefaultLockManager(LockProvider lockProvider, LockConfigurationExtractor lockConfigurationExtractor) {
        this.lockProvider = Objects.requireNonNull(lockProvider);
        this.lockConfigurationExtractor = Objects.requireNonNull(lockConfigurationExtractor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeIfNotLocked(Runnable task) {
        Optional<LockConfiguration> lockConfigOptional = this.lockConfigurationExtractor.getLockConfiguration(task);
        if (!lockConfigOptional.isPresent()) {
            logger.debug("No lock configuration for {}. Executing without lock.", (Object)task);
            task.run();
        } else {
            LockConfiguration lockConfig = lockConfigOptional.get();
            Optional<SimpleLock> lock = this.lockProvider.lock(lockConfig);
            if (lock.isPresent()) {
                try {
                    logger.debug("Locked {}.", (Object)lockConfig.getName());
                    task.run();
                }
                finally {
                    lock.get().unlock();
                    logger.debug("Unlocked {}.", (Object)lockConfig.getName());
                }
            } else {
                logger.info("Not executing {}. It's locked.", (Object)lockConfig.getName());
            }
        }
    }
}

