/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.cdi.internal;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.cdi.SchedulerLock;
import net.javacrumbs.shedlock.cdi.internal.CdiLockConfigurationExtractor;
import net.javacrumbs.shedlock.cdi.internal.LockingNotSupportedException;
import net.javacrumbs.shedlock.cdi.internal.Utils;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jspecify.annotations.Nullable;

@SchedulerLock(name="?")
@Priority(value=3001)
@Interceptor
public class SchedulerLockInterceptor {
    private final LockingTaskExecutor lockingTaskExecutor;
    private final CdiLockConfigurationExtractor lockConfigurationExtractor;

    @Inject
    public SchedulerLockInterceptor(LockProvider lockProvider) {
        this.lockingTaskExecutor = new DefaultLockingTaskExecutor(lockProvider);
        String lockAtMostFor = SchedulerLockInterceptor.getConfigValue("shedlock.defaults.lock-at-most-for");
        String lockAtLeastFor = SchedulerLockInterceptor.getConfigValue("shedlock.defaults.lock-at-least-for");
        Objects.requireNonNull(lockAtMostFor, "shedlock.defaults.lock-at-most-for parameter is mandatory");
        this.lockConfigurationExtractor = new CdiLockConfigurationExtractor(Utils.parseDuration(lockAtMostFor), lockAtLeastFor != null ? Utils.parseDuration(lockAtLeastFor) : Duration.ZERO);
    }

    private static @Nullable String getConfigValue(String propertyName) {
        return ConfigProvider.getConfig().getConfigValue(propertyName).getValue();
    }

    @AroundInvoke
    @Nullable Object lock(InvocationContext context) throws Throwable {
        Class<?> returnType = context.getMethod().getReturnType();
        if (!Void.TYPE.equals(returnType) && !Void.class.equals(returnType)) {
            throw new LockingNotSupportedException();
        }
        Optional<LockConfiguration> lockConfiguration = this.lockConfigurationExtractor.getLockConfiguration(context.getMethod());
        if (lockConfiguration.isPresent()) {
            this.lockingTaskExecutor.executeWithLock(() -> ((InvocationContext)context).proceed(), lockConfiguration.get());
            return null;
        }
        return context.proceed();
    }
}

