/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.shedlock.cdi.internal;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import net.javacrumbs.shedlock.cdi.SchedulerLock;
import net.javacrumbs.shedlock.cdi.internal.Utils;
import net.javacrumbs.shedlock.core.ClockProvider;
import net.javacrumbs.shedlock.core.LockConfiguration;

class CdiLockConfigurationExtractor {
    private final Duration defaultLockAtMostFor;
    private final Duration defaultLockAtLeastFor;

    CdiLockConfigurationExtractor(Duration defaultLockAtMostFor, Duration defaultLockAtLeastFor) {
        this.defaultLockAtMostFor = Objects.requireNonNull(defaultLockAtMostFor);
        this.defaultLockAtLeastFor = Objects.requireNonNull(defaultLockAtLeastFor);
    }

    Optional<LockConfiguration> getLockConfiguration(Method method) {
        Optional<SchedulerLock> annotation = this.findAnnotation(method);
        return annotation.map(this::getLockConfiguration);
    }

    private LockConfiguration getLockConfiguration(SchedulerLock annotation) {
        return new LockConfiguration(ClockProvider.now(), this.getName(annotation), this.getLockAtMostFor(annotation), this.getLockAtLeastFor(annotation));
    }

    private String getName(SchedulerLock annotation) {
        return annotation.name();
    }

    Duration getLockAtMostFor(SchedulerLock annotation) {
        return this.getValue(annotation.lockAtMostFor(), this.defaultLockAtMostFor, "lockAtMostFor");
    }

    Duration getLockAtLeastFor(SchedulerLock annotation) {
        return this.getValue(annotation.lockAtLeastFor(), this.defaultLockAtLeastFor, "lockAtLeastFor");
    }

    private Duration getValue(String stringValueFromAnnotation, Duration defaultValue, String paramName) {
        if (!stringValueFromAnnotation.isEmpty()) {
            return Utils.parseDuration(stringValueFromAnnotation);
        }
        return defaultValue;
    }

    Optional<SchedulerLock> findAnnotation(Method method) {
        return Optional.ofNullable(method.getAnnotation(SchedulerLock.class));
    }
}

