/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.test.base;

import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import net.javacrumbs.jsonunit.JsonAssert;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.ParametrizedMatcher;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import net.javacrumbs.jsonunit.jsonpath.JsonPathAdapter;
import net.javacrumbs.jsonunit.test.base.RecordingDifferenceListener;
import org.assertj.core.api.Assertions;
import org.assertj.core.extractor.Extractors;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractJsonAssertTest {
    @AfterEach
    void reset() {
        JsonAssert.setTolerance(null);
        JsonAssert.resetOptions();
    }

    @Test
    void testEquals() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":1}", (Object)"{\n\"test\": 1\n}");
        JsonAssert.assertJsonEquals((Object)"{\"foo\":\"bar\",\"test\": 1}", (Object)"{\n\"test\": 1,\n\"foo\":\"bar\"}");
        JsonAssert.assertJsonEquals((Object)"{}", (Object)"{}");
    }

    @Test
    protected void shouldParseExpectedValueLeniently() {
        JsonAssert.assertJsonEquals((Object)"{//Comment\ntest:'1'}", (Object)"{\n\"test\": \"1\"\n}");
    }

    @Test
    public void shouldFailIfQuotationMarksMissingOnActualKeys() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":1}", (Object)"{test: 1}")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testArray() {
        JsonAssert.assertJsonEquals((Object)"[{\"test\":1}, {\"test\":2}]", (Object)"[{\n\"test\": 1\n}, {\"test\": 2}]");
    }

    @Test
    void testArrayDifferent() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"[{\"test\":1}, {\"test\":2}]", (Object)"[{\n\"test\": 1\n}, {\"test\": 4}]")).hasMessage("JSON documents are different:\nDifferent value found in node \"[1].test\", expected: <2> but was: <4>.\n");
    }

    @Test
    void testSimple() {
        JsonAssert.assertJsonEquals((Object)"1", (Object)"1");
    }

    @Test
    void testNumberAndString() {
        JsonAssert.setTolerance((double)0.001);
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)1, (Object)"\"hi\"")).hasMessage("JSON documents are different:\nDifferent value found in node \"\", expected: <1> but was: <\"hi\">.\n");
    }

    @Test
    void testSimpleDifferent() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"1", (Object)"\n2\n")).hasMessage("JSON documents are different:\nDifferent value found in node \"\", expected: <1> but was: <2>.\n");
    }

    @Test
    void testSimpleIgnore() {
        JsonAssert.assertJsonEquals((Object)"\"${json-unit.ignore}\"", (Object)"\n2\n");
    }

    @Test
    void testInvalidJsonActual() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":1}", (Object)"{\n\"foo\": 1\n")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testObjectName() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":1}", (Object)"{\n\"foo\": 1\n}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"\", missing: \"test\", extra: \"foo\", expected: <{\"test\":1}> but was: <{\"foo\":1}>\n");
    }

    @Test
    void testEmptyValues() {
        JsonAssert.assertJsonEquals((Object)"", (Object)"");
    }

    @Test
    void testNulls() {
        JsonAssert.assertJsonEquals(null, null);
    }

    @Test
    protected void testNotEqualWhenToleranceNotSet() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"1", (Object)"\n1.0\n")).hasMessage("JSON documents are different:\nDifferent value found in node \"\", expected: <1> but was: <1.0>.\n");
    }

    @Test
    void testComparisonWhenWithinTolerance() {
        JsonAssert.setTolerance((double)0.01);
        JsonAssert.assertJsonEquals((Object)"{\"test\":1}", (Object)"{\"test\":1.009}");
    }

    @Test
    void testComparisonWhenWithinToleranceInlineConfig() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":1}", (Object)"{\"test\":1.009}", (Configuration)JsonAssert.withTolerance((double)0.01));
    }

    @Test
    void testComparisonWhenWithinToleranceNegative() {
        JsonAssert.setTolerance((double)0.01);
        JsonAssert.assertJsonEquals((Object)"1", (Object)"\n0.9999\n");
    }

    @Test
    void testComparisonWhenOverTolerance() {
        JsonAssert.setTolerance((double)0.01);
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"1", (Object)"\n1.1\n")).hasMessage("JSON documents are different:\nDifferent value found in node \"\", expected: <1> but was: <1.1>, difference is 0.1, tolerance is 0.01\n");
    }

    @Test
    void testComparisonWhenOverZeroTolerance() {
        JsonAssert.setTolerance((double)0.0);
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"1", (Object)"\n1.1\n")).hasMessage("JSON documents are different:\nDifferent value found in node \"\", expected: <1> but was: <1.1>.\n");
    }

    @Test
    void testNullOk() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":null}", (Object)"{\n\"test\": null\n}");
    }

    @Test
    void testNullFail() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":null}", (Object)"{\n\"test\": 1\n}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <null> but was: <1>.\n");
    }

    @Test
    void testExtraRootKey() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":1}", (Object)"{\n\"test\": 1\n, \"foo\": 2}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"\", extra: \"foo\", expected: <{\"test\":1}> but was: <{\"foo\":2,\"test\":1}>\n");
    }

    @Test
    void testIgnoreOneElement() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":\"${json-unit.ignore}\"}", (Object)"{\n\"test\": 1\n, \"foo\": 2}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"\", extra: \"foo\", expected: <{\"test\":\"${json-unit.ignore}\"}> but was: <{\"foo\":2,\"test\":1}>\n");
    }

    @Test
    void testMissingRootKey() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":1, \"foo\": 2}", (Object)"{\n\"test\": 1\n}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"\", missing: \"foo\", expected: <{\"foo\":2,\"test\":1}> but was: <{\"test\":1}>\n");
    }

    @Test
    void testDifferentNumericValue() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":1}", (Object)"{\n\"test\": 2\n}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <1> but was: <2>.\n");
    }

    @Test
    void testDifferentBooleanValue() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":true}", (Object)"{\n\"test\": false\n}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <true> but was: <false>.\n");
    }

    @Test
    void testSameArrayValue() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":[1, 2, 3]}", (Object)"{\n\"test\": [1, 2, 3]\n}");
    }

    @Test
    void testIgnoreArray() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":\"${json-unit.ignore}\"}", (Object)"{\n\"test\": [1, 2, 3]\n}");
    }

    @Test
    void testDifferentArrayLength() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[1, 2, 3]}", (Object)"{\n\"test\": [1, 2]\n}")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <3> but was: <2>.\nArray \"test\" has different content. Missing values: [3], expected: <[1,2,3]> but was: <[1,2]>\n");
    }

    @Test
    void testDifferentArrayLengthWhenIgnoringArrayOrder() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[\"a\", \"b\", \"c\"]}", (Object)"{\n\"test\": [\"a\", \"b\"]\n}", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <3> but was: <2>.\nArray \"test\" has different content. Missing values: [\"c\"], extra values: [], expected: <[\"a\",\"b\",\"c\"]> but was: <[\"a\",\"b\"]>\n");
    }

    @Test
    void testDifferentArrayValue() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[1, 2, 3]}", (Object)"{\n\"test\": [1, 2, 5]\n}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test[2]\", expected: <3> but was: <5>.\n");
    }

    @Test
    void testDifferentArrayType() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[1, 2, 3]}", (Object)"{\n\"test\": [1, false, 3]\n}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test[1]\", expected: <2> but was: <false>.\n");
    }

    @Test
    void testComplexOk() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":[1, 2, {\"child\":{\"value1\":1, \"value2\":true, \"value3\": \"test\", \"value4\":{\"leaf\":5}}}], \"root2\": false}", (Object)"{\"test\":[1, 2, {\"child\":{\"value1\":1, \"value2\":true, \"value3\": \"test\", \"value4\":{\"leaf\":5}}}], \"root2\": false}");
    }

    @Test
    void testComplexErrors() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\n   \"test\":[\n      1,\n      2,\n      {\n         \"child\":{\n            \"value1\":1,\n            \"value2\":true,\n            \"value3\":\"test\",\n            \"value4\":{\n               \"leaf\":5\n            }\n         }\n      }\n   ],\n   \"root2\":false,\n   \"root3\":1\n}", (Object)"{\n   \"test\":[\n      5,\n      false,\n      {\n         \"child\":{\n            \"value1\":5,\n            \"value2\":\"true\",\n            \"value3\":\"test\",\n            \"value4\":{\n               \"leaf2\":5\n            }\n         },\n         \"child2\":{\n\n         }\n      }\n   ],\n   \"root4\":\"bar\"\n}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"\", missing: \"root2\",\"root3\", extra: \"root4\", expected: <{\"root2\":false,\"root3\":1,\"test\":[1, 2, {\"child\":{\"value1\":1,\"value2\":true,\"value3\":\"test\",\"value4\":{\"leaf\":5}}}]}> but was: <{\"root4\":\"bar\",\"test\":[5, false, {\"child\":{\"value1\":5,\"value2\":\"true\",\"value3\":\"test\",\"value4\":{\"leaf2\":5}},\"child2\":{}}]}>\nDifferent value found in node \"test[0]\", expected: <1> but was: <5>.\nDifferent value found in node \"test[1]\", expected: <2> but was: <false>.\nDifferent keys found in node \"test[2]\", extra: \"test[2].child2\", expected: <{\"child\":{\"value1\":1,\"value2\":true,\"value3\":\"test\",\"value4\":{\"leaf\":5}}}> but was: <{\"child\":{\"value1\":5,\"value2\":\"true\",\"value3\":\"test\",\"value4\":{\"leaf2\":5}},\"child2\":{}}>\nDifferent value found in node \"test[2].child.value1\", expected: <1> but was: <5>.\nDifferent value found in node \"test[2].child.value2\", expected: <true> but was: <\"true\">.\nDifferent keys found in node \"test[2].child.value4\", missing: \"test[2].child.value4.leaf\", extra: \"test[2].child.value4.leaf2\", expected: <{\"leaf\":5}> but was: <{\"leaf2\":5}>\n");
    }

    @Test
    void testIgnoreObject() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":\"${json-unit.ignore}\"}", (Object)"{\n\"test\": {\"object\" : {\"another\" : 1}}}");
    }

    @Test
    void testIgnoreObjectDifferentPlaceholder() {
        JsonAssert.setIgnorePlaceholder((String)"@IGNORE");
        JsonAssert.assertJsonEquals((Object)"{\"test\":\"@IGNORE\"}", (Object)"{\n\"test\": {\"object\" : {\"another\" : 1}}}");
        JsonAssert.setIgnorePlaceholder((String)"${json-unit.ignore}");
    }

    @Test
    void testIgnoreObjectErrorInSibling() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":{\"object\": \"${json-unit.ignore}\"}, \"sibling\":1}", (Object)"{\n\"test\": {\"object\" : {\"another\" : 1}}, \"sibling\" : 2}")).hasMessage("JSON documents are different:\nDifferent value found in node \"sibling\", expected: <1> but was: <2>.\n");
    }

    @Test
    protected void testDifferentNumericTypes() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":1}", (Object)"{\n\"test\": 1.0\n}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <1> but was: <1.0>.\n");
    }

    @Test
    void testDifferentType() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":1}", (Object)"{\n\"test\": \"something\"\n}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <1> but was: <\"something\">.\n");
    }

    @Test
    void testEmpty() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":{}}", (Object)"{\n\"test\": \"something\"\n}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <{}> but was: <\"something\">.\n");
    }

    @Test
    void testEmptyOk() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":{}}", (Object)"{\n\"test\": {}\n}");
    }

    @Test
    void testAssertPartOk() {
        JsonAssert.assertJsonPartEquals((Object)"1", (Object)"{\"test\":{\"value\":1}}", (String)"test.value");
    }

    @Test
    void testAssertPartOkNumber() {
        JsonAssert.assertJsonPartEquals((Object)1, (Object)"{\"test\":{\"value\":1}}", (String)"test.value");
    }

    @Test
    void testAssertPartOkFloat() {
        JsonAssert.assertJsonPartEquals((Object)1.1, (Object)"{\"test\":{\"value\":1.1}}", (String)"test.value");
    }

    @Test
    void testAssertPartOkDouble() {
        JsonAssert.assertJsonPartEquals((Object)1.1, (Object)"{\"test\":{\"value\":1.1}}", (String)"test.value");
    }

    @Test
    void testAssertPartOkReaders() {
        JsonAssert.assertJsonPartEquals((Object)new StringReader("1"), (Object)new StringReader("{\"test\":{\"value\":1}}"), (String)"test.value");
    }

    @Test
    void testAssertPartOkString() {
        JsonAssert.assertJsonPartEquals((Object)"a b", (Object)"{\"test\":{\"value\":\"a b\"}}", (String)"test.value");
    }

    @Test
    void testAssertPart() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonPartEquals((Object)"2", (Object)"{\"test\":{\"value\":1}}", (String)"test.value")).hasMessage("JSON documents are different:\nDifferent value found in node \"test.value\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testAssertJsonNodeAbsent() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonNodeAbsent((Object)"{\"test\":{\"value\":1}}", (String)"test.value")).hasMessage("Node \"test.value\" is present.");
    }

    @Test
    void testAssertJsonNodeAbsentOk() {
        JsonAssert.assertJsonNodeAbsent((Object)"{\"test\":{\"value\":1}}", (String)"test.different");
    }

    @Test
    void testAssertJsonNodePresent() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonNodePresent((Object)"{\"test\":{\"value\":1}}", (String)"test.different")).hasMessage("Node \"test.different\" is missing.");
    }

    @Test
    void testAssertJsonNodePresentInArray() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonNodePresent((Object)"{\"array\":[1, 2]}", (String)"array[3]")).hasMessage("Node \"array[3]\" is missing.");
    }

    @Test
    void testAssertJsonNodePresentOk() {
        JsonAssert.assertJsonNodePresent((Object)"{\"test\":{\"value\":1}}", (String)"test.value");
    }

    @Test
    void testAssertPartComplex() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonPartEquals((Object)"{\"value\":2}", (Object)"{\"test\":{\"value\":1}}", (String)"test")).hasMessage("JSON documents are different:\nDifferent value found in node \"test.value\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testAssertPartArrayOk() {
        JsonAssert.assertJsonPartEquals((Object)"2", (Object)"{\"test\":[{\"value\":1},{\"value\":2}]}", (String)"test[1].value");
    }

    @Test
    void testAssertPartArray() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonPartEquals((Object)3, (Object)"{\"test\":[{\"value\":1},{\"value\":2}]}", (String)"test[1].value")).hasMessage("JSON documents are different:\nDifferent value found in node \"test[1].value\", expected: <3> but was: <2>.\n");
    }

    @Test
    void testAssertPartNonexisting() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonPartEquals((Object)"2", (Object)"{\"test\":{\"value\":1}}", (String)"test.bogus")).hasMessage("JSON documents are different:\nMissing node in path \"test.bogus\".\n");
    }

    @Test
    void testNullAndAbsent() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":{\"a\":1}}", (Object)"{\"test\":{\"a\":1, \"b\": null}}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"test\", extra: \"test.b\", expected: <{\"a\":1}> but was: <{\"a\":1,\"b\":null}>\n");
    }

    @Test
    void testTreatNullAsAbsent() {
        JsonAssert.setOptions((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0]);
        JsonAssert.assertJsonEquals((Object)"{\"test\":{\"a\":1}}", (Object)"{\"test\":{\"a\":1, \"b\": null}}");
    }

    @Test
    void testTreatNullAsAbsentInNode() {
        JsonAssert.setOptions((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0]);
        JsonAssert.assertJsonNodeAbsent((Object)"{\"test\": null}", (String)"test");
    }

    @Test
    void testTreatNullAsAbsentTwoValues() {
        JsonAssert.setOptions((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0]);
        JsonAssert.assertJsonEquals((Object)"{\"test\":{\"a\":1}}", (Object)"{\"test\":{\"a\":1, \"b\": null, \"c\": null}}");
    }

    @Test
    void testTreatNullAsNullInExpected() {
        JsonAssert.setOptions((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0]);
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":{\"a\":1, \"b\": null}}", (Object)"{\"test\":{\"a\":1}}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"test\", missing: \"test.b\", expected: <{\"a\":1,\"b\":null}> but was: <{\"a\":1}>\n");
    }

    @Test
    void testTreatNullAsNullInExpectedInline() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":{\"a\":1, \"b\": null}}", (Object)"{\"test\":{\"a\":1}}", (Configuration)JsonAssert.when((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nDifferent keys found in node \"test\", missing: \"test.b\", expected: <{\"a\":1,\"b\":null}> but was: <{\"a\":1}>\n");
    }

    @Test
    void shouldIgnoreArrayOrder() {
        JsonAssert.setOptions((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]);
        JsonAssert.assertJsonEquals((Object)"{\"test\":[1,2,3]}", (Object)"{\"test\":[3,2,1]}");
    }

    @Test
    void shouldIgnoreArrayOrderOnObjectArrays() {
        JsonAssert.setOptions((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]);
        JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"key\":1},{\"key\":2},{\"key\":3}]}", (Object)"{\"test\":[{\"key\":3},{\"key\":2},{\"key\":1}]}");
    }

    @Test
    void shouldReportOnDifferentValuesWhenIgnoringOrder() {
        try {
            JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"key\":1},{\"key\":2},{\"key\":3}]}", (Object)"{\"test\":[{\"key\":4},{\"key\":2},{\"key\":1}]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]));
        }
        catch (AssertionError e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"JSON documents are different:\nDifferent value found when comparing expected array element test[2] to actual element test[0].\nDifferent value found in node \"test[0].key\", expected: <3> but was: <4>.\n", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    void shouldReportOnDifferentValuesWhenIgnoringOrderActualsSame() {
        try {
            JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"key\":1},{\"key\":1},{\"key\":2}]}", (Object)"{\"test\":[{\"key\":1},{\"key\":1},{\"key\":1}]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]));
        }
        catch (AssertionError e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"JSON documents are different:\nDifferent value found when comparing expected array element test[2] to actual element test[2].\nDifferent value found in node \"test[2].key\", expected: <2> but was: <1>.\n", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    void shouldFailIfArrayContentIsDifferent() {
        JsonAssert.setOptions((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]);
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[1,2,3]}", (Object)"{\"test\":[3,2,4]}")).hasMessage("JSON documents are different:\nDifferent value found when comparing expected array element test[0] to actual element test[2].\nDifferent value found in node \"test[2]\", expected: <1> but was: <4>.\n");
    }

    @Test
    void arraysShouldMatchEvenWhenIgnoringExtraFields() {
        JsonAssert.assertJsonEquals((Object)"[[2],[1]]", (Object)"[[1,2],[2]]", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[]{Option.IGNORING_EXTRA_ARRAY_ITEMS}));
    }

    @Test
    void arraysShouldMatchEvenWhenIgnoringExtraFieldsComplex() {
        JsonAssert.assertJsonEquals((Object)"[[3],[2],[1]]", (Object)"[[1,2],[2,3],[3,1]]", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[]{Option.IGNORING_EXTRA_ARRAY_ITEMS}));
    }

    @Test
    void arraysShouldMatchEvenWhenIgnoringExtraFieldsInEmbeddedObjects() {
        JsonAssert.assertJsonEquals((Object)"[{\"a\":[\"b\"]},{\"a\":[\"a\"]}]", (Object)"[{\"a\":[\"b\",\"a\"]},{\"a\":[\"b\",\"c\"]}]", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[]{Option.IGNORING_EXTRA_ARRAY_ITEMS}));
    }

    @Test
    void arraysMatchShouldReportErrorCorrectlyWhenIgnoringExtraFields() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"[[2],[1]]", (Object)"[[1,2],[3]]", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[]{Option.IGNORING_EXTRA_ARRAY_ITEMS}))).hasMessage("JSON documents are different:\nDifferent value found when comparing expected array element [1] to actual element [1].\nDifferent value found when comparing expected array element [1][0] to actual element [1][0].\nDifferent value found in node \"[1][0]\", expected: <1> but was: <3>.\n");
    }

    @Test
    void exactArrayMatch() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"[1,2,3]", (Object)"[1,3,2]")).hasMessage("JSON documents are different:\nDifferent value found in node \"[1]\", expected: <2> but was: <3>.\nDifferent value found in node \"[2]\", expected: <3> but was: <2>.\n");
    }

    @Test
    void arrayShouldMatch() {
        JsonAssert.assertJsonEquals((Object)"[[3],[2],[1]]", (Object)"[[1,2],[2,3],[2,4]]", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[]{Option.IGNORING_EXTRA_ARRAY_ITEMS}));
    }

    @Test
    void arraysMatchShouldReportErrorCorrectlyWhenIgnoringExtraFieldsComplex() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"[[3],[2],[1]]", (Object)"[[1,2],[2,3],[4,4]]", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[]{Option.IGNORING_EXTRA_ARRAY_ITEMS}))).hasMessage("JSON documents are different:\nDifferent value found when comparing expected array element [2] to actual element [2].\nArray \"[2]\" has different content. Missing values: [1], expected: <[1]> but was: <[4,4]>\n");
    }

    @Test
    void arraysMatchShouldReportErrorCorrectlyWhenIgnoringExtraFieldsInEmbeddedObjects() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"[{\"a\":[\"b\"]},{\"a\":[\"a\"]}]", (Object)"[{\"a\":[\"b\",\"a\"]},{\"a\":[\"d\",\"c\"]}]", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[]{Option.IGNORING_EXTRA_ARRAY_ITEMS}))).hasMessage("JSON documents are different:\nDifferent value found when comparing expected array element [1] to actual element [1].\nArray \"[1].a\" has different content. Missing values: [\"a\"], expected: <[\"a\"]> but was: <[\"d\",\"c\"]>\n");
    }

    @Test
    void shouldFailIfArrayContentIsDifferentMoreThaOneDifference() {
        RecordingDifferenceListener listener = new RecordingDifferenceListener();
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[1,2,3]}", (Object)"{\"test\":[3,4,5]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]).withDifferenceListener((DifferenceListener)listener))).hasMessage("JSON documents are different:\nArray \"test\" has different content. Missing values: [1, 2], extra values: [4, 5], expected: <[1,2,3]> but was: <[3,4,5]>\n");
        Assertions.assertThat(listener.getDifferenceList()).hasSize(4);
        Assertions.assertThat(listener.getDifferenceList()).extracting(Extractors.toStringMethod()).containsExactly((Object[])new String[]{"MISSING 1 in test[0]", "MISSING 2 in test[1]", "EXTRA 4 in test[1]", "EXTRA 5 in test[2]"});
    }

    @Test
    void shouldFailIfArrayContentIsDifferentOnObjectArrays() {
        JsonAssert.setOptions((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]);
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"key\":1},{\"key\":2},{\"key\":3}]}", (Object)"{\"test\":[{\"key\":3},{\"key\":2},{\"key\":4}]}")).hasMessage("JSON documents are different:\nDifferent value found when comparing expected array element test[0] to actual element test[2].\nDifferent value found in node \"test[2].key\", expected: <1> but was: <4>.\n");
    }

    @Test
    void shouldIgnoreExtraFieldsIfRequested() {
        JsonAssert.setOptions((Option)Option.IGNORING_EXTRA_FIELDS, (Option[])new Option[0]);
        JsonAssert.assertJsonEquals((Object)"{\"test\":{\"b\":2}}", (Object)"{\"test\":{\"a\":1, \"b\":2, \"c\":3}}");
    }

    @Test
    void shouldIgnoreExtraFieldsInArray() {
        JsonAssert.setOptions((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[]{Option.IGNORING_EXTRA_FIELDS});
        JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"key\":1},{\"key\":2},{\"key\":3}]}", (Object)"{\"test\":[{\"key\":3},{\"key\":2, \"extraField\":2},{\"key\":1}]}");
    }

    @Test
    void shouldIgnoreValues() {
        JsonAssert.setOptions((Option)Option.IGNORING_VALUES, (Option[])new Option[0]);
        JsonAssert.assertJsonEquals((Object)"{\"test\":{\"a\":1,\"b\":2,\"c\":3}}", (Object)"{\"test\":{\"a\":3,\"b\":2,\"c\":1}}");
    }

    @Test
    void shouldIgnoreValuesInArray() {
        JsonAssert.setOptions((Option)Option.IGNORING_VALUES, (Option[])new Option[0]);
        JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"a\":1},{\"b\":2},{\"c\":3}]}", (Object)"{\"test\":[{\"a\":3},{\"b\":2},{\"c\":1}]}");
    }

    @Test
    void shouldFailIfIgnoringValuesButTypesAreDifferent() {
        JsonAssert.setOptions((Option)Option.IGNORING_VALUES, (Option[])new Option[0]);
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":{\"a\":1,\"b\":2,\"c\":3}}", (Object)"{\"test\":{\"a\":3,\"b\":\"2\",\"c\":1}}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test.b\", expected: <2> but was: <\"2\">.\n");
    }

    @Test
    void shouldFailIfIgnoringValuesButTypesAreDifferentInArray() {
        JsonAssert.setOptions((Option)Option.IGNORING_VALUES, (Option[])new Option[0]);
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"a\":1},{\"b\":2},{\"c\":3}]}", (Object)"{\"test\":[{\"a\":1},{\"b\":\"2\"},{\"c\":3}]}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test[1].b\", expected: <2> but was: <\"2\">.\n");
    }

    @Test
    void shouldIgnoreValuesWhenToleranceSet() {
        JsonAssert.setTolerance((double)0.01);
        JsonAssert.setOptions((Option)Option.IGNORING_VALUES, (Option[])new Option[0]);
        JsonAssert.assertJsonEquals((Object)"5", (Object)"\n0.9999\n");
    }

    @Test
    void assertPartNotEqualsShouldPass() {
        JsonAssert.assertJsonPartNotEquals((Object)"2", (Object)"{\"test\":{\"value\":1}}", (String)"test.value");
    }

    @Test
    void assertPartNotEqualsShouldFailWithCorrectMessage() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonPartNotEquals((Object)"1", (Object)"{\"test\":{\"value\":1}}", (String)"test.value")).hasMessage("Expected different values in node \"test.value\" but the values were equal.");
    }

    @Test
    void assertNotEqualsShouldPass() {
        JsonAssert.assertJsonNotEquals((Object)"{\"test\":{\"value\":2}}", (Object)"{\"test\":{\"value\":1}}");
    }

    @Test
    void assertNotEqualsShouldFailWithCorrectMessage() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonNotEquals((Object)"{\"test\":{\"value\":1}}", (Object)"{\"test\":{\"value\":1}}")).hasMessage("Expected different values but the values were equal.");
    }

    @Test
    void strictStructureEqualsShouldFailOnNull() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\": 3}", null, (Configuration)JsonAssert.when((Option)Option.IGNORING_VALUES, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nDifferent value found in node \"\", expected: <{\"test\":3}> but was: <null>.\n");
    }

    @Test
    void strictStructureEqualsShouldFailOnDifferentType() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\": 3}", (Object)"{\"test\": \"3\"}", (Configuration)JsonAssert.when((Option)Option.IGNORING_VALUES, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <3> but was: <\"3\">.\n");
    }

    @Test
    void strictStructureEqualsShouldPassOnDifferentValue() {
        JsonAssert.assertJsonEquals((Object)"{\"test\": \"4\"}", (Object)"{\"test\": \"3\"}", (Configuration)JsonAssert.when((Option)Option.IGNORING_VALUES, (Option[])new Option[0]));
    }

    @Test
    void shouldNotAssertArraySizeWithEmptyArrays() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":[]}", (Object)"{\"test\":[]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0]));
    }

    @Test
    void shouldNotAssertArraySizeWithExpectedArrayEmpty() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":[]}", (Object)"{\"test\":[\"a\"]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0]));
    }

    @Test
    void shouldNotAssertArraySize() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":[\"a\"]}", (Object)"{\"test\":[\"a\",\"b\",\"c\"]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0]));
    }

    @Test
    void shouldCompareOnlyFirstElements() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"a\":1},{\"b\":2}]}", (Object)"{\"test\":[{\"a\":1},{\"b\":2},{\"c\":3}]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0]));
    }

    @Test
    void shouldFailIfFirstElementsDoNotMatch() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[1,2,3]}", (Object)"{\"test\":[1,2,5,4]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nDifferent value found in node \"test[2]\", expected: <3> but was: <5>.\n");
    }

    @Test
    void shouldIgnoreExtraItemInTheMiddleIfOrderIsIgnored() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"a\":1},{\"b\":2}]}", (Object)"{\"test\":[{\"a\":1},{\"c\":3},{\"b\":2}]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[]{Option.IGNORING_ARRAY_ORDER}));
    }

    @Test
    void shouldAcceptLongerShuffledArray() {
        JsonAssert.assertJsonEquals((Object)"{\"test\":[1,2,3]}", (Object)"{\"test\":[5,5,4,4,3,3,2,2,1,1]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[]{Option.IGNORING_ARRAY_ORDER}));
    }

    @Test
    void shouldFailIfOneValueIsMissing() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[1,2,3,9]}", (Object)"{\"test\":[5,5,4,4,3,3,2,2,1,1]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[]{Option.IGNORING_ARRAY_ORDER}))).hasMessage("JSON documents are different:\nArray \"test\" has different content. Missing values: [9], expected: <[1,2,3,9]> but was: <[5,5,4,4,3,3,2,2,1,1]>\n");
    }

    @Test
    void shouldFailIfIfExpectedIsLongerAndOrderIsIgnored() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[1,2,3,9]}", (Object)"{\"test\":[3,2,1]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[]{Option.IGNORING_ARRAY_ORDER}))).hasMessage("JSON documents are different:\nArray \"test\" has invalid length, expected: <at least 4> but was: <3>.\nArray \"test\" has different content. Missing values: [9], expected: <[1,2,3,9]> but was: <[3,2,1]>\n");
    }

    @Test
    void shouldFailIfIfExpectedIsLongerAndOrderIsIgnoredAndTheItemsDoNotMatch() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[5,6,7,8]}", (Object)"{\"test\":[3,2,1]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[]{Option.IGNORING_ARRAY_ORDER}))).hasMessage("JSON documents are different:\nArray \"test\" has invalid length, expected: <at least 4> but was: <3>.\nArray \"test\" has different content. Missing values: [5, 6, 7, 8], expected: <[5,6,7,8]> but was: <[3,2,1]>\n");
    }

    @Test
    void shouldNotIgnoreExtraItemInTheMiddle() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"a\":1},{\"b\":2}]}", (Object)"{\"test\":[{\"a\":1},{\"c\":3},{\"b\":2}]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nDifferent keys found in node \"test[1]\", missing: \"test[1].b\", extra: \"test[1].c\", expected: <{\"b\":2}> but was: <{\"c\":3}>\n");
    }

    @Test
    void shouldFailIfFirstElementsAreDifferent() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"a\":1},{\"b\":2}]}", (Object)"{\"test\":[{\"a\":1},{\"b\":1}]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nDifferent value found in node \"test[1].b\", expected: <2> but was: <1>.\n");
    }

    @Test
    void shouldFailIfExpectsMoreArrayItems() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"a\":1},{\"b\":1},{\"c\":3}]}", (Object)"{\"test\":[{\"a\":1},{\"b\":1}]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nArray \"test\" has invalid length, expected: <at least 3> but was: <2>.\nArray \"test\" has different content. Missing values: [{\"c\":3}], expected: <[{\"a\":1},{\"b\":1},{\"c\":3}]> but was: <[{\"a\":1},{\"b\":1}]>\n");
    }

    @Test
    void shouldFailIfExpectsMoreArrayItemsAndDifferentValues() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":[{\"a\":1},{\"b\":2},{\"c\":3}]}", (Object)"{\"test\":[{\"a\":1},{\"b\":1}]}", (Configuration)JsonAssert.when((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nArray \"test\" has invalid length, expected: <at least 3> but was: <2>.\nArray \"test\" has different content. Missing values: [{\"c\":3}], expected: <[{\"a\":1},{\"b\":2},{\"c\":3}]> but was: <[{\"a\":1},{\"b\":1}]>\nDifferent value found in node \"test[1].b\", expected: <2> but was: <1>.\n");
    }

    @Test
    void shouldAddPathPrefixToPath() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonPartEquals((Object)"2", (Object)JsonUtils.jsonSource((Object)"{\"test\":1}", (String)"$"), (String)"test")).hasMessage("JSON documents are different:\nDifferent value found in node \"$.test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testEqualsNode() {
        JsonAssert.assertJsonEquals((Object)this.readValue("{\"test\":1}"), (Object)this.readValue("{\"test\": 1}"));
    }

    @Test
    void testEqualsNodeIgnore() {
        JsonAssert.assertJsonEquals((Object)this.readValue("{\"test\":\"${json-unit.ignore}\"}"), (Object)this.readValue("{\"test\": 1}"));
    }

    @Test
    void testRegex() {
        JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.regex}[A-Z]+\"}", (Object)"{\"test\": \"ABCD\"}");
    }

    @Test
    void regexShouldFail() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.regex}[A-Z]+\"}", (Object)"{\"test\": \"123\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\". Pattern \"[A-Z]+\" did not match \"123\".\n");
    }

    @Test
    void regexShouldFailOnNullGracefully() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.regex}[A-Z]+\"}", (Object)"{\"test\": null}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <\"${json-unit.regex}[A-Z]+\"> but was: <null>.\n");
    }

    @Test
    void regexShouldFailOnNumberGracefully() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\": \"#{json-unit.regex}[A-Z]+\"}", (Object)"{\"test\": 123}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <\"#{json-unit.regex}[A-Z]+\"> but was: <123>.\n");
    }

    @Test
    void regexShouldFailOnNonexistingGracefully() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.regex}[A-Z]+\"}", (Object)"{\"test2\": 123}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"\", missing: \"test\", extra: \"test2\", expected: <{\"test\":\"${json-unit.regex}[A-Z]+\"}> but was: <{\"test2\":123}>\n");
    }

    @Test
    void matcherShouldMatch() {
        JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.matches:positive}\"}", (Object)"{\"test\":1}", (Configuration)JsonAssert.withMatcher((String)"positive", (Matcher)Matchers.greaterThan((Comparable)BigDecimal.valueOf(0L))));
    }

    @Test
    void matcherParameterShouldBeIgnored() {
        JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.matches:positive}param\"}", (Object)"{\"test\":1}", (Configuration)JsonAssert.withMatcher((String)"positive", (Matcher)Matchers.greaterThan((Comparable)BigDecimal.valueOf(0L))));
    }

    @Test
    void parametrizedMatcherShouldFail() {
        DivisionMatcher divisionMatcher = new DivisionMatcher();
        try {
            JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.matches:isDivisibleBy}3\"}", (Object)"{\"test\":5}", (Configuration)JsonAssert.withMatcher((String)"isDivisibleBy", (Matcher)divisionMatcher));
        }
        catch (AssertionError e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"JSON documents are different:\nMatcher \"isDivisibleBy\" does not match value 5 in node \"test\". Expected value divisible by <3> but was <5>\n", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    void parametrizedMatcherShouldMatch() {
        DivisionMatcher divisionMatcher = new DivisionMatcher();
        JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.matches:isDivisibleBy}3\"}", (Object)"{\"test\":6}", (Configuration)JsonAssert.withMatcher((String)"isDivisibleBy", (Matcher)divisionMatcher));
    }

    @Test
    void missingParameterShouldResultInEmptyString() {
        DivisionMatcher divisionMatcher = new DivisionMatcher();
        Assertions.assertThatThrownBy(() -> AbstractJsonAssertTest.lambda$missingParameterShouldResultInEmptyString$60((Matcher)divisionMatcher)).isInstanceOf(NumberFormatException.class);
    }

    @Test
    void shouldUseMultipleMatchers() {
        DivisionMatcher divisionMatcher = new DivisionMatcher();
        Matcher emptyMatcher = Matchers.empty();
        JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.matches:isDivisibleBy}3\", \"x\": \"${json-unit.matches:isEmpty}\"}", (Object)"{\"test\":6, \"x\": []}", (Configuration)JsonAssert.withMatcher((String)"isDivisibleBy", (Matcher)divisionMatcher).withMatcher("isEmpty", emptyMatcher));
    }

    @Test
    void matcherNameShouldBeparsedUntilFirstCurlyBrace() {
        String expected = "{ \"o\" : \"${json-unit.matches:embedded}{\\\"x\\\" : \\\"y\\\"}\" }";
        String actual = "{ \"o\" : \"{\\\"x\\\" : \\\"y\\\"}\" }";
        JsonAssert.assertJsonEquals((Object)expected, (Object)actual, (Configuration)JsonAssert.withMatcher((String)"embedded", (Matcher)new TrueMatcher()));
    }

    @Test
    void parameterMatchingShouldWork() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\": [\"${json-unit.matches:eq}1\", \"${json-unit.matches:eq}2\"]}", (Object)"{\"test\":[2, 2]}", (Configuration)JsonAssert.withMatcher((String)"eq", (Matcher)new NumEqualsMatcher()).when(Option.IGNORING_ARRAY_ORDER, new Option[0]))).hasMessage("JSON documents are different:\nDifferent value found when comparing expected array element test[0] to actual element test[1].\nMatcher \"eq\" does not match value 2 in node \"test[1]\". Expected number equal to <1> but was <2>\n");
    }

    @Test
    void pathShouldBeIgnoredForDifferentValue() {
        JsonAssert.assertJsonEquals((Object)"{\"root\":{\"test\":1, \"ignored\": 2}}", (Object)"{\"root\":{\"test\":1, \"ignored\": 1}}", (Configuration)JsonAssert.whenIgnoringPaths((String[])new String[]{"root.ignored"}));
    }

    @Test
    void pathShouldBeIgnoredForDifferentValueWithWhen() {
        JsonAssert.assertJsonEquals((Object)"{\"root\":{\"test\":1, \"ignored\": 2}}", (Object)"{\"root\":{\"test\":1, \"ignored\": 1}}", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.path((String)"root.ignored"), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenIgnore()}));
    }

    @Test
    void arrayWildcardForPathIgnoring() {
        JsonAssert.assertJsonEquals((Object)"[{\"a\":1, \"b\":0},{\"a\":2, \"b\":0}]", (Object)"[{\"a\":1, \"b\":2},{\"a\":2, \"b\":3}]", (Configuration)JsonAssert.whenIgnoringPaths((String[])new String[]{"[*].b"}));
    }

    @Test
    void arrayWildcardForPathIgnoringArrayOrder() {
        JsonAssert.assertJsonEquals((Object)"[{\"a\":1, \"b\":0},{\"a\":2, \"b\":0}]", (Object)"[{\"a\":2, \"b\":2},{\"a\":1, \"b\":3}]", (Configuration)JsonAssert.whenIgnoringPaths((String[])new String[]{"[*].b"}).when(Option.IGNORING_ARRAY_ORDER, new Option[0]));
    }

    @Test
    void inPathShouldWork() {
        JsonAssert.assertJsonEquals((Object)"[1]", (Object)JsonPathAdapter.inPath((Object)"{\"root\":{\"test\":1, \"ignored\": 2}}", (String)"$..test"));
    }

    @Test
    void arrayWildcardShouldWorkWhenIgnoringArrayOrder() {
        String expected = "{\n  \"calendars\": [\n    {\n      \"dates\": [\n        {\n          \"id\": \"date-8c9c9ffa58fee47b47c2c1eb511c4e6c\",\n          \"type\": \"NOTIFICATION\",\n          \"from\": 1\n        }\n      ]\n    }\n  ]\n}";
        String actual = "{\n  \"calendars\": [\n    {\n      \"dates\": [\n        {\n          \"id\": \"date-8c9c9ffa58fee47b47c2c1eb511c4e6c\",\n          \"type\": \"NOTIFICATION\",\n          \"from\": 2\n        }\n      ]\n    }\n  ]\n}";
        JsonAssert.assertJsonEquals((Object)expected, (Object)actual, (Configuration)JsonAssert.whenIgnoringPaths((String[])new String[]{"calendars[*].dates[*].from"}).when(Option.IGNORING_ARRAY_ORDER, new Option[0]));
    }

    @Test
    void arrayWildcardForPathIgnoringMultidimensional() {
        JsonAssert.assertJsonEquals((Object)"[[1, 2], [3, 4], [5, 6]]", (Object)"[[2, 2], [2, 4], [2, 6]]", (Configuration)JsonAssert.whenIgnoringPaths((String[])new String[]{"[*][0]"}));
    }

    @Test
    void multidimensionalArrayCompareFailure() {
        try {
            JsonAssert.assertJsonEquals((Object)"[[1, 2], [3, 4], [5, 6]]", (Object)"[[2, 2], [2, 4], [2, 6]]");
        }
        catch (AssertionError e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"JSON documents are different:\nDifferent value found in node \"[0][0]\", expected: <1> but was: <2>.\nDifferent value found in node \"[1][0]\", expected: <3> but was: <2>.\nDifferent value found in node \"[2][0]\", expected: <5> but was: <2>.\n", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    void arrayWildcardForPathIgnoringFail() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"[{\"a\":1, \"b\":5},{\"a\":1, \"b\":5}]", (Object)"[{\"a\":1, \"b\":2},{\"a\":1, \"b\":3}]", (Configuration)JsonAssert.whenIgnoringPaths((String[])new String[]{"[*].a"}))).hasMessage("JSON documents are different:\nDifferent value found in node \"[0].b\", expected: <5> but was: <2>.\nDifferent value found in node \"[1].b\", expected: <5> but was: <3>.\n");
    }

    @Test
    void ifMatcherDoesNotMatchReportDifference() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.matches:positive}\"}", (Object)"{\"test\":-1}", (Configuration)JsonAssert.withMatcher((String)"positive", (Matcher)Matchers.greaterThan((Comparable)BigDecimal.valueOf(0L))))).hasMessage("JSON documents are different:\nMatcher \"positive\" does not match value -1 in node \"test\". Expected a value greater than <0> but <-1> was less than <0>\n");
    }

    @Test
    void failIfMatcherNotFound() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.matches:unknown}\"}", (Object)"{\"test\":-1}")).hasMessage("JSON documents are different:\nMatcher \"unknown\" not found.\n");
    }

    @Test
    void testEqualsNodeFail() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)this.readValue("{\"test\":1}"), (Object)"{\"test\": 2}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <1> but was: <2>.\n");
    }

    @Test
    void testEqualsNodeStringFail() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"test\":\"a\"}", (Object)this.readValue("{\"test\": \"b\"}"))).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <\"a\"> but was: <\"b\">.\n");
    }

    @Test
    protected void testBinary() {
        JsonAssert.assertJsonEquals((Object)"{\"binary\":\"aGk=\"}", Collections.singletonMap("binary", "hi".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    void shouldCompareArrays() {
        String actualFileM = "{\"skeletonKeys\":[{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":81,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":47,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-1\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":120,\"child\":true},{\"contentId\":\"category::samplecategory\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":110,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":93,\"child\":true},{\"contentId\":\"category::samplecategory\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":136,\"child\":true},{\"contentId\":\"category::samplecategory\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":156,\"child\":true},{\"contentId\":\"category::samplecategory\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":96,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":247,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":8,\"child\":true},{\"contentId\":\"category::samplecategory\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":124,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-1\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":162,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":182,\"child\":true},{\"contentId\":\"d04b643f-c74b-5f3f-8042-5a5346a2c34a\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":0,\"child\":false},{\"contentId\":\"d04b643f-c74b-5f3f-8042-5a5346a2c34a\",\"namespace\":\"testcustomer-bulk-client-1\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":0,\"child\":false}]}";
        String expectedFileM = "{\"skeletonKeys\":[{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":81,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":47,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-1\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":120,\"child\":true},{\"contentId\":\"category::samplecategory\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":110,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":93,\"child\":true},{\"contentId\":\"category::samplecategory\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":136,\"child\":true},{\"contentId\":\"category::samplecategory\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":156,\"child\":true},{\"contentId\":\"category::samplecategory\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":96,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":247,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":8,\"child\":true},{\"contentId\":\"category::samplecategory\",\"namespace\":\"testcustomer-bulk-client-3\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":124,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-1\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":162,\"child\":true},{\"contentId\":\"product::product11\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":182,\"child\":true},{\"contentId\":\"d04b643f-c74b-5f3f-8042-5a5346a2c34a\",\"namespace\":\"testcustomer-bulk-client-2\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":0,\"child\":false},{\"contentId\":\"d04b643f-c74b-5f3f-8042-5a5346a2c34a\",\"namespace\":\"testcustomer-bulk-client-1\",\"type\":\"contributor\",\"dateString\":\"\",\"sortIndex\":0,\"child\":false}]}";
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)actualFileM, (Object)expectedFileM, (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]).whenIgnoringPaths(new String[]{"skeletonKeys[*].sortIndex"}))).hasMessage("JSON documents are different:\nDifferent value found when comparing expected array element skeletonKeys[10] to actual element skeletonKeys[10].\nDifferent value found in node \"skeletonKeys[10].namespace\", expected: <\"testcustomer-bulk-client-2\"> but was: <\"testcustomer-bulk-client-3\">.\n");
    }

    @Test
    void shouldCompareLongArrays() {
        String actual = "[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]";
        String expected = "[1,8,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]";
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)actual, (Object)expected, (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nArray \"\" has different content. Missing values: [1, 1], extra values: [8, 9], expected: <[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]> but was: <[1,8,9,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]>\n");
    }

    @Test
    void shouldCompareLongArraysWithTwoEquivalentSets() {
        String actual = "[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]";
        String expected = "[1,8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]";
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)actual, (Object)expected, (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]))).hasMessage("JSON documents are different:\nArray \"\" has different content. Missing values: [1, 5], extra values: [8, 9], expected: <[1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]> but was: <[1,8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,5,9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5]>\n");
    }

    @Test
    void shouldUseRightValuesWhenComparingArrays() {
        JsonAssert.assertJsonEquals((Object)"[\"${json-unit.ignore}\",\"${json-unit.ignore}\",2]", (Object)"[1,2,1]", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]));
    }

    @Test
    void shouldIgnoreArrayOrderInSpecificPath() {
        JsonAssert.assertJsonEquals((Object)"[{\"b\":[1,2,3]},{\"b\":[4,5,6]}]", (Object)"[{\"b\":[2,1,3]},{\"b\":[6,4,5]}]", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.path((String)"[*].b"), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}));
    }

    @Test
    void shouldNotIgnoreArrayOrderWhenNotSpecified() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"[{\"b\":[1,2,3]},{\"b\":[4,5,6]}]", (Object)"[{\"b\":[6,4,5]},{\"b\":[2,1,3]}]", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.path((String)"[*].b"), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}))).hasMessage("JSON documents are different:\nArray \"[0].b\" has different content. Missing values: [1, 2, 3], extra values: [6, 4, 5], expected: <[1,2,3]> but was: <[6,4,5]>\nArray \"[1].b\" has different content. Missing values: [4, 5, 6], extra values: [2, 1, 3], expected: <[4,5,6]> but was: <[2,1,3]>\n");
    }

    @Test
    void shouldExcludeIgnoringArrayOrderFromPath() {
        JsonAssert.assertJsonEquals((Object)"[{\"b\":[1,2,3]},{\"b\":[4,5,6]}]", (Object)"[{\"b\":[4,5,6]},{\"b\":[1,2,3]}]", (Configuration)JsonAssert.when((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0]).when(ConfigurationWhen.path((String)"[*].b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenNot((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}));
    }

    @Test
    void shouldExcludeIgnoringArrayOrderFromPathAndIgnoreInRoot() {
        JsonAssert.assertJsonEquals((Object)"[{\"b\":[1,2,3]},{\"b\":[4,5,6]}]", (Object)"[{\"b\":[4,5,6]},{\"b\":[1,2,3]}]", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.rootPath(), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).when(ConfigurationWhen.path((String)"[*].b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenNot((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}));
    }

    @Test
    void shouldIgnoreArrayOrderEverywhereButTheFirstElement() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"[{\"b\":[1,2,3]},{\"b\":[4,5,6]},{\"b\":[7,8,9]}]", (Object)"[{\"b\":[1,3,2]},{\"b\":[5,4,6]},{\"b\":[8,7,9]}]", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.path((String)"[*].b"), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).when(ConfigurationWhen.path((String)"[0].b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenNot((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}))).hasMessage("JSON documents are different:\nDifferent value found in node \"[0].b[1]\", expected: <2> but was: <3>.\nDifferent value found in node \"[0].b[2]\", expected: <3> but was: <2>.\n");
    }

    @Test
    void shouldIgnoreArrayOrderInSeveralSpecificPaths() {
        JsonAssert.assertJsonEquals((Object)"[{\"b\":[1,2,3],\"c\":[-1,-2,-3]},{\"b\":[4,5,6],\"c\":[-4,-5,-6]}]", (Object)"[{\"b\":[3,1,2],\"c\":[-2,-3,-1]},{\"b\":[6,5,4],\"c\":[-5,-4,-6]}]", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.paths((String[])new String[]{"[*].b", "[*].c"}), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}));
    }

    @Test
    void shouldTreatNullAsAbsentInSpecificPath() {
        JsonAssert.assertJsonEquals((Object)"{\"a\":1}", (Object)"{\"a\":1,\"b\":null}", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.path((String)"b"), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0])}));
    }

    @Test
    void shouldNotTreatNullAsAbsentWhenNotSpecified() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"a\":1}", (Object)"{\"a\":1,\"b\":null,\"c\":null}", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.path((String)"b"), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0])}))).hasMessage("JSON documents are different:\nDifferent keys found in node \"\", extra: \"c\", expected: <{\"a\":1}> but was: <{\"a\":1,\"b\":null,\"c\":null}>\n");
    }

    @Test
    void shouldIgnoreExtraFieldsInSpecificPath() {
        JsonAssert.assertJsonEquals((Object)"{\"a\":{\"a1\":1}}", (Object)"{\"a\":{\"a1\":1,\"a2\":2}}", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.path((String)"a"), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_EXTRA_FIELDS, (Option[])new Option[0])}));
    }

    @Test
    void shouldNotIgnoreExtraFieldsWhenNotSpecified() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"a\":{\"a1\":1},\"b\":{\"b1\":1}}", (Object)"{\"a\":{\"a1\":1,\"a2\":2},\"b\":{\"b1\":1,\"b2\":2}}", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.path((String)"a"), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_EXTRA_FIELDS, (Option[])new Option[0])}))).hasMessage("JSON documents are different:\nDifferent keys found in node \"b\", extra: \"b.b2\", expected: <{\"b1\":1}> but was: <{\"b1\":1,\"b2\":2}>\n");
    }

    @Test
    void shouldIgnoreExtraArrayItemsInSpecificPath() {
        JsonAssert.assertJsonEquals((Object)"{\"a\":[1,2]}", (Object)"{\"a\":[1,2,3]}", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.path((String)"a"), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0])}));
    }

    @Test
    void shouldNotIgnoreExtraArrayItemsWhenNotSpecified() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"a\":[1,2],\"b\":[1,2]}", (Object)"{\"a\":[1,2,3],\"b\":[1,2,3]}", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.path((String)"a"), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0])}))).hasMessage("JSON documents are different:\nArray \"b\" has different length, expected: <2> but was: <3>.\nArray \"b\" has different content. Extra values: [3], expected: <[1,2]> but was: <[1,2,3]>\n");
    }

    @Test
    void shouldIgnoreValuesInSpecificPath() {
        JsonAssert.assertJsonEquals((Object)"{\"a\":1,\"b\":\"string\"}", (Object)"{\"a\":2,\"b\":\"string2\"}", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.paths((String[])new String[]{"a", "b"}), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_VALUES, (Option[])new Option[0])}));
    }

    @Test
    void shouldNotIgnoreValuesWhenNotSpecified() {
        Assertions.assertThatThrownBy(() -> JsonAssert.assertJsonEquals((Object)"{\"a\":1,\"b\":\"string\",\"c\":2}", (Object)"{\"a\":2,\"b\":\"string2\",\"c\":3}", (Configuration)JsonAssert.when((ConfigurationWhen.PathsParam)ConfigurationWhen.paths((String[])new String[]{"a", "b"}), (ConfigurationWhen.ApplicableForPath[])new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_VALUES, (Option[])new Option[0])}))).hasMessage("JSON documents are different:\nDifferent value found in node \"c\", expected: <2> but was: <3>.\n");
    }

    @Test
    void assertSame() {
        String s = "{ \"a\": 0.0 }";
        JsonAssert.assertJsonEquals((Object)s, (Object)s);
    }

    protected abstract Object readValue(String var1);

    private static /* synthetic */ void lambda$missingParameterShouldResultInEmptyString$60(Matcher divisionMatcher) throws Throwable {
        JsonAssert.assertJsonEquals((Object)"{\"test\": \"${json-unit.matches:isDivisibleBy}\"}", (Object)"{\"test\":6}", (Configuration)JsonAssert.withMatcher((String)"isDivisibleBy", (Matcher)divisionMatcher));
    }

    static class DivisionMatcher
    extends BaseMatcher<Object>
    implements ParametrizedMatcher {
        private BigDecimal param;

        DivisionMatcher() {
        }

        public boolean matches(Object item) {
            return ((BigDecimal)item).remainder(this.param).compareTo(BigDecimal.ZERO) == 0;
        }

        public void describeTo(Description description) {
            description.appendText("value divisible by ").appendValue((Object)this.param);
        }

        public void setParameter(String parameter) {
            this.param = new BigDecimal(parameter);
        }
    }

    private static class TrueMatcher
    extends BaseMatcher<Object>
    implements ParametrizedMatcher {
        private String param;

        private TrueMatcher() {
        }

        public boolean matches(Object item) {
            return true;
        }

        public void describeTo(Description description) {
            description.appendValue((Object)this.param);
        }

        public void describeMismatch(Object item, Description description) {
        }

        public void setParameter(String parameter) {
            this.param = parameter;
        }
    }

    private static class NumEqualsMatcher
    extends BaseMatcher<Object>
    implements ParametrizedMatcher {
        private BigDecimal param;

        private NumEqualsMatcher() {
        }

        public boolean matches(Object item) {
            return this.param.compareTo((BigDecimal)item) == 0;
        }

        public void describeTo(Description description) {
            description.appendText("number equal to ").appendValue((Object)this.param);
        }

        public void setParameter(String parameter) {
            this.param = new BigDecimal(parameter);
        }
    }
}

