/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.test.base;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.javacrumbs.jsonunit.assertj.JsonAssert;
import net.javacrumbs.jsonunit.assertj.JsonAssertion;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.assertj.JsonListAssert;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.NumberComparator;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import net.javacrumbs.jsonunit.test.base.AbstractJsonAssertTest;
import net.javacrumbs.jsonunit.test.base.RecordingDifferenceListener;
import net.javacrumbs.jsonunit.test.base.RegexBuilder;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.assertj.core.api.UriAssert;
import org.assertj.core.groups.Tuple;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;

public abstract class AbstractAssertJTest {
    private static final String json = "{\n    \"store\": {\n        \"book\": [\n            {\n                \"category\": \"reference\",\n                \"author\": \"Nigel Rees\",\n                \"title\": \"Sayings of the Century\",\n                \"price\": 8.95\n            },\n            {\n                \"category\": \"fiction\",\n                \"author\": \"Evelyn Waugh\",\n                \"title\": \"Sword of Honour\",\n                \"price\": 12.99\n            },\n            {\n                \"category\": \"fiction\",\n                \"author\": \"Herman Melville\",\n                \"title\": \"Moby Dick\",\n                \"isbn\": \"0-553-21311-3\",\n                \"price\": 8.99\n            },\n            {\n                \"category\": \"fiction\",\n                \"author\": \"J. R. R. Tolkien\",\n                \"title\": \"The Lord of the Rings\",\n                \"isbn\": \"0-395-19395-8\",\n                \"price\": 22.99\n            }\n        ],\n        \"bicycle\": {\n            \"color\": \"red\",\n            \"price\": 19.95\n        }\n    },\n    \"expensive\": 10\n}";

    @Test
    protected void demo() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"a\":1}}").node("root").isEqualTo((Object)"{a:1}");
        JsonAssertions.assertThatJson((Object)"{\"root\":[{\"a\":1}]}").node("root").isEqualTo((Object)"[{a:1}]");
        JsonAssertions.assertThatJson((Object)"{\"root\":[{\"a\":1}]}").node("root").isArray().containsExactly(new Object[]{"{a:1}"});
        JsonAssertions.assertThatJson((Object)"{\"root\":[true]}").node("root").isArray().containsExactly(new Object[]{true});
        JsonAssertions.assertThatJson((Object)"{\"root\":[\"true\"]}").node("root").isArray().containsExactly(new Object[]{JsonAssertions.value((Object)"true")});
    }

    @Test
    void shouldAssertSimple() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1, \"b\":2}").isEqualTo((Object)"{\"b\":2, \"a\":1}");
    }

    @Test
    protected void shouldAssertLenient() {
        JsonAssertions.assertThatJson((Object)"{\"a\":\"1\", \"b\":2}").isEqualTo((Object)"{b:2, a:'1'}");
    }

    @Test
    void shouldAssertObject() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1}").isObject().containsEntry("a", (Object)BigDecimal.valueOf(1L));
    }

    @Test
    void objectShouldContainKeys() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1, \"b\": 2}").isObject().containsKeys((Object[])new String[]{"a", "b"});
    }

    @Test
    void shouldAssertNullValue() {
        JsonAssertions.assertThatJson(null).isNull();
    }

    @Test
    void shouldAssertNullValueNode() {
        JsonAssertions.assertThatJson(null).node("a").isAbsent();
    }

    @Test
    void shouldFailCorrectlyOnNull() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson(null).isEqualTo((Object)1)).hasMessage("JSON documents are different:\nDifferent value found in node \"\", expected: <1> but was: <null>.\n");
    }

    @Test
    void containsEntryShouldWork() {
        String entryValue = "{\n  \"approvable\" : true,  \"rejectable\" : false}";
        String input = "[{\"allowedActions\":" + entryValue + "}]";
        JsonAssertions.assertThatJson((Object)input, (JsonAssertions.JsonAssertionCallback[])new JsonAssertions.JsonAssertionCallback[]{body -> body.isArray().hasSize(1), body -> body.inPath("[0]").isObject().containsEntry("allowedActions", JsonAssertions.json((Object)entryValue)), body -> body.inPath("[0]").isObject().contains(new Map.Entry[]{Assertions.entry((Object)"allowedActions", (Object)JsonAssertions.json((Object)entryValue))}), body -> body.inPath("[0]").isObject().containsAllEntriesOf(Collections.singletonMap("allowedActions", JsonAssertions.json((Object)entryValue))), body -> body.inPath("[0]").isObject().containsAnyOf(new Map.Entry[]{Assertions.entry((Object)"allowedActions", (Object)JsonAssertions.json((Object)entryValue)), Assertions.entry((Object)"test", (Object)1)}), body -> body.inPath("[0]").isObject().containsExactlyInAnyOrderEntriesOf(Collections.singletonMap("allowedActions", JsonAssertions.json((Object)entryValue))), body -> body.inPath("[0]").isObject().containsOnly(new Map.Entry[]{Assertions.entry((Object)"allowedActions", (Object)JsonAssertions.json((Object)entryValue))}), body -> body.inPath("[0]").isObject().containsValues(new Object[]{JsonAssertions.json((Object)entryValue)}), body -> body.inPath("[0]").isObject().containsValue(JsonAssertions.json((Object)entryValue)), body -> body.inPath("[0].allowedActions").isObject().isEqualTo(JsonAssertions.json((Object)entryValue))});
    }

    @Test
    void containsEntryShouldWorkWithMatcher() {
        String json = "{\"a\": 1, \"b\": 2}";
        JsonAssertions.assertThatJson((Object)json).isObject().containsEntry("a", JsonAssertions.json((Object)"\"${json-unit.any-number}\""));
        JsonAssertions.assertThatJson((Object)json).isObject().contains(new Map.Entry[]{Assertions.entry((Object)"a", (Object)JsonAssertions.json((Object)"\"${json-unit.any-number}\""))});
    }

    @Test
    void containsOnlyShouldWorkWithMatcher() {
        String json = "{\"a\": 1, \"b\": 2}";
        JsonAssertions.assertThatJson((Object)json).isObject().containsOnly(new Map.Entry[]{Assertions.entry((Object)"a", (Object)JsonAssertions.json((Object)"\"${json-unit.any-number}\"")), Assertions.entry((Object)"b", (Object)JsonAssertions.json((Object)"\"${json-unit.any-number}\""))});
    }

    @Test
    void containsEntryShouldFailWithMatcher() {
        String json = "{\"a\": 1, \"b\": 2}";
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)json).isObject().contains(new Map.Entry[]{Assertions.entry((Object)"a", (Object)JsonAssertions.json((Object)"\"${json-unit.any-string}\"")), Assertions.entry((Object)"b", (Object)JsonAssertions.json((Object)"\"${json-unit.any-number}\""))})).hasMessage("[Different value found in node \"\"] \nExpecting map:\n  {\"a\":1,\"b\":2}\nto contain:\n  [\"a\"=\"${json-unit.any-string}\", \"b\"=\"${json-unit.any-number}\"]\nbut could not find the following map entries:\n  [\"a\"=\"${json-unit.any-string}\"]\n");
    }

    @Test
    void containsAnyOfShouldWorkWithMatcher() {
        String json = "{\"a\": 1, \"b\": 2}";
        JsonAssertions.assertThatJson((Object)json).isObject().containsAnyOf(new Map.Entry[]{Assertions.entry((Object)"a", (Object)JsonAssertions.json((Object)"\"${json-unit.any-string}\"")), Assertions.entry((Object)"a", (Object)JsonAssertions.json((Object)"\"${json-unit.any-number}\""))});
    }

    @Test
    void containsAnyOfShouldFailWithMatcher() {
        String json = "{\"a\": 1, \"b\": 2}";
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)json).isObject().containsAnyOf(new Map.Entry[]{Assertions.entry((Object)"a", (Object)JsonAssertions.json((Object)"\"${json-unit.any-string}\"")), Assertions.entry((Object)"b", (Object)JsonAssertions.json((Object)"\"${json-unit.any-string}\""))})).hasMessage("[Different value found in node \"\"] \nExpecting actual:\n  {\"a\":1,\"b\":2}\nto contain at least one of the following elements:\n  [\"a\"=\"${json-unit.any-string}\", \"b\"=\"${json-unit.any-string}\"]\nbut none were found");
    }

    @Test
    void containsValuesShouldPass() {
        String json = "{\"a\": 1, \"b\": 2}";
        JsonAssertions.assertThatJson((Object)json).isObject().containsValues(new Object[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), JsonAssertions.json((Object)"\"${json-unit.any-number}\"")});
    }

    @Test
    void containsValuesShouldFail() {
        String json = "{\"a\": 1, \"b\": 2}";
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)json).isObject().containsValues(new Object[]{BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), JsonAssertions.json((Object)"\"${json-unit.any-string}\"")})).hasMessage("[Different value found in node \"\"] \nExpecting actual:\n  {\"a\":1,\"b\":2}\nto contain value:\n  \"${json-unit.any-string}\"");
    }

    @Test
    void absentOnArray() {
        String json = "[{\"a\":1},{\"b\":1}]";
        JsonAssertions.assertThatJson((Object)json).inPath("[*].c").isArray().isEmpty();
    }

    @Test
    void invalidExpectedValue() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)json).isEqualTo((Object)"{\"broken\":")).hasMessage("Can not parse expected value: '{\"broken\":'");
    }

    @Test
    void objectShouldContainValue() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1, \"b\": 2}").isObject().containsValue((Object)BigDecimal.valueOf(2L));
    }

    @Test
    void objectShouldContainComplexValue() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1, \"b\": {\"c\" :3}}").isObject().containsValue(JsonAssertions.json((Object)"{\"c\" :\"${json-unit.any-number}\"}"));
    }

    @Test
    void objectShouldContainComplexValueError() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"root\":{\"a\":1, \"b\": {\"c\" :3}}}").node("root").isObject().containsValue(JsonAssertions.json((Object)"{\"c\" :5}"))).hasMessage("[Different value found in node \"root\"] \nExpecting actual:\n  {\"a\":1,\"b\":{\"c\":3}}\nto contain value:\n  {\"c\":5}");
    }

    @Test
    protected void objectFieldsShouldBeKeptInOrder() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"key3\": 3, \"key2\": 2, \"key1\": 1 }}").node("root").isObject().containsExactly(new Map.Entry[]{Assertions.entry((Object)"key3", (Object)BigDecimal.valueOf(3L)), Assertions.entry((Object)"key2", (Object)BigDecimal.valueOf(2L)), Assertions.entry((Object)"key1", (Object)BigDecimal.valueOf(1L))});
    }

    @Test
    void objectDoesContainComplexValue() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1, \"b\": {\"c\" :3}}").isObject().doesNotContainValue(JsonAssertions.json((Object)"{\"c\" :\"${json-unit.any-string}\"}"));
    }

    @Test
    void objectDoesContainComplexValueError() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"root\":{\"a\":1, \"b\": {\"c\" :3}}}").node("root").isObject().doesNotContainValue(JsonAssertions.json((Object)"{\"c\" :3}"))).hasMessage("[Different value found in node \"root\"] \nExpecting actual:\n  {\"a\":1,\"b\":{\"c\":3}}\nnot to contain value:\n  {\"c\":3}");
    }

    @Test
    void compareJsonInJsonPathArray() {
        JsonAssertions.assertThatJson((Object)"{\"root\": [{\"target\": 450} ]}").inPath("$.root").isArray().containsExactly(new Object[]{"{\"target\": 450 }"});
    }

    @Test
    void compareJsonInJsonPathShallowArray() {
        JsonAssertions.assertThatJson((Object)"{\"root\": [450]}").inPath("$.root").isArray().containsExactly(new Object[]{JsonAssertions.json((Object)"450")});
    }

    @Test
    void compareJsonInJsonPathShallowArrayString() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"root\": [450]}").inPath("$.root").isArray().containsExactly(new Object[]{JsonAssertions.value((Object)"450")})).hasMessage("[Node \"$.root\"] \nExpecting actual:\n  [450]\nto contain exactly (and in same order):\n  [\"450\"]\nbut some elements were not found:\n  [\"450\"]\nand others were not expected:\n  [450]\nwhen comparing values using JsonComparator");
    }

    @Test
    void compareJsonInPathArrayOfArrays() {
        JsonAssertions.assertThatJson((Object)"{\"root\": [[{\"target\": 450} ]]}").inPath("$.root").isArray().containsExactly(new Object[]{"[{\"target\": 450 }]"});
    }

    @Test
    void compareJsonInNodeArray() {
        JsonAssertions.assertThatJson((Object)"{\"root\": [{\"target\": 450} ]}").node("root").isArray().containsExactly(new Object[]{"{\"target\": 450 }"});
    }

    @Test
    void compareJsonInNodeShallowArray() {
        JsonAssertions.assertThatJson((Object)"{\"root\": [450]}").node("root").isArray().containsExactly(new Object[]{BigDecimal.valueOf(450L)});
    }

    @Test
    void compareJsonInNodeShallowArrayBigDecimal() {
        JsonAssertions.assertThatJson((Object)"{\"root\": [450]}").node("root").isArray().containsExactly(new Object[]{BigDecimal.valueOf(450L)});
    }

    @Test
    void compareJsonInNodeShallowArrayBoolean() {
        JsonAssertions.assertThatJson((Object)"{\"root\": [true]}").node("root").isArray().containsExactly(new Object[]{true});
    }

    @Test
    void compareJsonInNodeArrayOfArrays() {
        JsonAssertions.assertThatJson((Object)"{\"root\": [[{\"target\": 450} ]]}").node("root").isArray().containsExactly(new Object[]{"[{\"target\": 450 }]"});
    }

    @Test
    void compareJsonArray() {
        JsonAssertions.assertThatJson((Object)"{\"root\": [{\"target\": 450} ]}").node("root").isEqualTo(Collections.singletonList(Collections.singletonMap("target", 450)));
    }

    @Test
    void shouldAssertDirectEqual() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1}").isEqualTo((Object)"{\"a\":\"${json-unit.ignore}\"}");
    }

    @Test
    void shouldIgnoreIfMissing() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":1}}").isEqualTo((Object)"{\"root\":{\"test\":1, \"ignored\": \"${json-unit.ignore}\"}}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"root\", missing: \"root.ignored\", expected: <{\"ignored\":\"${json-unit.ignore}\",\"test\":1}> but was: <{\"test\":1}>\n");
    }

    @Test
    void shouldIgnoreIfNull() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":1, \"ignored\": null}}").isEqualTo((Object)"{\"root\":{\"test\":1, \"ignored\": \"${json-unit.ignore}\"}}");
    }

    @Test
    void shouldIgnoreIfObject() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":1, \"ignored\": {\"a\": 1}}}").isEqualTo((Object)"{\"root\":{\"test\":1, \"ignored\": \"${json-unit.ignore}\"}}");
    }

    @Test
    void shouldIgnoreElementIfMissing() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":1}}").isEqualTo((Object)"{\"root\":{\"test\":1, \"ignored\": \"${json-unit.ignore-element}\"}}");
    }

    @Test
    void shouldIgnoreElementIfNull() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":1, \"ignored\": null}}").isEqualTo((Object)"{\"root\":{\"test\":1, \"ignored\": \"${json-unit.ignore-element}\"}}");
    }

    @Test
    void shouldIgnoreElementIfObject() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":1, \"ignored\": {\"a\": 1}}}").isEqualTo((Object)"{\"root\":{\"test\":1, \"ignored\": \"${json-unit.ignore-element}\"}}");
    }

    @Test
    void shouldAssertObjectJson() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").node("a").isObject().isEqualTo(JsonAssertions.json((Object)"{\"b\": 2}"))).hasMessage("JSON documents are different:\nDifferent value found in node \"a.b\", expected: <2> but was: <1>.\n");
    }

    @Test
    void shouldAssertContainsEntry() {
        JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").node("a").isObject().contains(new Map.Entry[]{Assertions.entry((Object)"b", (Object)BigDecimal.valueOf(1L))});
    }

    @Test
    void shouldAssertContainsJsonError() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").node("a").isObject().contains(new Map.Entry[]{Assertions.entry((Object)"b", (Object)BigDecimal.valueOf(2L))})).hasMessage("[Different value found in node \"a\"] \nExpecting map:\n  {\"b\":1}\nto contain:\n  [\"b\"=2]\nbut could not find the following map entries:\n  [\"b\"=2]\n");
    }

    @Test
    void shouldAssertContainsOnlyKeys() {
        JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1, \"c\": true}}").node("a").isObject().containsOnlyKeys((Object[])new String[]{"b", "c"});
    }

    @Test
    void shouldAssertContainsOnlyKeysError() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1, \"c\": true}}").node("a").isObject().containsOnlyKeys((Object[])new String[]{"b", "c", "d"})).hasMessage("[Different value found in node \"a\"] \nExpecting actual:\n  {\"b\":1,\"c\":true}\nto contain only following keys:\n  [\"b\", \"c\", \"d\"]\nbut could not find the following keys:\n  [\"d\"]\n");
    }

    @Test
    void shouldAssertContainsAllEntries() {
        JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1, \"c\": true}}").node("a").isObject().containsAllEntriesOf(Collections.singletonMap("c", true));
    }

    @Test
    void shouldAssertContainsAllEntriesError() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1, \"c\": true}}").node("a").isObject().containsAllEntriesOf(Collections.singletonMap("c", false))).hasMessage("[Different value found in node \"a\"] \nExpecting map:\n  {\"b\":1,\"c\":true}\nto contain:\n  [\"c\"=false]\nbut could not find the following map entries:\n  [\"c\"=false]\n");
    }

    @Test
    void shouldAssertJson() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").node("a").isEqualTo(JsonAssertions.json((Object)"{\"b\": 2}"))).hasMessage("JSON documents are different:\nDifferent value found in node \"a.b\", expected: <2> but was: <1>.\n");
    }

    @Test
    void shouldAssertObjectJsonWithPlaceholder() {
        JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": \"ignored\"}}").node("a").isObject().isEqualTo(JsonAssertions.json((Object)"{\"b\":\"${json-unit.any-string}\"}"));
    }

    @Test
    void shouldAssertObjectIsNotEqualToJsonWithPlaceholder() {
        JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").node("a").isObject().isNotEqualTo(JsonAssertions.json((Object)"{\"b\":\"${json-unit.any-string}\"}"));
    }

    @Test
    void shouldAssertObjectIsNotEqualToJsonWithPlaceholderError() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": \"string\"}}").node("a").isObject().isNotEqualTo(JsonAssertions.json((Object)"{\"b\":\"${json-unit.any-string}\"}"))).hasMessage("[Different value found in node \"a\"] \nExpecting actual:\n  {\"b\":\"string\"}\nnot to be equal to:\n  {\"b\":\"${json-unit.any-string}\"}\nwhen comparing values using JsonComparator");
    }

    @Test
    void shouldAssertObjectJsonWithPlaceholderFailure() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").node("a").isObject().isEqualTo(JsonAssertions.json((Object)"{\"b\":\"${json-unit.any-string}\"}"))).hasMessage("JSON documents are different:\nDifferent value found in node \"a.b\", expected: <a string> but was: <1>.\n");
    }

    @Test
    void shouldAssertString() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": \"foo\"}}").node("a.b").isString().startsWith((CharSequence)"bar")).hasMessage("[Different value found in node \"a.b\"] \nExpecting actual:\n  \"foo\"\nto start with:\n  \"bar\"\n");
    }

    @Test
    void shouldAssertStringCustomDescription() {
        Assertions.assertThatThrownBy(() -> ((StringAssert)JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": \"foo\"}}").node("a.b").isString().as("Sad!", new Object[0])).startsWith((CharSequence)"bar")).hasMessage("[Sad!] \nExpecting actual:\n  \"foo\"\nto start with:\n  \"bar\"\n");
    }

    @Test
    void shouldAssertArray() {
        JsonAssertions.assertThatJson((Object)"{\"a\":[1, 2, 3]}").node("a").isArray().contains(new Object[]{BigDecimal.valueOf(3L)});
    }

    @Test
    void shouldFindObjectInArray() {
        JsonAssertions.assertThatJson((Object)"{\"a\":[{\"b\": 1}, {\"c\": 1}, {\"d\": 1}]}").node("a").isArray().contains(new Object[]{JsonAssertions.json((Object)"{\"c\": 1}")});
    }

    @Test
    void shouldFindObjectInArrayWithPlaceholder() {
        JsonAssertions.assertThatJson((Object)"{\"a\":[{\"b\": 1}, {\"c\": 1}, {\"d\": 1}]}").node("a").isArray().contains(new Object[]{JsonAssertions.json((Object)"{\"c\": \"${json-unit.any-number}\"}")});
    }

    @Test
    void arraySimpleIgnoringOrderComparisonExample() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[1,2,3]}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{\"test\":[3,2,1]}");
    }

    @Test
    void arrayIgnoringOrderComparison() {
        JsonAssertions.assertThatJson((Object)"{\"a\":[{\"b\": 1}, {\"c\": 1}, {\"d\": 1}]}").node("a").isArray().containsExactlyInAnyOrder(new Object[]{JsonAssertions.json((Object)"{\"c\": 1}"), JsonAssertions.json((Object)"{\"b\": 1}"), JsonAssertions.json((Object)"{\"d\": 1}")});
    }

    @Test
    void arraySimpleIgnoringOrderComparison() {
        JsonAssertions.assertThatJson((Object)"{\"a\":[{\"b\": 1}, {\"c\": 1}, {\"d\": 1}]}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).node("a").isArray().isEqualTo(JsonAssertions.json((Object)"[{\"c\": 1}, {\"b\": 1} ,{\"d\": 1}]"));
    }

    @Test
    void arraySimpleIgnoringOrderComparisonError() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":[{\"b\": 1}, {\"c\": 1}, {\"d\": 1}]}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).node("a").isArray().isEqualTo(JsonAssertions.json((Object)"[{\"c\": 2}, {\"b\": 1} ,{\"d\": 1}]"))).hasMessage("JSON documents are different:\nDifferent value found when comparing expected array element a[0] to actual element a[1].\nDifferent value found in node \"a[1].c\", expected: <2> but was: <1>.\n");
    }

    @Test
    void multipleFailuresErrorShouldBeCorrectlyFormatted() {
        Assertions.assertThatExceptionOfType(MultipleFailuresError.class).isThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":[{\"b\": 1}, {\"c\": 1}, {\"d\": 1}]}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).node("a").isArray().isEqualTo(JsonAssertions.json((Object)"[{\"c\": 2}, {\"b\": 1} ,{\"d\": 1}]"))).satisfies(new ThrowingConsumer[]{e -> {
            List failures = e.getFailures();
            Assertions.assertThat((String)((Throwable)failures.get(0)).getMessage()).isEqualTo("Different value found when comparing expected array element a[0] to actual element a[1].");
            Assertions.assertThat((String)((Throwable)failures.get(1)).getMessage()).isEqualTo("Different value found in node \"a[1].c\", expected: <2> but was: <1>.");
        }});
    }

    @Test
    void shouldIgnoreMissingPathEvenIfItIsInExpectedValue() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"foo\":1}}").whenIgnoringPaths(new String[]{"root.bar", "missing"}).isEqualTo((Object)"{\"root\":{\"foo\":1, \"bar\":2}, \"missing\":{\"quux\":\"test\"}}");
    }

    @Test
    void shouldIgnoreArrayElement() {
        JsonAssertions.assertThatJson((Object)"{\"root\":[0, 1, 2]}").whenIgnoringPaths(new String[]{"root[1]"}).isEqualTo((Object)"{\"root\":[0, 8, 2]}");
    }

    @Test
    void shouldIgnoreJsonPaths() {
        String expected = "[{\"name\":\"123\",\"age\":2},{\"name\":\"321\",\"age\":5}]";
        String actual = "[{\"name\":\"123\",\"age\":5},{\"name\":\"321\",\"age\":8}]";
        JsonAssertions.assertThatJson((Object)expected).whenIgnoringPaths(new String[]{"$..age"}).isEqualTo((Object)actual);
    }

    @Test
    void arraySimpleIgnoringOrderNotEqualComparison() {
        JsonAssertions.assertThatJson((Object)"{\"a\":[{\"b\": 1}, {\"c\": 1}, {\"d\": 1}]}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).node("a").isArray().isNotEqualTo(JsonAssertions.json((Object)"[{\"c\": 2}, {\"b\": 1} ,{\"d\": 1}]"));
    }

    @Test
    void arraySimpleIgnoringOrderNotEqualComparisonError() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":[{\"b\": 1}, {\"c\": 1}, {\"d\": 1}]}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).node("a").isArray().isNotEqualTo(JsonAssertions.json((Object)"[{\"c\": 1}, {\"b\": 1} ,{\"d\": 1}]"))).hasMessage("[Node \"a\"] \nExpecting:\n <[{\"b\":1}, {\"c\":1}, {\"d\":1}]>\nnot to be equal to:\n <[{\"c\":1},{\"b\":1},{\"d\":1}]>\nwhen comparing as JSON with [IGNORING_ARRAY_ORDER]");
    }

    @Test
    void shouldAssertBoolean() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": true}}").node("a.b").isBoolean().isFalse()).hasMessage("[Different value found in node \"a.b\"] \nExpecting value to be false but was true");
    }

    @Test
    void shouldAssertNull() {
        JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": null}}").node("a.b").isNull();
    }

    @Test
    void shouldAssertNullFail() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").node("a.b").isNull()).hasMessage("Node \"a.b\" has invalid type, expected: <null> but was: <1>.");
    }

    @Test
    void shouldAssertNotNull() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": null}}").node("a.b").isNotNull()).hasMessage("Node \"a.b\" has invalid type, expected: <not null> but was: <null>.");
    }

    @Test
    void shouldAssertNotNullChain() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": null}}").node("a").isPresent().node("b").isNotNull()).hasMessage("Node \"a.b\" has invalid type, expected: <not null> but was: <null>.");
    }

    @Test
    void shouldAssertNotNullChaining() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").node("a").isNotNull().node("b").isNumber().isEqualByComparingTo("2")).hasMessage("[Different value found in node \"a.b\"] \nexpected: 2\n but was: 1");
    }

    @Test
    void shouldAssertNotNullChainingSuccess() {
        JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").node("a").isNotNull().node("b").isNumber().isEqualByComparingTo("1");
    }

    @Test
    void shouldAssertUri() {
        ((UriAssert)JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\":\"http://exampl.org?a=1\"}}").node("a.b").isUri().hasScheme("http")).hasParameter("a", "1");
    }

    @Test
    void shouldAssertUriFail() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\":\"test\"}}").node("a.b").isUri().hasScheme("http")).hasMessage("[Different value found in node \"a.b\"] \nExpecting scheme of\n  <test>\nto be:\n  <\"http\">\nbut was:\n  <null>");
    }

    @Test
    void shouldAssertUriFailOnType() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").node("a.b").isUri()).hasMessage("Node \"a.b\" has invalid type, expected: <string> but was: <1>.");
    }

    @Test
    void canNotConfigureAfterAssertion() {
    }

    @Test
    void shouldAssertNotNullMissing() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": null}}").node("a.c").isNotNull()).hasMessage("Different value found in node \"a.c\", expected: <not null> but was: <missing>.");
    }

    @Test
    void shouldAssertObjectFailure() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"true").isObject()).hasMessage("Node \"\" has invalid type, expected: <object> but was: <true>.");
    }

    @Test
    void absentInPathShouldFailOnSimpleJson() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").inPath("$.a.b").isAbsent()).hasMessage("Different value found in node \"$.a.b\", expected: <node to be absent> but was: <1>.");
    }

    @Test
    void absentInPathShouldFailOnArray() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"[{\"b\": 1}, {\"c\": 1}]").inPath("[*].c").isAbsent()).hasMessage("Different value found in node \"$[1].c\", expected: <node to be absent> but was: <[1]>.");
    }

    @Test
    void absentInPathShouldFailOnMultipleMatches() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"[{\"c\": {\"x\": 2}}, {\"b\": {\"x\": 2}}, {\"c\": {\"x\": 2}}]").inPath("$.[*].c").isAbsent()).hasMessage("Different value found in nodes \"[$[0].c, $[2].c]\", expected: <node to be absent> but was: <[{\"x\":2},{\"x\":2}]>.");
    }

    @Test
    void shouldAssertNumber() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1}").node("a").isNumber().isEqualByComparingTo("1");
    }

    @Test
    void shouldAssertAsNumber() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1}").node("a").asNumber().isEqualByComparingTo("1");
    }

    @Test
    protected void shouldAssertInteger() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1}").node("a").isIntegralNumber().isEqualTo(1);
        JsonAssertions.assertThatJson((Object)"{\"a\":10}").node("a").isIntegralNumber();
        JsonAssertions.assertThatJson((Object)"{\"a\":0}").node("a").isIntegralNumber();
        JsonAssertions.assertThatJson((Object)"{\"a\":-10}").node("a").isIntegralNumber();
    }

    @Test
    void shouldAllowNodeInJsonMapAssert() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"data\":{\"id\": \"1234\", \"relationships\": false}}").inPath("$.data").isObject().containsEntry("id", (Object)"1234").node("relationships").isObject()).hasMessage("Node \"$.data.relationships\" has invalid type, expected: <object> but was: <false>.");
    }

    @Test
    protected void shouldAssertIntegerFailure() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":1.0}").node("a").isIntegralNumber()).hasMessage("Node \"a\" has invalid type, expected: <integer> but was: <1.0>.");
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":0.0}").node("a").isIntegralNumber()).hasMessage("Node \"a\" has invalid type, expected: <integer> but was: <0.0>.");
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":10.0}").node("a").isIntegralNumber()).hasMessage("Node \"a\" has invalid type, expected: <integer> but was: <10.0>.");
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":-10.0}").node("a").isIntegralNumber()).hasMessage("Node \"a\" has invalid type, expected: <integer> but was: <-10.0>.");
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":1.1}").node("a").isIntegralNumber()).hasMessage("Node \"a\" has invalid type, expected: <integer> but was: <1.1>.");
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":1e3}").node("a").isIntegralNumber()).hasMessageStartingWith("Node \"a\" has invalid type, expected: <integer> but was:");
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":1e-3}").node("a").isIntegralNumber()).hasMessage("Node \"a\" has invalid type, expected: <integer> but was: <0.001>.");
    }

    @Test
    protected void shouldUseCustomNumberComparator() {
        NumberComparator numberComparator = (expected, actual, tolerance) -> {
            if (expected.scale() == 0 && actual.scale() > 0) {
                return false;
            }
            return expected.compareTo(actual) == 0;
        };
        JsonAssertions.assertThatJson((Object)"{\"a\":1.0}").withConfiguration(c -> c.withNumberComparator(numberComparator)).isEqualTo((Object)"{\"a\":1.00}");
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":1.0}").withConfiguration(c -> c.withNumberComparator(numberComparator)).isEqualTo((Object)"{\"a\":1}")).hasMessage("JSON documents are different:\nDifferent value found in node \"a\", expected: <1> but was: <1.0>.\n");
    }

    @Test
    @Disabled
    protected void shouldAssert1e0() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":1e0}").node("a").isIntegralNumber()).hasMessageStartingWith("Node \"a\" has invalid type, expected: <integer> but was:");
    }

    @Test
    protected void shouldFailOnTrainingToken() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":{}} SOME GARBAGE").isEqualTo((Object)"{\"test\": {}}"));
    }

    @Test
    void arrayExtractingShouldPass() {
        JsonAssertions.assertThatJson((Object)"[\n      {\"id\": 1, \"name\":{\"first\":\"Aaron\"}},\n      {\"id\": 2, \"name\":{\"first\":\"Paul\"}}\n    ]").isArray().extracting(new String[]{"id", "name"}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BigDecimal.valueOf(1L), "{\"first\":\"Aaron\"}"}), Assertions.tuple((Object[])new Object[]{BigDecimal.valueOf(2L), "{\"first\":\"Paul\"}"})});
    }

    @Test
    void arrayExtractingShouldFail() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"[\n      {\"id\": 1, \"name\":{\"first\":\"Aaron\"}},\n      {\"id\": 2, \"name\":{\"first\":\"John\"}}\n    ]").isArray().extracting(new String[]{"id", "name"}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BigDecimal.valueOf(1L), "{\"first\":\"Aaron\"}"}), Assertions.tuple((Object[])new Object[]{BigDecimal.valueOf(2L), "{\"first\":\"Paul\"}"})})).hasMessage("[Node \"\"] \nExpecting ArrayList:\n  [(1, {\"first\":\"Aaron\"}), (2, {\"first\":\"John\"})]\nto contain:\n  [(1, \"{\"first\":\"Aaron\"}\"), (2, \"{\"first\":\"Paul\"}\")]\nbut could not find the following element(s):\n  [(2, \"{\"first\":\"Paul\"}\")]\nwhen comparing values using JsonComparator");
    }

    @Test
    void arrayExtractingShouldFailOnDifferentLengthTuple() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"[\n      {\"id\": 1, \"name\":{\"first\":\"Aaron\"}},\n      {\"id\": 2, \"name\":{\"first\":\"John\"}}\n    ]").isArray().extracting(new String[]{"id", "name"}).contains((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{BigDecimal.valueOf(1L), "{\"first\":\"Aaron\"}", 3}), Assertions.tuple((Object[])new Object[]{BigDecimal.valueOf(2L), "{\"first\":\"John\"}"})})).hasMessage("[Node \"\"] \nExpecting ArrayList:\n  [(1, {\"first\":\"Aaron\"}), (2, {\"first\":\"John\"})]\nto contain:\n  [(1, \"{\"first\":\"Aaron\"}\", 3), (2, \"{\"first\":\"John\"}\")]\nbut could not find the following element(s):\n  [(1, \"{\"first\":\"Aaron\"}\", 3)]\nwhen comparing values using JsonComparator");
    }

    @Test
    void shouldNotParseTwice() {
        String result = "{\"bundles\":[\"http://localhost:33621/rms/framework/bundle/0\"]}";
        JsonAssertions.assertThatJson((Object)result).and(new JsonAssertion[]{JsonAssert::isObject, j -> ((JsonAssert)j.node("bundles").isArray().element(0)).asString().contains(new CharSequence[]{"http://", "/framework/bundle/0"})});
    }

    @Test
    void elementWithTypeAssertShouldWork() {
        String result = "{\"bundles\":[\"http://localhost:33621/rms/framework/bundle/0\"]}";
        Assertions.assertThatThrownBy(() -> ((JsonAssert)JsonAssertions.assertThatJson((Object)result).node("bundles").isArray().element(0)).isNumber()).hasMessage("Node \"bundles\" element at index 0 has invalid type, expected: <number> but was: <\"http://localhost:33621/rms/framework/bundle/0\">.");
    }

    @Test
    void shouldAssertStringNumber() {
        JsonAssertions.assertThatJson((Object)"{\"a\":\"1\"}").node("a").asNumber().isEqualByComparingTo("1");
    }

    @Test
    void shouldAssertStringNumberFailure() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":\"x\"}").node("a").asNumber().isEqualByComparingTo("1")).hasMessage("Node \"a\" can not be converted to number expected: <a number> but was: <\"x\">.");
    }

    @Test
    protected void shouldDiffCloseNumbers() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"result\":{\"a\": 0.299999999999999988897769753748434595763683319091796875}}").isEqualTo((Object)"{result: {a: 0.3}}"));
    }

    @Test
    void containsValue() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\": 1}").isObject().containsKey((Object)"lastModified2")).hasMessage("[Different value found in node \"\"] \nExpecting actual:\n  {\"a\":1}\nto contain key:\n  \"lastModified2\"");
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\": 1}").isObject().contains(new Map.Entry[]{Assertions.entry((Object)"lastModified2", null)})).hasMessage("[Different value found in node \"\"] \nExpecting map:\n  {\"a\":1}\nto contain:\n  [\"lastModified2\"=null]\nbut could not find the following map entries:\n  [\"lastModified2\"=null]\n");
    }

    @Test
    void shouldAssertNumberFailure() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":1}").node("a").isNumber().isEqualByComparingTo("2")).hasMessage("[Different value found in node \"a\"] \nexpected: 2\n but was: 1");
    }

    @Test
    void testAssertToleranceSimple() {
        JsonAssertions.assertThatJson((Object)"{\"test\":1.00001}").withTolerance(0.001).isEqualTo((Object)"{\"test\":1}");
    }

    @Test
    void testAssertTolerance() {
        JsonAssertions.assertThatJson((Object)"{\"test\":1.00001}").withConfiguration(c -> c.withTolerance(0.001)).isEqualTo((Object)"{\"test\":1}");
    }

    @Test
    void shouldFailCorrectlyOnMissingNode() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"[{\"a\":\"01\", \"b\":\"text\"}]").node("[0].a").isEqualTo((Object)"\"01\"").node("[0].b").isEqualTo((Object)"text")).hasMessage("JSON documents are different:\nMissing node in path \"[0].a[0].b\".\n").matches(e -> ((AssertionFailedError)e).getActual().getStringRepresentation().equals("<missing>"));
    }

    @Test
    public void shouldAllowUnquotedKeysAndCommentInExpectedValue() {
        JsonAssertions.assertThatJson((Object)"{\"test\":1, \"x\":\"a\"}").isEqualTo((Object)"{//comment\ntest:1, x:'a'}");
    }

    @Test
    void testAssertNode() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)this.readValue("{\"test\":1}")).isEqualTo(this.readValue("{\"test\":2}"))).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testAssertNodeInExpectOnly() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":1}").isEqualTo(this.readValue("{\"test\":2}"))).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testAssertPathWithDescription() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)JsonUtils.jsonSource((Object)"{\"test\":1}", (String)"$")).node("test").isEqualTo((Object)"2")).hasMessage("JSON documents are different:\nDifferent value found in node \"$.test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testPresentWithDescription() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)JsonUtils.jsonSource((Object)"{\"test\":1}", (String)"$")).node("test2").isPresent()).hasMessage("Different value found in node \"$.test2\", expected: <node to be present> but was: <missing>.");
    }

    @Test
    protected void testNotEqualTo() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":1}").isNotEqualTo((Object)"{\"test\": \"${json-unit.any-number}\"}")).hasMessage("\nExpecting actual:\n  {\"test\":1}\nnot to be equal to:\n  \"{\"test\": \"${json-unit.any-number}\"}\"\nwhen comparing values using JsonComparator");
    }

    @Test
    void testAssertPathArray() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[0]").isEqualTo((Object)2)).hasMessage("JSON documents are different:\nDifferent value found in node \"root.test[0]\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testLongRegexp() {
        JsonAssertions.assertThatJson((Object)"{\"test\": \"This is some text followed by: ABCD, followed by this\"}").isEqualTo((Object)"{\"test\": \"${json-unit.regex}^\\\\QThis is some text followed by: \\\\E[A-Z]+\\\\Q, followed by this\\\\E$\"}");
    }

    @Test
    void testLongRegexpBuilder() {
        JsonAssertions.assertThatJson((Object)"{\"test\": \"This is some text followed by: ABCD, followed by this\"}").isEqualTo((Object)("{\"test\": " + String.valueOf(RegexBuilder.regex().str("This is some text followed by: ").exp("[A-Z]+").str(", followed by this")) + "}"));
    }

    @Test
    public void verifyIsArrayContainsString() {
        JsonAssertions.assertThatJson((Object)"{\"id\":\"1\", \"children\":[{\"parentId\":\"1\"}]}").inPath("children[*].parentId").isArray().containsOnly(new Object[]{JsonAssertions.value((Object)"1")});
    }

    @Test
    void testNodeAbsent() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test1\":2, \"test2\":1}").node("test2").isAbsent()).hasMessage("Different value found in node \"test2\", expected: <node to be absent> but was: <1>.");
    }

    @Test
    void testNodeAbsentOk() {
        JsonAssertions.assertThatJson((Object)"{\"test1\":2, \"test2\":1}").node("test3").isAbsent();
    }

    @Test
    void shouldTreatNullAsAbsent() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1, \"b\": null}").when(Option.TREATING_NULL_AS_ABSENT, new Option[0]).node("b").isAbsent();
    }

    @Test
    void shouldNotTreatNullAsAbsent() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":1, \"b\": null}").node("b").isAbsent()).hasMessage("Different value found in node \"b\", expected: <node to be absent> but was: <null>.");
    }

    @Test
    void testNodePresent() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test1\":2, \"test2\":1}").node("test3").isPresent()).hasMessage("Different value found in node \"test3\", expected: <node to be present> but was: <missing>.");
    }

    @Test
    void testNodePresentOk() {
        JsonAssertions.assertThatJson((Object)"{\"test1\":2, \"test2\":1}").node("test2").isPresent();
    }

    @Test
    void testAnd() {
        JsonAssertions.assertThatJson((Object)"{\"test1\":2, \"test2\":1}", (JsonAssertions.JsonAssertionCallback[])new JsonAssertions.JsonAssertionCallback[]{json -> json.inPath("test1").isEqualTo((Object)2), json -> json.inPath("test2").isEqualTo((Object)1)});
    }

    @Test
    void testNodePresentNull() {
        JsonAssertions.assertThatJson((Object)"{\"test1\":2, \"test2\":null}").node("test2").isPresent();
    }

    @Test
    void isPresentShouldTreatNullAsAbsentWhenSpecified() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test1\":2, \"test2\":null}").when(Option.TREATING_NULL_AS_ABSENT, new Option[0]).node("test2").isPresent()).hasMessage("Different value found in node \"test2\", expected: <node to be present> but was: <missing>.");
    }

    @Test
    void testMessage() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":1}").as("Test is different", new Object[0]).isEqualTo((Object)"{\"test\":2}")).hasMessage("[Test is different] JSON documents are different:\nDifferent value found in node \"test\", expected: <2> but was: <1>.\n");
    }

    @Test
    void testIgnoreDifferent() {
        JsonAssertions.assertThatJson((Object)"{\"test\":1}").withConfiguration(c -> c.withIgnorePlaceholder("##IGNORE##")).isEqualTo((Object)"{\"test\":\"##IGNORE##\"}");
    }

    @Test
    void anyNumberShouldFailOnNull() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":null}").isEqualTo((Object)"{\"test\":\"${json-unit.any-number}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a number> but was: <null>.\n");
    }

    @Test
    void anyNumberShouldFailOnObject() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":{\"a\":1}}").isEqualTo((Object)"{\"test\":\"${json-unit.any-number}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <a number> but was: <{\"a\":1}>.\n");
    }

    @Test
    void anyArrayShouldAcceptArray() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[1, 2]}").isEqualTo((Object)"{\"test\":\"${json-unit.any-array}\"}");
    }

    @Test
    void anyArrayShouldFailOnObject() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":{\"a\":1}}").isEqualTo((Object)"{\"test\":\"${json-unit.any-array}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <an array> but was: <{\"a\":1}>.\n");
    }

    @Test
    void anyArrayShouldFailOnNull() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\": null}").isEqualTo((Object)"{\"test\":\"${json-unit.any-array}\"}")).hasMessage("JSON documents are different:\nDifferent value found in node \"test\", expected: <an array> but was: <null>.\n");
    }

    @Test
    void anyBooleanShouldAcceptTrue() {
        JsonAssertions.assertThatJson((Object)"{\"test\":true}").isEqualTo((Object)"{\"test\":\"${json-unit.any-boolean}\"}");
    }

    @Test
    void emptinessCheck() {
        JsonAssertions.assertThatJson((Object)"{\"test\":{}}").node("test").isEqualTo((Object)"{}");
    }

    @Test
    void emptinessCheck2() {
        JsonAssertions.assertThatJson((Object)"{\"test\":{}}").node("test").isObject().isEmpty();
    }

    @Test
    void ifMatcherDoesNotMatchReportDifference() {
        RecordingDifferenceListener listener = new RecordingDifferenceListener();
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":-1}").withMatcher("positive", Matchers.greaterThan((Comparable)BigDecimal.valueOf(0L))).withDifferenceListener((DifferenceListener)listener).isEqualTo((Object)"{\"test\": \"${json-unit.matches:positive}\"}")).hasMessage("JSON documents are different:\nMatcher \"positive\" does not match value -1 in node \"test\". Expected a value greater than <0> but <-1> was less than <0>\n");
        Assertions.assertThat(listener.getDifferenceList()).hasSize(1);
        Assertions.assertThat((String)listener.getDifferenceList().get(0).toString()).isEqualTo("DIFFERENT Expected ${json-unit.matches:positive} in test got -1 in test");
    }

    @Test
    void parametrizedMatcherShouldFail() {
        AbstractJsonAssertTest.DivisionMatcher divisionMatcher = new AbstractJsonAssertTest.DivisionMatcher();
        try {
            JsonAssertions.assertThatJson((Object)"{\"test\":5}").withMatcher("isDivisibleBy", (Matcher)divisionMatcher).isEqualTo((Object)"{\"test\": \"${json-unit.matches:isDivisibleBy}3\"}");
        }
        catch (AssertionError e) {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"JSON documents are different:\nMatcher \"isDivisibleBy\" does not match value 5 in node \"test\". Expected value divisible by <3> but was <5>\n", (Object)((Throwable)((Object)e)).getMessage());
        }
    }

    @Test
    void shoulEscapeDot() {
        JsonAssertions.assertThatJson((Object)"{\"name.with.dot\": \"value\"}").node("name\\.with\\.dot").isEqualTo((Object)"value");
    }

    @Test
    void pathShouldBeIgnoredForExtraKey() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":1, \"ignored\": 1}}").withConfiguration(c -> c.whenIgnoringPaths(new String[]{"root.ignored"})).isEqualTo((Object)"{\"root\":{\"test\":1}}");
    }

    @Test
    void withFailMessageShouldWork() {
        Assertions.assertThatThrownBy(() -> ((JsonAssert)JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").withFailMessage("It's broken", new Object[0])).isEqualTo((Object)"{\"b\": 2}")).hasMessage("It's broken");
    }

    @Test
    void describedAsShouldWork() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": 1}}").describedAs("It's broken", new Object[0]).isEqualTo((Object)"{\"b\": 2}")).hasMessage("[It's broken] JSON documents are different:\nDifferent keys found in node \"\", missing: \"b\", extra: \"a\", expected: <{\"b\":2}> but was: <{\"a\":{\"b\":1}}>\n");
    }

    @Test
    void pathShouldBeIgnoredForDifferentValue() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":1, \"ignored\": 1}}").whenIgnoringPaths(new String[]{"root.ignored"}).isEqualTo((Object)"{\"root\":{\"test\":1, \"ignored\": 2}}");
    }

    @Test
    void pathShouldBeIgnoredForArrayExample() {
        JsonAssertions.assertThatJson((Object)"[{\"a\":1, \"b\":2},{\"a\":1, \"b\":3}]").whenIgnoringPaths(new String[]{"[*].b"}).isEqualTo((Object)"[{\"a\":1, \"b\":0},{\"a\":1, \"b\":0}]");
    }

    @Test
    protected void shouldEqualNumberInObject() {
        TestBean actual = new TestBean(new BigDecimal("2.00"));
        String expected = "{ \"demo\": 2.00 }";
        JsonAssertions.assertThatJson((Object)actual).withTolerance(0.0).isEqualTo((Object)expected);
    }

    @Test
    void testEqualsToArray() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").isEqualTo((Object)new int[]{1, 2, 3});
    }

    @Test
    void assertContainsEntryNumber() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1, \"b\":2.0}").withTolerance(0.0).isObject().containsEntry("a", (Object)1).containsEntry("b", (Object)2);
    }

    @Test
    protected void assertContainsEntryNumberFailure() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":1, \"b\":2.0}").isObject().containsEntry("a", (Object)1).containsEntry("b", (Object)2)).hasMessage("[Different value found in node \"\"] \nExpecting map:\n  {\"a\":1,\"b\":2.0}\nto contain:\n  [\"b\"=2]\nbut could not find the following map entries:\n  [\"b\"=2]\n");
    }

    @Test
    void testEqualsToList() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").isEqualTo(Arrays.asList(1, 2, 3));
    }

    @Test
    void testEqualsToObjectList() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[{\"a\":1}, {\"b\":2}]}").node("test").isEqualTo(Arrays.asList(this.readValue("{\"a\":1}"), this.readValue("{\"b\":2}")));
    }

    @Test
    void testEqualsToDoubleArray() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[1.0,2.0,3.0]}").node("test").isEqualTo((Object)new double[]{1.0, 2.0, 3.0});
    }

    @Test
    void testEqualsToBooleanArray() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[true, false]}").node("test").isEqualTo((Object)new boolean[]{true, false});
    }

    @Test
    void testEqualsToObjectArray() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[{\"a\":1}, {\"b\":2}]}").node("test").isEqualTo((Object)new Object[]{this.readValue("{\"a\":1}"), this.readValue("{\"b\":2}")});
    }

    @Test
    void isArrayShouldFailIfArrayDoesNotExist() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":1}").node("test2").isArray()).hasMessage("Different value found in node \"test2\", expected: <array> but was: <missing>.");
    }

    @Test
    void isArrayShouldFailIfItIsNotArray() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":\"1\"}").node("test").isArray()).hasMessage("Node \"test\" has invalid type, expected: <array> but was: <\"1\">.");
    }

    @Test
    void arrayOfLengthShouldFailOnIncorrectSize() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").isArray().hasSize(2)).hasMessage("[Node \"test\"] \nExpected size: 2 but was: 3 in:\n[1, 2, 3]");
    }

    @Test
    void shouldReportExtraArrayItemsWhenNotIgnoringOrder() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":[1,2,3]}").node("test").isEqualTo((Object)"[1]")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <1> but was: <3>.\nArray \"test\" has different content. Extra values: [2, 3], expected: <[1]> but was: <[1,2,3]>\n");
    }

    @Test
    void shouldReportExtraArrayItemsWhenIgnoringOrder() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":[1,2,3]}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).node("test").isEqualTo((Object)"[1]")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <1> but was: <3>.\nArray \"test\" has different content. Missing values: [], extra values: [2, 3], expected: <[1]> but was: <[1,2,3]>\n");
    }

    @Test
    void shouldReportMissingArrayItemsWhenNotIgnoringOrder() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":[1]}").node("test").isEqualTo((Object)"[1, 2, 3]")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <3> but was: <1>.\nArray \"test\" has different content. Missing values: [2, 3], expected: <[1,2,3]> but was: <[1]>\n");
    }

    @Test
    void shouldReportMissingArrayItemsWhenIgnoringOrder() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":[1]}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).node("test").isEqualTo((Object)"[1, 2, 3]")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <3> but was: <1>.\nArray \"test\" has different content. Missing values: [2, 3], extra values: [], expected: <[1,2,3]> but was: <[1]>\n");
    }

    @Test
    void shouldReportExtraArrayItemsAndDifferencesWhenNotIgnoringOrder() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":[\"x\",\"b\",\"c\"]}").node("test").isEqualTo((Object)"[\"a\"]")).hasMessage("JSON documents are different:\nArray \"test\" has different length, expected: <1> but was: <3>.\nArray \"test\" has different content. Extra values: [\"b\", \"c\"], expected: <[\"a\"]> but was: <[\"x\",\"b\",\"c\"]>\nDifferent value found in node \"test[0]\", expected: <\"a\"> but was: <\"x\">.\n");
    }

    @Test
    void negativeArrayIndexShouldCountBackwards() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[-1]").isEqualTo((Object)3);
    }

    @Test
    void negativeArrayIndexShouldCountBackwardsAndReportFailure() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[-3]").isEqualTo((Object)3)).hasMessage("JSON documents are different:\nDifferent value found in node \"root.test[-3]\", expected: <3> but was: <1>.\n");
    }

    @Test
    void negativeArrayIndexOutOfBounds() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[-5]").isEqualTo((Object)3)).hasMessage("JSON documents are different:\nMissing node in path \"root.test[-5]\".\n");
    }

    @Test
    void positiveArrayIndexOutOfBounds() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":[1,2,3]}}").node("root.test[5]").isEqualTo((Object)3)).hasMessage("JSON documents are different:\nMissing node in path \"root.test[5]\".\n");
    }

    @Test
    void arrayThatContainsShouldFailOnMissingNode() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":[{\"id\":36},{\"id\":37},{\"id\":38}]}").node("test").isArray().contains(new Object[]{"{\"id\":42}"})).hasMessage("[Node \"test\"] \nExpecting JsonList:\n  [{\"id\":36}, {\"id\":37}, {\"id\":38}]\nto contain:\n  [\"{\"id\":42}\"]\nbut could not find the following element(s):\n  [\"{\"id\":42}\"]\nwhen comparing values using JsonComparator");
    }

    @Test
    void testContains() {
        ((JsonListAssert)JsonAssertions.assertThatJson((Object)"[\"foo\", \"bar\", null, false, 1]").isArray().hasSize(5)).contains(new Object[]{"foo", "bar", null, false, BigDecimal.valueOf(1L)});
    }

    @Test
    void arrayContainsShouldMatch() {
        JsonAssertions.assertThatJson((Object)"[{\"a\": 7}, 8]").isArray().containsAnyOf(new Object[]{JsonAssertions.json((Object)"{\"a\": \"${json-unit.any-number}\"}")});
    }

    @Test
    void shouldNotParseValueTwice() {
        JsonAssertions.assertThatJson((Object)"{\"json\": \"{\\\"a\\\" : 1}\"}").node("json").isString().isEqualTo("{\"a\" : 1}");
    }

    @Test
    void regexExample() {
        JsonAssertions.assertThatJson((Object)"{\"test\": \"ABCD\"}").isEqualTo((Object)"{\"test\": \"${json-unit.regex}[A-Z]+\"}");
    }

    @Test
    void pathEscapingWorks() {
        String json = "{\"C:\\\\path\\\\file.ext\": {\"Status\": \"OK\"}}";
        String pomPath = "C:\\path\\file.ext";
        System.out.println("{\"C:\\\\path\\\\file.ext\": {\"Status\": \"OK\"}}");
        JsonAssertions.assertThatJson((Object)"{\"C:\\\\path\\\\file.ext\": {\"Status\": \"OK\"}}").isObject().containsKey((Object)"C:\\path\\file.ext");
        JsonAssertions.assertThatJson((Object)"{\"C:\\\\path\\\\file.ext\": {\"Status\": \"OK\"}}").node("C:\\path\\file.ext".replace(".", "\\.")).isPresent().isObject().contains(new Map.Entry[]{Assertions.entry((Object)"Status", (Object)"OK")});
    }

    @Test
    void testArrayShouldMatchRegardlessOfOrder() {
        String actual = "{\"response\":[{\"attributes\":null,\"empolyees\":[{\"dob\":\"1987-03-21\",\"firstName\":\"Joe\",\"lastName\":\"Doe\"},{\"dob\":\"1986-02-12\",\"firstName\":\"Jason\",\"lastName\":\"Kowalski\"},{\"dob\":\"1985-01-11\",\"firstName\":\"Kate\",\"lastName\":\"Smith\"}],\"id\":123}]}";
        String expected = "{\"response\":[{\"attributes\":null,\"empolyees\":[{\"dob\":\"1985-01-11\",\"firstName\":\"Kate\",\"lastName\":\"Smith\"},{\"dob\":\"1986-02-12\",\"firstName\":\"Jason\",\"lastName\":\"Kowalski\"},{\"dob\":\"1987-03-21\",\"firstName\":\"Joe\",\"lastName\":\"Doe\"}],\"id\":123}]}";
        JsonAssertions.assertThatJson((Object)"{\"response\":[{\"attributes\":null,\"empolyees\":[{\"dob\":\"1987-03-21\",\"firstName\":\"Joe\",\"lastName\":\"Doe\"},{\"dob\":\"1986-02-12\",\"firstName\":\"Jason\",\"lastName\":\"Kowalski\"},{\"dob\":\"1985-01-11\",\"firstName\":\"Kate\",\"lastName\":\"Smith\"}],\"id\":123}]}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)"{\"response\":[{\"attributes\":null,\"empolyees\":[{\"dob\":\"1985-01-11\",\"firstName\":\"Kate\",\"lastName\":\"Smith\"},{\"dob\":\"1986-02-12\",\"firstName\":\"Jason\",\"lastName\":\"Kowalski\"},{\"dob\":\"1987-03-21\",\"firstName\":\"Joe\",\"lastName\":\"Doe\"}],\"id\":123}]}");
    }

    @Test
    void objectShouldMatch() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[{\"value\":1},{\"value\":2},{\"value\":3}]}").node("test").isArray().allSatisfy(v -> JsonAssertions.assertThatJson((Object)v).node("value").isNumber().isLessThan((Comparable)BigDecimal.valueOf(4L)));
    }

    @Test
    void isStringShouldFailIfItIsNotAString() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":1}").node("test").isString()).hasMessage("Node \"test\" has invalid type, expected: <string> but was: <1>.");
    }

    @Test
    void isStringEqualToShouldPass() {
        JsonAssertions.assertThatJson((Object)"{\"test\":\"1\"}").node("test").isString().isEqualTo("1");
    }

    @Test
    void isSimplifiedStringEqualToShouldPass() {
        JsonAssertions.assertThatJson((Object)"{\"test\":\"1\"}").node("test").isStringEqualTo("1");
    }

    @Test
    void testIssue3SpaceStrings() {
        JsonAssertions.assertThatJson((Object)"{\"someKey\":\"a b\"}").node("someKey").isEqualTo((Object)"a b");
    }

    @Test
    void testTreatNullAsAbsent() {
        JsonAssertions.assertThatJson((Object)"{\"test\":{\"a\":1, \"b\": null}}").when(Option.TREATING_NULL_AS_ABSENT, new Option[0]).isEqualTo((Object)"{\"test\":{\"a\":1}}");
    }

    @Test
    void shouldIgnoreExtraFields() {
        JsonAssertions.assertThatJson((Object)"{\"test\":{\"a\":1, \"b\":2, \"c\":3}}").when(Option.IGNORING_EXTRA_FIELDS, new Option[0]).isEqualTo((Object)"{\"test\":{\"b\":2}}");
    }

    @Test
    void shouldIgnoreExtraFieldsAndOrderExample() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[{\"key\":3},{\"key\":2, \"extraField\":2},{\"key\":1}]}").when(Option.IGNORING_EXTRA_FIELDS, new Option[]{Option.IGNORING_ARRAY_ORDER}).isEqualTo((Object)"{\"test\":[{\"key\":1},{\"key\":2},{\"key\":3}]}");
    }

    @Test
    void andFailure() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":{\"a\":1, \"b\":2, \"c\":3}}").and(new JsonAssertion[]{a -> a.node("test").isObject(), a -> a.node("test.b").isEqualTo((Object)3)})).hasMessage("JSON documents are different:\nDifferent value found in node \"test.b\", expected: <3> but was: <2>.\n");
    }

    @Test
    void andSuccess() {
        JsonAssertions.assertThatJson((Object)"{\"test\":{\"a\":1, \"b\":2, \"c\":3}}").and(new JsonAssertion[]{a -> a.node("test").isObject(), a -> a.node("test.b").isEqualTo((Object)2)});
    }

    @Test
    void andNestedFailure() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"test\":{\"a\":1, \"b\":2, \"c\":3}}").node("test").and(new JsonAssertion[]{a -> a.node("a").isEqualTo((Object)1), a -> a.node("b").isEqualTo((Object)3)})).hasMessage("JSON documents are different:\nDifferent value found in node \"test.b\", expected: <3> but was: <2>.\n");
    }

    @Test
    void andNestedSuccess() {
        JsonAssertions.assertThatJson((Object)"{\"test\":{\"a\":1, \"b\":2, \"c\":3}}").node("test").and(new JsonAssertion[]{a -> a.node("a").isEqualTo((Object)1), a -> a.node("b").isEqualTo((Object)2)});
    }

    @Test
    void shouldAcceptEscapedPath() {
        JsonAssertions.assertThatJson((Object)"{\"foo.bar\":\"baz\"}").node("foo\\.bar").isEqualTo((Object)"baz");
    }

    @Test
    void shouldAcceptEscapedPathWithTwoDots() {
        JsonAssertions.assertThatJson((Object)"{\"foo.bar.baz\":\"baz\"}").node("foo\\.bar\\.baz").isEqualTo((Object)"baz");
    }

    @Test
    void shouldAcceptEscapedPathAndShowCorrectErrorMessage() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"foo.bar\":\"boo\"}").node("foo\\.bar").isEqualTo((Object)"baz")).hasMessage("JSON documents are different:\nDifferent value found in node \"foo\\.bar\", expected: <\"baz\"> but was: <\"boo\">.\n");
    }

    @Test
    void testCompareArrays() {
        JsonAssertions.assertThatJson((Object)"[{\"b\": 10}]").isArray().isEqualTo(JsonAssertions.json((Object)"[{\"b\": 10}]"));
    }

    @Test
    void asStringShouldWork() {
        String json = "{\"myNum\": \"1140.53\"}";
        JsonAssertions.assertThatJson((Object)json).node("myNum").asString().isEqualTo("1140.53");
    }

    @Test
    void shouldWorkWithPercentSign() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\": \"1\"}").isEqualTo((Object)"{\"%\": \"2\"}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"\", missing: \"%\", extra: \"a\", expected: <{\"%\":\"2\"}> but was: <{\"a\":\"1\"}>\n");
    }

    @Test
    void shouldIgnoreFields() {
        JsonAssertions.assertThatJson((Object)"{\"root\":{\"test\":1, \"ignored\": 1}}").isObject().isEqualToIgnoringGivenFields((Object)"{\"root\":{\"test\":1, \"ignored\": 2}}", new String[]{"root.ignored"});
    }

    @Test
    void arrayWithStringBooleansShouldBeComparable() {
        JsonAssertions.assertThatJson((Object)"{\"array\": [\"true\"]}").node("array").isArray().containsExactly(new Object[]{JsonAssertions.value((Object)"true")});
    }

    @Test
    void stringArray() {
        ((JsonAssert)JsonAssertions.assertThatJson((Object)"                [\"abc\"]\n").isArray().first()).isEqualTo(JsonAssertions.value((Object)"abc"));
    }

    @Test
    void jsonPathShouldBeAbleToUseObjects() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)json).describedAs("My little assert", new Object[0]).inPath("$.store.book[0]").isEqualTo((Object)"            {\n                \"category\": \"reference\",\n                \"author\": \"Nigel Rees\",\n                \"title\": \"Sayings of the Century\",\n                \"price\": 8.96\n            }")).hasMessage("JSON documents are different:\nDifferent value found in node \"$.store.book[0].price\", expected: <8.96> but was: <8.95>.\n");
    }

    @Test
    void jsonPathWithIgnoredPaths() {
        JsonAssertions.assertThatJson((Object)json).withConfiguration(c -> c.whenIgnoringPaths(new String[]{"$.store.book[*].price"})).inPath("$.store.book[0]").isEqualTo((Object)"            {\n                \"category\": \"reference\",\n                \"author\": \"Nigel Rees\",\n                \"title\": \"Sayings of the Century\",\n                \"price\": 999\n            }");
    }

    @Test
    void ignoredJsonPaths() {
        JsonAssertions.assertThatJson((Object)"{\n     \"category\": \"reference\",\n     \"author\": \"Nigel Rees\",\n     \"title\": \"Sayings of the Century\",\n     \"price\": 1111\n}").withConfiguration(c -> c.whenIgnoringPaths(new String[]{"$..price"})).isEqualTo((Object)"            {\n                \"category\": \"reference\",\n                \"author\": \"Nigel Rees\",\n                \"title\": \"Sayings of the Century\",\n                \"price\": 999\n            }");
    }

    @Test
    public void ignoredJsonPathComplex() {
        JsonAssertions.assertThatJson((Object)"{\"fields\":[{\"key\":1, \"name\":\"AA\"},{\"key\":2, \"name\":\"AB\"},{\"key\":3, \"name\":\"AC\"}]}").whenIgnoringPaths(new String[]{"$.fields[?(@.name=='AA')].key"}).isEqualTo((Object)"{\"fields\":[{\"key\":2, \"name\":\"AA\"},{\"key\":2, \"name\":\"AB\"},{\"key\":3, \"name\":\"AC\"}]}");
    }

    @Test
    void jsonPathWithIgnoredNonexistentPaths() {
        JsonAssertions.assertThatJson((Object)json).withConfiguration(c -> c.whenIgnoringPaths(new String[]{"$.rubbish"})).inPath("$.store.book[0]").isEqualTo((Object)"            {\n                \"category\": \"reference\",\n                \"author\": \"Nigel Rees\",\n                \"title\": \"Sayings of the Century\",\n                \"price\": 8.95\n            }");
    }

    @Test
    void jsonPathWithIgnoredPathsDeep() {
        JsonAssertions.assertThatJson((Object)json).whenIgnoringPaths(new String[]{"$..price"}).withTolerance(0.01).inPath("$.store.book[0]").isEqualTo((Object)"            {\n                \"category\": \"reference\",\n                \"author\": \"Nigel Rees\",\n                \"title\": \"Sayings of the Century\",\n                \"price\": 999\n            }");
    }

    @Test
    void jsonPathWithIgnoredPathsDeepBracketNotation() {
        JsonAssertions.assertThatJson((Object)json).whenIgnoringPaths(new String[]{"$..price"}).inPath("$['store']['book'][0]").isEqualTo((Object)"            {\n                \"category\": \"reference\",\n                \"author\": \"Nigel Rees\",\n                \"title\": \"Sayings of the Century\",\n                \"price\": 999\n            }");
    }

    @Test
    void jsonPathWithNode() {
        JsonAssertions.assertThatJson((Object)json).inPath("$.store.book[0]").node("title").isEqualTo((Object)"Sayings of the Century");
    }

    @Test
    void jsonPathWithNodeError() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)json).inPath("$.store.book[0]").node("title").isEqualTo((Object)"Sayings of the Century2")).hasMessage("JSON documents are different:\nDifferent value found in node \"$.store.book[0].title\", expected: <\"Sayings of the Century2\"> but was: <\"Sayings of the Century\">.\n");
    }

    @Test
    void jsonPathNumber() {
        JsonAssertions.assertThatJson((Object)json).inPath("$..book.length()").isEqualTo((Object)BigDecimal.valueOf(4L));
    }

    @Test
    void booleanArrayExtractionShouldWork() {
        JsonAssertions.assertThatJson((Object)"{\"fields\": [{ \"id\": \"test\", \"value\": \"true\" }]}").inPath("$.fields[?(@.id==\"test\")].value").isArray().containsExactly(new Object[]{JsonAssertions.value((Object)"true")});
    }

    @Test
    void stringComparisonShouldWork() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        map.put("FOO", 4);
        map.put("BAR", 3);
        JsonAssertions.assertThatJson((Object)"{\"fields\": [{ \"id\": \"test\", \"value\": \"{FOO=4, BAR=3}\" }]}").inPath("$.fields[?(@.id==\"test\")].value").isArray().containsExactly(new Object[]{JsonAssertions.value((Object)((Object)map).toString())});
    }

    @Test
    void testAbsentInJsonPath() {
        JsonAssertions.assertThatJson((Object)"{}").inPath("$.abc").isAbsent();
    }

    @Test
    void testAbsentInJsonPathEquals() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{}").inPath("$.abc").isEqualTo((Object)"value")).hasMessage("JSON documents are different:\nMissing node in path \"$.abc\".\n");
    }

    @Test
    void testAbsentInJsonPathIsArray() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{}").inPath("$.abc").isArray()).hasMessage("Different value found in node \"$.abc\", expected: <array> but was: <missing>.");
    }

    @Test
    void testAbsentInJsonPathNotAbsent() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"abc\": 1}").inPath("$.abc").isAbsent()).hasMessage("Different value found in node \"$.abc\", expected: <node to be absent> but was: <1>.");
    }

    @Test
    protected void jsonPathShouldBeAbleToUseArrays() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)json).inPath("$.store.book").isArray().contains(new Object[]{JsonAssertions.json((Object)"            {\n                \"category\": \"reference\",\n                \"author\": \"Nigel Rees\",\n                \"title\": \"Sayings of the Century\",\n                \"price\": 8.96\n            }")})).hasMessage("[Node \"$.store.book\"] \nExpecting JsonList:\n  [{\"author\":\"Nigel Rees\",\"category\":\"reference\",\"price\":8.95,\"title\":\"Sayings of the Century\"},\n    {\"author\":\"Evelyn Waugh\",\"category\":\"fiction\",\"price\":12.99,\"title\":\"Sword of Honour\"},\n    {\"author\":\"Herman Melville\",\"category\":\"fiction\",\"isbn\":\"0-553-21311-3\",\"price\":8.99,\"title\":\"Moby Dick\"},\n    {\"author\":\"J. R. R. Tolkien\",\"category\":\"fiction\",\"isbn\":\"0-395-19395-8\",\"price\":22.99,\"title\":\"The Lord of the Rings\"}]\nto contain:\n  [{\"category\":\"reference\",\"author\":\"Nigel Rees\",\"title\":\"Sayings of the Century\",\"price\":8.96}]\nbut could not find the following element(s):\n  [{\"category\":\"reference\",\"author\":\"Nigel Rees\",\"title\":\"Sayings of the Century\",\"price\":8.96}]\nwhen comparing values using JsonComparator");
    }

    @Test
    void jsonPathShouldBeAbleToUseArraysDeep() {
        JsonAssertions.assertThatJson((Object)json).inPath("$.store.book[*].category").isArray().containsExactlyInAnyOrder(new Object[]{"fiction", "reference", "fiction", "fiction"});
    }

    @Test
    void jsonPathShouldBeAbleToUseArraysFromObject() {
        JsonAssertions.assertThatJson((Object)this.readValue(json)).inPath("$.store.book[*].category").isArray().containsExactlyInAnyOrder(new Object[]{"fiction", "reference", "fiction", "fiction"});
    }

    @Test
    void ignoreExtraArrayItemsExample() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[1,2,3,4]}").when(Option.IGNORING_EXTRA_ARRAY_ITEMS, new Option[0]).isEqualTo((Object)"{\"test\":[1,2,3]}");
    }

    @Test
    void ignoreExtraArrayItemsAndOrderExample() {
        JsonAssertions.assertThatJson((Object)"{\"test\":[5,5,4,4,3,3,2,2,1,1]}").when(Option.IGNORING_EXTRA_ARRAY_ITEMS, new Option[]{Option.IGNORING_ARRAY_ORDER}).isEqualTo((Object)"{\"test\":[1,2,3]}");
    }

    @Test
    void testArrayBug() {
        ((JsonAssert)JsonAssertions.assertThatJson((Object)"[\n      {\"value\": \"1\", \"title\": \"Entity\", \"info\": \"Entity info\"},\n      {\"value\": \"2\", \"title\": \"Column\", \"info\": \"Column info\"},\n      {\"value\": \"3\", \"title\": \"Table\", \"info\": \"Table info\"},\n      {\"value\": \"4\", \"title\": \"Schema\", \"info\": \"Schema info\"}\n    ]").inPath("$[?(@.value =='1')]").isArray().last()).isEqualTo(JsonAssertions.json((Object)"{\"value\": \"1\", \"title\": \"Entity\", \"info\": \"Entity info\"}"));
    }

    @Test
    void testArrayNode() {
        ((JsonAssert)JsonAssertions.assertThatJson((Object)"[\n      {\"value\": \"1\", \"title\": \"Entity\", \"info\": \"Entity info\"},\n      {\"value\": \"2\", \"title\": \"Column\", \"info\": \"Column info\"},\n      {\"value\": \"3\", \"title\": \"Table\", \"info\": \"Table info\"},\n      {\"value\": \"4\", \"title\": \"Schema\", \"info\": \"Schema info\"}\n    ]").inPath("$[?(@.value =='1')]").isArray().first()).node("title").isString().isEqualTo("Entity");
    }

    @Test
    void assertSame() {
        String s = "{ \"a\": 0.0 }";
        JsonAssertions.assertThatJson((Object)s).isEqualTo((Object)s);
    }

    @Test
    void testArrayElements() {
        String json = "[ [ \"a\", \"b\", \"c\", \"d\", \"e\", \"f\", \"g\", \"h\", \"i\" ] ]";
        ((JsonListAssert)JsonAssertions.assertThatJson((Object)json).inPath("$.[0]").isArray().elements(new int[]{3, 4, 5, 6, 7, 8})).containsExactly(new Object[]{"d", "e", "f", "g", "h", "i"});
    }

    @Test
    void testInnerString() {
        String json = "{\"myNode\":{\"inner\":\"foo\"}}";
        JsonAssertions.assertThatJson((Object)json).inPath("$.myNode.inner").isString().isEqualTo("foo");
    }

    @Test
    void testInnerQuotedString() {
        String json = "{\"myNode\":{\"inner\":\"\\\"foo\\\"\"}}";
        JsonAssertions.assertThatJson((Object)json).inPath("$.myNode.inner").isString().isEqualTo("\"foo\"");
    }

    @Test
    void testInnerNumber() {
        String json = "{\"myNode\":{\"inner\":123}}";
        JsonAssertions.assertThatJson((Object)"{\"myNode\":{\"inner\":123}}").inPath("$.myNode.inner").isNumber().isEqualByComparingTo("123");
    }

    @Test
    void shouldUseInPathInAnd() {
        JsonAssert.ConfigurableJsonAssert json = JsonAssertions.assertThatJson((Object)"{\"key1\":\"foo\",\"key2\":\"bar\"}");
        json.inPath("key1").isEqualTo((Object)"foo");
        json.inPath("key2").isEqualTo((Object)"bar");
    }

    @Test
    void shouldIgnoreArrayOrderInSpecificPath() {
        JsonAssertions.assertThatJson((Object)"{\"obj\":{\"a\": [1, 2], \"b\": [3, 4]}}").when(ConfigurationWhen.path((String)"obj.a"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).isEqualTo((Object)"{\"obj\":{\"a\": [2, 1], \"b\": [3, 4]}}");
    }

    @Test
    void shouldNotIgnoreArrayOrderWhenNotSpecified() {
        JsonAssertions.assertThatJson((Object)"{\"obj\":{\"a\": [1, 2], \"b\": [3, 4]}}").when(ConfigurationWhen.path((String)"obj.a"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).isNotEqualTo((Object)"{\"obj\":{\"a\": [2, 1], \"b\": [4, 3]}}");
    }

    @Test
    void shouldExcludeIgnoringArrayOrderFromPath() {
        JsonAssertions.assertThatJson((Object)"[{\"b\":[4,5,6]},{\"b\":[1,2,3]}]").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).when(ConfigurationWhen.path((String)"[*].b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenNot((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).isEqualTo((Object)"[{\"b\":[1,2,3]},{\"b\":[4,5,6]}]");
    }

    @Test
    void shouldIgnoreArrayOrderInSpecificJsonPath() {
        JsonAssertions.assertThatJson((Object)"{\"obj\":{\"a\": [1, 2], \"b\": [3, 4]}}").when(ConfigurationWhen.path((String)"$..a"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).isEqualTo((Object)"{\"obj\":{\"a\": [2, 1], \"b\": [3, 4]}}");
    }

    @Test
    void shouldExcludeIgnoringArrayOrderFromPathAndIgnoreInRoot() {
        JsonAssertions.assertThatJson((Object)"[{\"b\":[4,5,6]},{\"b\":[1,2,3]},{\"b\":[7,8,9]}]").when(ConfigurationWhen.rootPath(), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[]{Option.IGNORING_EXTRA_ARRAY_ITEMS})}).when(ConfigurationWhen.path((String)"[*].b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenNot((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).isEqualTo((Object)"[{\"b\":[1,2,3]},{\"b\":[4,5,6]}]");
    }

    @Test
    void shouldIgnoreArrayOrderEverywhereButTheFirstElement() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"[{\"b\":[1,3,2]},{\"b\":[5,4,6]},{\"b\":[8,7,9]}]").when(ConfigurationWhen.path((String)"[*].b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).when(ConfigurationWhen.path((String)"[0].b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenNot((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).isEqualTo((Object)"[{\"b\":[1,2,3]},{\"b\":[4,5,6]},{\"b\":[7,8,9]}]")).hasMessage("JSON documents are different:\nDifferent value found in node \"[0].b[1]\", expected: <2> but was: <3>.\nDifferent value found in node \"[0].b[2]\", expected: <3> but was: <2>.\n");
    }

    @Test
    void shouldIgnoreArrayOrderInSeveralSpecificPaths() {
        JsonAssertions.assertThatJson((Object)"[{\"b\":[3,1,2],\"c\":[-2,-3,-1]},{\"b\":[6,5,4],\"c\":[-5,-4,-6]}]").when(ConfigurationWhen.paths((String[])new String[]{"[*].b", "[*].c"}), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_ARRAY_ORDER, (Option[])new Option[0])}).isEqualTo((Object)"[{\"b\":[1,2,3],\"c\":[-1,-2,-3]},{\"b\":[4,5,6],\"c\":[-4,-5,-6]}]");
    }

    @Test
    void shouldTreatNullAsAbsentInSpecificPath() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1,\"b\":null}").when(ConfigurationWhen.path((String)"b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0])}).isEqualTo((Object)"{\"a\":1}");
    }

    @Test
    void shouldNotTreatNullAsAbsentWhenNotSpecified() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":1,\"b\":null,\"c\":null}").when(ConfigurationWhen.path((String)"b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0])}).isEqualTo((Object)"{\"a\":1}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"\", extra: \"c\", expected: <{\"a\":1}> but was: <{\"a\":1,\"b\":null,\"c\":null}>\n");
    }

    @Test
    void shouldIgnoreExtraFieldsInSpecificPath() {
        JsonAssertions.assertThatJson((Object)"{\"a\":{\"a1\":1,\"a2\":2}}").when(ConfigurationWhen.path((String)"a"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_EXTRA_FIELDS, (Option[])new Option[0])}).isEqualTo((Object)"{\"a\":{\"a1\":1}}");
    }

    @Test
    void shouldNotIgnoreExtraFieldsWhenNotSpecified() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"a1\":1,\"a2\":2},\"b\":{\"b1\":1,\"b2\":2}}").when(ConfigurationWhen.path((String)"a"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_EXTRA_FIELDS, (Option[])new Option[0])}).isEqualTo((Object)"{\"a\":{\"a1\":1},\"b\":{\"b1\":1}}")).hasMessage("JSON documents are different:\nDifferent keys found in node \"b\", extra: \"b.b2\", expected: <{\"b1\":1}> but was: <{\"b1\":1,\"b2\":2}>\n");
    }

    @Test
    void shouldIgnoreExtraArrayItemsInSpecificPath() {
        JsonAssertions.assertThatJson((Object)"{\"a\":[1,2,3]}").when(ConfigurationWhen.path((String)"a"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0])}).isEqualTo((Object)"{\"a\":[1,2]}");
    }

    @Test
    void shouldUseAsInstanceOfToMoveToJsonUnit() {
        record DummyResponse(String trackingId, String json) {
        }
        DummyResponse resp = new DummyResponse("abcd-0001", "{ \"foo\": \"bar\" }");
        ((JsonAssert.ConfigurableJsonAssert)((ObjectAssert)Assertions.assertThat((Object)resp).hasFieldOrPropertyWithValue("trackingId", (Object)"abcd-0001")).extracting("json").asInstanceOf(JsonAssertions.JSON)).isObject().containsEntry("foo", (Object)"bar");
    }

    @Test
    void shouldUseAsInstanceOfToMoveFromJsonUnit() {
        ((AbstractBigDecimalAssert)JsonAssertions.assertThatJson((Object)"{\"a\":[1, 2, 3]}").inPath("a").isArray().first(InstanceOfAssertFactories.BIG_DECIMAL)).isEqualTo("1");
        ((AbstractBooleanAssert)JsonAssertions.assertThatJson((Object)"{\"a\":[1, 2, true]}").inPath("a").isArray().last(InstanceOfAssertFactories.BOOLEAN)).isEqualTo(true);
        ((AbstractStringAssert)JsonAssertions.assertThatJson((Object)"{\"a\":[1, \"s\", true]}").inPath("a").isArray().element(1, InstanceOfAssertFactories.STRING)).startsWith((CharSequence)"s");
        ((AbstractStringAssert)JsonAssertions.assertThatJson((Object)"{\"a\":{\"b\": \"c\"}}").inPath("a").isObject().extracting("b", InstanceOfAssertFactories.STRING)).endsWith((CharSequence)"c");
        ((ListAssert)JsonAssertions.assertThatJson((Object)"{\"a\":[1, 2, 3]}").inPath("a").asInstanceOf(InstanceOfAssertFactories.LIST)).hasSize(3);
        ((AbstractBigDecimalAssert)((ListAssert)JsonAssertions.assertThatJson((Object)"{\"a\":[1, 2, 3]}").inPath("a").asInstanceOf(InstanceOfAssertFactories.LIST)).first(InstanceOfAssertFactories.BIG_DECIMAL)).isEqualTo("1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\": null}").inPath("a").asInstanceOf(InstanceOfAssertFactories.BIG_DECIMAL)).isInstanceOf(AssertionError.class)).hasMessage("\nExpecting actual not to be null");
    }

    @Test
    void shouldNotIgnoreExtraArrayItemsWhenNotSpecified() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":[1,2,3],\"b\":[1,2,3]}").when(ConfigurationWhen.path((String)"a"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_EXTRA_ARRAY_ITEMS, (Option[])new Option[0])}).isEqualTo((Object)"{\"a\":[1,2],\"b\":[1,2]}")).hasMessage("JSON documents are different:\nArray \"b\" has different length, expected: <2> but was: <3>.\nArray \"b\" has different content. Extra values: [3], expected: <[1,2]> but was: <[1,2,3]>\n");
    }

    @Test
    void shouldIgnoreValuesInSpecificPath() {
        JsonAssertions.assertThatJson((Object)"{\"a\":2,\"b\":\"string2\"}").when(ConfigurationWhen.paths((String[])new String[]{"a", "b"}), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_VALUES, (Option[])new Option[0])}).isEqualTo((Object)"{\"a\":1,\"b\":\"string\"}");
    }

    @Test
    void shouldIgnoreValuesInSpecificPathWrittenSeparately() {
        JsonAssertions.assertThatJson((Object)"{\"a\":2,\"b\":\"string2\"}").when(ConfigurationWhen.path((String)"a"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_VALUES, (Option[])new Option[0])}).when(ConfigurationWhen.path((String)"b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_VALUES, (Option[])new Option[0])}).isEqualTo((Object)"{\"a\":1,\"b\":\"string\"}");
    }

    @Test
    void shouldIgnoreAbsentB() {
        JsonAssertions.assertThatJson((Object)"{\"A\":1,\"B\":null}").when(ConfigurationWhen.path((String)"B"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.TREATING_NULL_AS_ABSENT, (Option[])new Option[0])}).isEqualTo((Object)"{\"A\":1}");
    }

    @Test
    void shouldNotIgnoreValuesWhenNotSpecified() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":2,\"b\":\"string2\",\"c\":3}").when(ConfigurationWhen.paths((String[])new String[]{"a", "b"}), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.then((Option)Option.IGNORING_VALUES, (Option[])new Option[0])}).isEqualTo((Object)"{\"a\":1,\"b\":\"string\",\"c\":2}")).hasMessage("JSON documents are different:\nDifferent value found in node \"c\", expected: <2> but was: <3>.\n");
    }

    @Test
    void shouldIgnoreMultiplePaths() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1,\"b\":2,\"c\":3}").when(ConfigurationWhen.paths((String[])new String[]{"a", "b"}), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenIgnore()}).isEqualTo((Object)"{\"c\":3}");
    }

    @Test
    void shouldIgnoreMultiplePathsWrittenSeparately() {
        JsonAssertions.assertThatJson((Object)"{\"a\":1,\"b\":2,\"c\":3}").when(ConfigurationWhen.path((String)"a"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenIgnore()}).when(ConfigurationWhen.path((String)"b"), new ConfigurationWhen.ApplicableForPath[]{ConfigurationWhen.thenIgnore()}).isEqualTo((Object)"{\"c\":3}");
    }

    @Test
    void shouldFailFast() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\":{\"a1\": 1},\"b\":{\"b1\": 1}}").withOptions(Option.FAIL_FAST, new Option[0]).isEqualTo((Object)"{\"a\":{\"a1\": 2},\"b\":{\"b1\": 2}}")).hasMessage("JSON documents are different:\nDifferent value found in node \"a.a1\", expected: <2> but was: <1>.\n");
    }

    @Test
    void hamcrestMessageTest() {
        Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\n  \"someText\": \"abc123\"\n}\n").withMatcher("exampleMatcher", Matchers.equalTo((Object)"def456")).isEqualTo((Object)"{\n  \"someText\": \"${json-unit.matches:exampleMatcher}\"\n}\n")).hasMessage("JSON documents are different:\nMatcher \"exampleMatcher\" does not match value \"abc123\" in node \"someText\". Expected \"def456\" but was \"abc123\"\n");
    }

    protected abstract Object readValue(String var1);

    private static class TestBean {
        final BigDecimal demo;

        TestBean(BigDecimal demo) {
            this.demo = demo;
        }

        public BigDecimal getDemo() {
            return this.demo;
        }
    }

    @Nested
    protected class ReportAsString {
        protected ReportAsString() {
        }

        @Test
        protected void shouldNormalizeComplexJsons() {
            Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\": {\"c\": [{\"e\": 2, \"f\": 3}, 3]}, \"b\": false}").when(Option.REPORTING_DIFFERENCE_AS_NORMALIZED_STRING, new Option[0]).isEqualTo((Object)"{\"b\": true, \"a\": {\"c\": [{\"f\": 2, \"e\": 3}, 5]}}")).hasMessage("JSON documents are different: expected <{\n  \"b\": true,\n  \"a\": {\n    \"c\": [\n      {\n        \"f\": 2,\n        \"e\": 3\n      },\n      5\n    ]\n  }\n}>but was <{\n  \"b\": false,\n  \"a\": {\n    \"c\": [\n      {\n        \"f\": 3,\n        \"e\": 2\n      },\n      3\n    ]\n  }\n}>");
        }

        @Test
        void shouldPrintMapKeysInTheSameOrderAsExpected() {
            Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"d\": 1, \"c\": 2, \"b\": 3}").when(Option.REPORTING_DIFFERENCE_AS_NORMALIZED_STRING, new Option[0]).isEqualTo((Object)"{\"a\": 1, \"b\": 3, \"c\": 2}")).hasMessage("JSON documents are different: expected <{\n  \"a\": 1,\n  \"b\": 3,\n  \"c\": 2\n}>but was <{\n  \"b\": 3,\n  \"c\": 2,\n  \"d\": 1\n}>");
        }

        @Test
        void shouldPrintMapKeysInTheSameOrderAsInArrays() {
            Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"root\":[{\"d\": 1, \"c\": 2, \"b\": 3}]}").when(Option.REPORTING_DIFFERENCE_AS_NORMALIZED_STRING, new Option[0]).isEqualTo((Object)"{\"root\":[{\"a\": 1, \"b\": 3, \"c\": 2}]}")).hasMessage("JSON documents are different: expected <{\n  \"root\": [\n    {\n      \"a\": 1,\n      \"b\": 3,\n      \"c\": 2\n    }\n  ]\n}>but was <{\n  \"root\": [\n    {\n      \"b\": 3,\n      \"c\": 2,\n      \"d\": 1\n    }\n  ]\n}>");
        }

        @Test
        void shouldNotBreakOnDifferentType() {
            Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\": {\"b\": 1}}").when(Option.REPORTING_DIFFERENCE_AS_NORMALIZED_STRING, new Option[0]).isEqualTo((Object)"{\"a\": [\"b\", 1]}")).hasMessage("JSON documents are different: expected <{\n  \"a\": [\n    \"b\",\n    1\n  ]\n}>but was <{\n  \"a\": {\n    \"b\": 1\n  }\n}>");
        }

        @Test
        void shouldWorkWithMissingPath() {
            Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\": 1}").when(Option.REPORTING_DIFFERENCE_AS_NORMALIZED_STRING, new Option[0]).inPath("c").isEqualTo((Object)"{\"b\": true}")).hasMessage("JSON documents are different:\nMissing node in path \"c\".\n");
        }

        @Test
        void shouldWorkWithPaths() {
            Assertions.assertThatThrownBy(() -> JsonAssertions.assertThatJson((Object)"{\"a\": {\"c\": [{\"e\": 2}, 3]}, \"b\": false}").when(Option.REPORTING_DIFFERENCE_AS_NORMALIZED_STRING, new Option[0]).inPath("a.c").isEqualTo((Object)"[{\"e\": 3}, 5]")).hasMessage("JSON documents are different: expected <[\n  {\n    \"e\": 3\n  },\n  5\n]>but was <[\n  {\n    \"e\": 2\n  },\n  3\n]>");
        }
    }
}

