/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.spring;

import java.math.BigDecimal;
import java.util.function.Consumer;
import java.util.function.Function;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.ConfigurationWhen;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.matchers.InternalMatcher;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import net.javacrumbs.jsonunit.jsonpath.JsonPathAdapter;
import org.hamcrest.Matcher;
import org.jspecify.annotations.Nullable;

abstract class AbstractSpringMatchers<ME, MATCHER> {
    final Configuration configuration;
    final Function<Object, Object> jsonTransformer;

    AbstractSpringMatchers(Configuration configuration, Function<Object, Object> jsonTransformer) {
        this.configuration = configuration;
        this.jsonTransformer = jsonTransformer;
    }

    abstract MATCHER matcher(Consumer<InternalMatcher> var1);

    abstract ME matchers(Configuration var1, Function<Object, Object> var2);

    protected ME matchers(Configuration configuration) {
        return this.matchers(configuration, this.jsonTransformer);
    }

    public ME node(String path) {
        return this.inPath(path);
    }

    public ME inPath(String path) {
        return this.matchers(this.configuration, json -> JsonPathAdapter.inPath((Object)this.jsonTransformer.apply(json), (String)path));
    }

    public ME ignoring(String ignorePlaceholder) {
        return this.matchers(this.configuration.withIgnorePlaceholder(ignorePlaceholder));
    }

    public ME withTolerance(double tolerance) {
        return this.withTolerance(BigDecimal.valueOf(tolerance));
    }

    public ME withMatcher(String matcherName, Matcher<?> matcher) {
        return this.matchers(this.configuration.withMatcher(matcherName, matcher));
    }

    public ME withTolerance(@Nullable BigDecimal tolerance) {
        return this.matchers(this.configuration.withTolerance(tolerance));
    }

    public ME withDifferenceListener(DifferenceListener differenceListener) {
        return this.matchers(this.configuration.withDifferenceListener(differenceListener));
    }

    public ME when(Option firstOption, Option ... otherOptions) {
        return this.matchers(this.configuration.withOptions(firstOption, otherOptions));
    }

    public ME when(ConfigurationWhen.PathsParam object, ConfigurationWhen.ApplicableForPath ... actions) {
        return this.matchers(this.configuration.when(object, actions));
    }

    public MATCHER isEqualTo(@Nullable Object expected) {
        return this.matcher(ctx -> ctx.isEqualTo(expected));
    }

    public MATCHER isStringEqualTo(@Nullable String expected) {
        return this.matcher(ctx -> ctx.isStringEqualTo(expected));
    }

    public MATCHER isNotEqualTo(@Nullable Object expected) {
        return this.matcher(ctx -> ctx.isNotEqualTo(expected));
    }

    public MATCHER isAbsent() {
        return this.matcher(InternalMatcher::isAbsent);
    }

    public MATCHER isPresent() {
        return this.matcher(InternalMatcher::isPresent);
    }

    public MATCHER isArray() {
        return this.matcher(InternalMatcher::isArray);
    }

    public MATCHER isObject() {
        return this.matcher(InternalMatcher::isObject);
    }

    public MATCHER isString() {
        return this.matcher(InternalMatcher::isString);
    }

    public MATCHER isNull() {
        return this.matcher(InternalMatcher::isNull);
    }

    public MATCHER isNotNull() {
        return this.matcher(InternalMatcher::isNotNull);
    }

    public MATCHER matches(Matcher<?> matcher) {
        return this.matcher(ctx -> ctx.matches(matcher));
    }

    public MATCHER isTrue() {
        return this.isEqualTo(true);
    }

    public MATCHER isFalse() {
        return this.isEqualTo(false);
    }
}

