/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.fluent;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class JsonFluentAssert {
    private static final String ACTUAL = "actual";
    final Path path;
    final Object actual;
    final String description;
    final Configuration configuration;

    private JsonFluentAssert(Object actual, Path path, String description, Configuration configuration) {
        if (actual == null) {
            throw new IllegalArgumentException("Can not make assertions about null JSON.");
        }
        this.path = path;
        this.actual = actual;
        this.description = description;
        this.configuration = configuration;
    }

    private JsonFluentAssert(Object actual, String pathPrefix) {
        this(actual, Path.create((String)"", (String)pathPrefix), "", Configuration.empty());
    }

    public static ConfigurableJsonFluentAssert assertThatJson(Object json) {
        return new ConfigurableJsonFluentAssert(JsonUtils.convertToJson((Object)json, (String)ACTUAL), JsonUtils.getPathPrefix((Object)json));
    }

    public JsonFluentAssert isEqualTo(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        diff.failIfDifferent(this.description);
        return this;
    }

    public JsonFluentAssert isStringEqualTo(String expected) {
        this.isString();
        Node node = JsonUtils.getNode((Object)this.actual, (Path)this.path);
        if (!node.asText().equals(expected)) {
            this.failOnDifference(Diff.quoteTextValue((Object)expected), Diff.quoteTextValue((Object)node.asText()));
        }
        return this;
    }

    private void failOnDifference(Object expected, Object actual) {
        this.failWithMessage(String.format("Different value found in node \"%s\", expected: <%s> but was: <%s>.", this.path, expected, actual));
    }

    public JsonFluentAssert isNotEqualTo(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration);
        if (diff.similar()) {
            this.failWithMessage("JSON is equal.");
        }
        return this;
    }

    @Deprecated
    public JsonFluentAssert hasSameStructureAs(Object expected) {
        Diff diff = this.createDiff(expected, this.configuration.withOptions(Option.COMPARING_ONLY_STRUCTURE, new Option[0]));
        diff.failIfDifferent();
        return this;
    }

    public JsonFluentAssert node(String newPath) {
        return new JsonFluentAssert(this.actual, this.path.copy(newPath), this.description, this.configuration);
    }

    private Diff createDiff(Object expected, Configuration configuration) {
        return Diff.create((Object)expected, (Object)this.actual, (String)ACTUAL, (Path)this.path, (Configuration)configuration);
    }

    private void failWithMessage(String message) {
        if (this.description != null && this.description.length() > 0) {
            throw new AssertionError((Object)("[" + this.description + "] " + message));
        }
        throw new AssertionError((Object)message);
    }

    public JsonFluentAssert isAbsent() {
        if (!JsonUtils.nodeAbsent((Object)this.actual, (Path)this.path, (Configuration)this.configuration)) {
            this.failOnDifference("node to be absent", Diff.quoteTextValue((Object)JsonUtils.getNode((Object)this.actual, (Path)this.path)));
        }
        return this;
    }

    public JsonFluentAssert isPresent() {
        return this.isPresent("node to be present");
    }

    private JsonFluentAssert isPresent(String expectedValue) {
        if (JsonUtils.nodeAbsent((Object)this.actual, (Path)this.path, (Configuration)this.configuration)) {
            this.failOnDifference(expectedValue, "missing");
        }
        return this;
    }

    public ArrayAssert isArray() {
        Node node = this.assertType(Node.NodeType.ARRAY);
        return new ArrayAssert(node.arrayElements());
    }

    private Node assertType(Node.NodeType type) {
        this.isPresent(type.getDescription());
        Node node = JsonUtils.getNode((Object)this.actual, (Path)this.path);
        if (node.getNodeType() != type) {
            this.failOnType(node, type);
        }
        return node;
    }

    public void isObject() {
        this.assertType(Node.NodeType.OBJECT);
    }

    public void isString() {
        this.assertType(Node.NodeType.STRING);
    }

    private void failOnType(Node node, Node.NodeType expectedType) {
        this.failWithMessage("Node \"" + this.path + "\" has invalid type, expected: <" + expectedType.getDescription() + "> but was: <" + Diff.quoteTextValue((Object)node.getValue()) + ">.");
    }

    public JsonFluentAssert matches(Matcher<?> matcher) {
        this.isPresent();
        JsonFluentAssert.match(this.actual, this.path, matcher);
        return this;
    }

    private static void match(Object value, Path path, Matcher<?> matcher) {
        Node node = JsonUtils.getNode((Object)value, (Path)path);
        MatcherAssert.assertThat((String)("Node \"" + path + "\" does not match."), (Object)node.getValue(), matcher);
    }

    public static class ConfigurableJsonFluentAssert
    extends JsonFluentAssert {
        private ConfigurableJsonFluentAssert(Object actual, Path path, String description, Configuration configuration) {
            super(actual, path, description, configuration);
        }

        private ConfigurableJsonFluentAssert(Object actual, String pathPrefix) {
            super(actual, pathPrefix);
        }

        @Override
        public ConfigurableJsonFluentAssert node(String newPath) {
            return new ConfigurableJsonFluentAssert(this.actual, this.path.copy(newPath), this.description, this.configuration);
        }

        public ConfigurableJsonFluentAssert whenIgnoringPaths(String ... pathsToBeIgnored) {
            return new ConfigurableJsonFluentAssert(this.actual, this.path, this.description, this.configuration.whenIgnoringPaths(pathsToBeIgnored));
        }

        public ConfigurableJsonFluentAssert as(String description) {
            return this.describedAs(description);
        }

        public ConfigurableJsonFluentAssert describedAs(String description) {
            return new ConfigurableJsonFluentAssert(this.actual, this.path, description, this.configuration);
        }

        public ConfigurableJsonFluentAssert ignoring(String ignorePlaceholder) {
            return new ConfigurableJsonFluentAssert(this.actual, this.path, this.description, this.configuration.withIgnorePlaceholder(ignorePlaceholder));
        }

        public ConfigurableJsonFluentAssert withTolerance(double tolerance) {
            return this.withTolerance(BigDecimal.valueOf(tolerance));
        }

        public ConfigurableJsonFluentAssert withTolerance(BigDecimal tolerance) {
            return new ConfigurableJsonFluentAssert(this.actual, this.path, this.description, this.configuration.withTolerance(tolerance));
        }

        public ConfigurableJsonFluentAssert withMatcher(String matcherName, Matcher<?> matcher) {
            return new ConfigurableJsonFluentAssert(this.actual, this.path, this.description, this.configuration.withMatcher(matcherName, matcher));
        }

        public ConfigurableJsonFluentAssert withDifferenceListener(DifferenceListener differenceListener) {
            return new ConfigurableJsonFluentAssert(this.actual, this.path, this.description, this.configuration.withDifferenceListener(differenceListener));
        }

        public ConfigurableJsonFluentAssert when(Option firstOption, Option ... otherOptions) {
            return new ConfigurableJsonFluentAssert(this.actual, this.path, this.description, this.configuration.withOptions(firstOption, otherOptions));
        }
    }

    public class ArrayAssert {
        private final List<Node> array;

        ArrayAssert(Iterator<Node> array) {
            ArrayList<Node> list = new ArrayList<Node>();
            while (array.hasNext()) {
                list.add(array.next());
            }
            this.array = list;
        }

        public ArrayAssert ofLength(int expectedLength) {
            if (this.array.size() != expectedLength) {
                JsonFluentAssert.this.failWithMessage("Node \"" + JsonFluentAssert.this.path + "\" has invalid length, expected: <" + expectedLength + "> but was: <" + this.array.size() + ">.");
            }
            return this;
        }

        public ArrayAssert thatContains(Object expected) {
            for (Node node : this.array) {
                Diff diff = Diff.create((Object)expected, (Object)node, (String)JsonFluentAssert.ACTUAL, (String)"", (Configuration)JsonFluentAssert.this.configuration);
                if (!diff.similar()) continue;
                return this;
            }
            JsonFluentAssert.this.failWithMessage("Node \"" + JsonFluentAssert.this.path + "\" is '" + this.array.toString() + "', expected to contain '" + expected + "'.");
            return this;
        }

        public ArrayAssert isEmpty() {
            if (!this.array.isEmpty()) {
                JsonFluentAssert.this.failWithMessage("Node \"" + JsonFluentAssert.this.path + "\" is not an empty array.");
            }
            return this;
        }

        public ArrayAssert isNotEmpty() {
            if (this.array.isEmpty()) {
                JsonFluentAssert.this.failWithMessage("Node \"" + JsonFluentAssert.this.path + "\" is an empty array.");
            }
            return this;
        }
    }
}

