/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.fluent;

import com.fasterxml.jackson.databind.JsonNode;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;

public class JsonFluentAssert {
    private static final String EXPECTED = "expected";
    private static final String ACTUAL = "actual";
    private static final String DEFAULT_IGNORE_PLACEHOLDER = "${json-unit.ignore}";
    private final String path;
    private final JsonNode actual;
    private final String description;
    private final String ignorePlaceholder;

    protected JsonFluentAssert(JsonNode actual, String path, String description, String ignorePlaceholder) {
        if (actual == null) {
            throw new IllegalArgumentException("Can not make assertions about null JSON.");
        }
        this.path = path;
        this.actual = actual;
        this.description = description;
        this.ignorePlaceholder = ignorePlaceholder;
    }

    public JsonFluentAssert(JsonNode actual) {
        this(actual, "", "", DEFAULT_IGNORE_PLACEHOLDER);
    }

    public static JsonFluentAssert assertThatJson(JsonNode json) {
        return new JsonFluentAssert(json);
    }

    public static JsonFluentAssert assertThatJson(Object json) {
        return JsonFluentAssert.assertThatJson(JsonUtils.convertToJson((Object)json, (String)ACTUAL));
    }

    public JsonFluentAssert isEqualTo(JsonNode expected) {
        Diff diff = new Diff(expected, this.actual, this.path, this.ignorePlaceholder);
        if (!diff.similar()) {
            this.failWithMessage(diff.differences());
        }
        return this;
    }

    public JsonFluentAssert isEqualTo(Object expected) {
        return this.isEqualTo(JsonUtils.convertToJson((Object)expected, (String)EXPECTED));
    }

    public JsonFluentAssert isNotEqualTo(JsonNode expected) {
        Diff diff = new Diff(expected, this.actual, this.path, this.ignorePlaceholder);
        if (diff.similar()) {
            this.failWithMessage("JSON is equal.");
        }
        return this;
    }

    public JsonFluentAssert isNotEqualTo(Object expected) {
        return this.isNotEqualTo(JsonUtils.convertToJson((Object)expected, (String)EXPECTED));
    }

    public JsonFluentAssert hasSameStructureAs(JsonNode expected) {
        Diff diff = new Diff(expected, this.actual, this.path, this.ignorePlaceholder);
        if (!diff.similarStructure()) {
            this.failWithMessage(diff.structureDifferences());
        }
        return this;
    }

    public JsonFluentAssert hasSameStructureAs(Object expected) {
        return this.hasSameStructureAs(JsonUtils.convertToJson((Object)expected, (String)EXPECTED));
    }

    public JsonFluentAssert node(String path) {
        return new JsonFluentAssert(this.actual, path, this.description, this.ignorePlaceholder);
    }

    private void failWithMessage(String message) {
        if (this.description != null && this.description.length() > 0) {
            throw new AssertionError((Object)("[" + this.description + "] " + message));
        }
        throw new AssertionError((Object)message);
    }

    public JsonFluentAssert as(String description) {
        return this.describedAs(description);
    }

    public JsonFluentAssert describedAs(String description) {
        return new JsonFluentAssert(this.actual, this.path, description, this.ignorePlaceholder);
    }

    public JsonFluentAssert ignoring(String ignorePlaceholder) {
        return new JsonFluentAssert(this.actual, this.path, this.description, ignorePlaceholder);
    }
}

