/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.fluent;

import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;

public class JsonFluentAssert {
    private static final String ACTUAL = "actual";
    private static final String DEFAULT_IGNORE_PLACEHOLDER = "${json-unit.ignore}";
    private final String path;
    private final Object actual;
    private final String description;
    private final String ignorePlaceholder;

    protected JsonFluentAssert(Object actual, String path, String description, String ignorePlaceholder) {
        if (actual == null) {
            throw new IllegalArgumentException("Can not make assertions about null JSON.");
        }
        this.path = path;
        this.actual = actual;
        this.description = description;
        this.ignorePlaceholder = ignorePlaceholder;
    }

    protected JsonFluentAssert(Object actual) {
        this(actual, "", "", DEFAULT_IGNORE_PLACEHOLDER);
    }

    public static JsonFluentAssert assertThatJson(Object json) {
        return new JsonFluentAssert(JsonUtils.convertToJson((Object)json, (String)ACTUAL));
    }

    public JsonFluentAssert isEqualTo(Object expected) {
        Diff diff = this.createDiff(expected);
        if (!diff.similar()) {
            this.failWithMessage(diff.differences());
        }
        return this;
    }

    public JsonFluentAssert isNotEqualTo(Object expected) {
        Diff diff = this.createDiff(expected);
        if (diff.similar()) {
            this.failWithMessage("JSON is equal.");
        }
        return this;
    }

    public JsonFluentAssert hasSameStructureAs(Object expected) {
        Diff diff = this.createDiff(expected);
        if (!diff.similarStructure()) {
            this.failWithMessage(diff.structureDifferences());
        }
        return this;
    }

    public JsonFluentAssert node(String path) {
        return new JsonFluentAssert(this.actual, path, this.description, this.ignorePlaceholder);
    }

    private Diff createDiff(Object expected) {
        return Diff.create((Object)expected, (Object)this.actual, (String)ACTUAL, (String)this.path, (String)this.ignorePlaceholder);
    }

    private void failWithMessage(String message) {
        if (this.description != null && this.description.length() > 0) {
            throw new AssertionError((Object)("[" + this.description + "] " + message));
        }
        throw new AssertionError((Object)message);
    }

    public JsonFluentAssert as(String description) {
        return this.describedAs(description);
    }

    public JsonFluentAssert describedAs(String description) {
        return new JsonFluentAssert(this.actual, this.path, description, this.ignorePlaceholder);
    }

    public JsonFluentAssert ignoring(String ignorePlaceholder) {
        return new JsonFluentAssert(this.actual, this.path, this.description, ignorePlaceholder);
    }
}

