/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.javacrumbs.jsonunit.core.internal.Differences;
import net.javacrumbs.jsonunit.core.internal.ExceptionFactory;
import net.javacrumbs.jsonunit.core.internal.ExceptionUtils;
import net.javacrumbs.jsonunit.core.internal.JsonDifference;
import org.jspecify.annotations.Nullable;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.MultipleFailuresError;

class Opentest4jExceptionFactory
implements ExceptionFactory {
    Opentest4jExceptionFactory() {
    }

    @Override
    public AssertionError createException(@Nullable String message, Differences diffs) {
        List<JsonDifference> differences = diffs.getDifferences();
        if (differences.size() == 1) {
            JsonDifference difference = differences.get(0);
            return new AssertionFailedError(ExceptionUtils.formatDifferences(message, Collections.singletonList(difference)), (Object)difference.getExpected(), (Object)difference.getActual());
        }
        return new JsonAssertError(message, diffs);
    }

    private static class JsonAssertError
    extends MultipleFailuresError {
        private final @Nullable String message;
        private final Differences differences;

        JsonAssertError(@Nullable String message, Differences differences) {
            super(message, differences.getDifferences().stream().map(JsonAssertError::getError).collect(Collectors.toList()));
            this.message = message;
            this.differences = differences;
        }

        private static AssertionFailedError getError(JsonDifference difference) {
            return new AssertionFailedError(difference.getMessage(), difference.getExpected() != null ? difference.getExpected().getValue() : null, difference.getActual() != null ? difference.getActual().getValue() : null);
        }

        public String getMessage() {
            return ExceptionUtils.formatDifferences(this.message, this.differences);
        }
    }
}

