/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.ArrayUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.NodeBuilder;
import org.jspecify.annotations.Nullable;

class GenericNodeBuilder
implements NodeBuilder {
    private static final GenericNodeBuilder INSTANCE = new GenericNodeBuilder();

    GenericNodeBuilder() {
    }

    static Node wrapDeserializedObject(@Nullable Object object) {
        return INSTANCE.newNode(object);
    }

    @Override
    public Node newNode(@Nullable Object object) {
        if (object == null) {
            return new NullNode();
        }
        if (object instanceof Map) {
            return new ObjectNode((Map)object, this);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return new NumberNode(number);
        }
        if (object instanceof String) {
            String string = (String)object;
            return new StringNode(string);
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return new BooleanNode(bool);
        }
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            return new ArrayNode(Arrays.asList(objects), this);
        }
        if (object instanceof int[]) {
            int[] ints = (int[])object;
            return new ArrayNode(ArrayUtils.toIntList(ints), this);
        }
        if (object instanceof double[]) {
            double[] doubles = (double[])object;
            return new ArrayNode(ArrayUtils.toDoubleList(doubles), this);
        }
        if (object instanceof boolean[]) {
            boolean[] booleans = (boolean[])object;
            return new ArrayNode(ArrayUtils.toBoolList(booleans), this);
        }
        if (object instanceof List) {
            return new ArrayNode((List)object, this);
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return node;
        }
        throw new IllegalArgumentException("Unsupported type " + String.valueOf(object.getClass()));
    }

    static class NullNode
    extends NodeSkeleton {
        NullNode() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.NULL;
        }

        public String toString() {
            return "null";
        }
    }

    static final class ObjectNode
    extends NodeSkeleton {
        private final Map<String, Object> jsonObject;
        private final NodeBuilder nodeBuilder;

        ObjectNode(Map<String, Object> jsonObject, NodeBuilder nodeBuilder) {
            this.jsonObject = jsonObject;
            this.nodeBuilder = nodeBuilder;
        }

        @Override
        public Node element(int index) {
            return this.nodeBuilder.newNode(null);
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            final Iterator<String> iterator = this.jsonObject.keySet().iterator();
            return new Iterator<Node.KeyValue>(this){
                final /* synthetic */ ObjectNode this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Node.KeyValue next() {
                    String fieldName = (String)iterator.next();
                    return new Node.KeyValue(fieldName, this.this$0.newNode(fieldName));
                }
            };
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Node get(String key) {
            if (this.jsonObject.containsKey(key)) {
                return this.newNode(key);
            }
            return MISSING_NODE;
        }

        private Node newNode(String fieldName) {
            return this.nodeBuilder.newNode(this.jsonObject.get(fieldName));
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.OBJECT;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            Iterator<Node.KeyValue> entries = this.fields();
            while (entries.hasNext()) {
                Node.KeyValue entry = entries.next();
                builder.append('\"').append(entry.getKey()).append('\"').append(":").append(entry.getValue());
                if (!entries.hasNext()) continue;
                builder.append(",");
            }
            builder.append("}");
            return builder.toString();
        }
    }

    static class NumberNode
    extends NodeSkeleton {
        private final Number value;

        NumberNode(Number value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.NUMBER;
        }

        @Override
        public BigDecimal decimalValue() {
            return new BigDecimal(this.value.toString());
        }

        public String toString() {
            return this.decimalValue().toString();
        }
    }

    static final class StringNode
    extends NodeSkeleton {
        private final String value;

        StringNode(String value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.STRING;
        }

        @Override
        public String asText() {
            return this.value;
        }

        public String toString() {
            return "\"" + this.value + "\"";
        }
    }

    static final class BooleanNode
    extends NodeSkeleton {
        private final Boolean value;

        BooleanNode(Boolean value) {
            this.value = value;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.BOOLEAN;
        }

        @Override
        public Boolean asBoolean() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    static final class ArrayNode
    extends NodeSkeleton {
        private final List<?> value;
        private final NodeBuilder nodeBuilder;

        ArrayNode(List<?> value, NodeBuilder nodeBuilder) {
            this.value = value;
            this.nodeBuilder = nodeBuilder;
        }

        @Override
        public Node.NodeType getNodeType() {
            return Node.NodeType.ARRAY;
        }

        @Override
        public Node element(int index) {
            try {
                return this.newNode(this.value.get(index));
            }
            catch (IndexOutOfBoundsException e) {
                return MISSING_NODE;
            }
        }

        @Override
        public Iterator<Node> arrayElements() {
            final Iterator<?> iterator = this.value.iterator();
            return new Iterator<Node>(this){
                final /* synthetic */ ArrayNode this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Node next() {
                    return this.this$0.newNode(iterator.next());
                }
            };
        }

        private Node newNode(Object object) {
            return this.nodeBuilder.newNode(object);
        }

        @Override
        public int size() {
            return this.value.size();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('[');
            Iterator<Node> iterator = this.arrayElements();
            while (iterator.hasNext()) {
                Node value = iterator.next();
                builder.append(value.toString());
                if (!iterator.hasNext()) continue;
                builder.append(',');
            }
            builder.append(']');
            return builder.toString();
        }
    }

    static abstract class NodeSkeleton
    extends AbstractNode {
        NodeSkeleton() {
        }

        @Override
        public Node element(int index) {
            return MISSING_NODE;
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Node get(String key) {
            return MISSING_NODE;
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isObject() {
            return false;
        }

        @Override
        public boolean isNull() {
            return false;
        }

        @Override
        public Iterator<Node> arrayElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String asText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal decimalValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean asBoolean() {
            throw new UnsupportedOperationException();
        }
    }
}

