/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.util.List;
import net.javacrumbs.jsonunit.core.internal.Differences;
import net.javacrumbs.jsonunit.core.internal.ExceptionFactory;
import net.javacrumbs.jsonunit.core.internal.JsonDifference;
import net.javacrumbs.jsonunit.core.internal.Opentest4jExceptionFactory;
import org.jspecify.annotations.Nullable;

class ExceptionUtils {
    private static final String ROOT_MESSAGE = "JSON documents are different:\n";
    private static final ExceptionFactory exceptionFactory = new Opentest4jExceptionFactory();

    ExceptionUtils() {
    }

    static String formatDifferences(@Nullable String message, Differences differences) {
        return ExceptionUtils.formatDifferences(message, differences.getDifferences());
    }

    static String formatDifferences(@Nullable String message, List<JsonDifference> differences) {
        StringBuilder builder = new StringBuilder();
        if (!differences.isEmpty()) {
            ExceptionUtils.addHeading(message, builder);
            builder.append(ROOT_MESSAGE);
            for (JsonDifference difference : differences) {
                builder.append(difference.getMessage()).append("\n");
            }
        }
        return builder.toString();
    }

    static AssertionError createException(@Nullable String message, Differences diffs) {
        return exceptionFactory.createException(message, diffs);
    }

    private static void addHeading(@Nullable String message, StringBuilder builder) {
        if (message != null && !message.isEmpty()) {
            if (message.startsWith("[") && message.endsWith("] ")) {
                builder.append(message);
            } else {
                builder.append('[').append(message).append("] ");
            }
        }
    }
}

