/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.Reader;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Utils;
import net.javacrumbs.jsonunit.providers.Jackson3ObjectMapperProvider;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.JsonNodeFeature;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.NullNode;

class Jackson3NodeFactory
extends AbstractNodeFactory {
    private final ServiceLoader<Jackson3ObjectMapperProvider> serviceLoader = ServiceLoader.load(Jackson3ObjectMapperProvider.class);

    Jackson3NodeFactory() {
    }

    @Override
    protected Node doConvertValue(Object source) {
        if (source instanceof JsonNode) {
            return Jackson3NodeFactory.newNode((JsonNode)source);
        }
        return Jackson3NodeFactory.newNode((JsonNode)this.getMapper(false).convertValue(source, JsonNode.class));
    }

    @Override
    protected Node nullNode() {
        return Jackson3NodeFactory.newNode((JsonNode)NullNode.getInstance());
    }

    @Override
    protected Node readValue(Reader value, String label, boolean lenient) {
        try {
            Node node = Jackson3NodeFactory.newNode(this.getMapper(lenient).readTree(value));
            return node;
        }
        catch (Exception e) {
            throw this.newParseException(label, value, e);
        }
        finally {
            Utils.closeQuietly(value);
        }
    }

    private ObjectMapper getMapper(boolean lenient) {
        return this.getMapperProvider().getObjectMapper(lenient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jackson3ObjectMapperProvider getMapperProvider() {
        ServiceLoader<Jackson3ObjectMapperProvider> serviceLoader = this.serviceLoader;
        synchronized (serviceLoader) {
            Iterator<Jackson3ObjectMapperProvider> iterator = this.serviceLoader.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return DefaultObjectMapperProvider.INSTANCE;
        }
    }

    private static Node newNode(JsonNode jsonNode) {
        if (jsonNode != null && !jsonNode.isMissingNode()) {
            return new Jackson3Node(jsonNode);
        }
        return Node.MISSING_NODE;
    }

    @Override
    public boolean isPreferredFor(Object source) {
        return source instanceof JsonNode;
    }

    private static class DefaultObjectMapperProvider
    implements Jackson3ObjectMapperProvider {
        static final Jackson3ObjectMapperProvider INSTANCE = new DefaultObjectMapperProvider();
        private static final ObjectMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true)).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true)).configure((DatatypeFeature)JsonNodeFeature.STRIP_TRAILING_BIGDECIMAL_ZEROES, false)).build();
        private static final ObjectMapper lenientMapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_UNQUOTED_PROPERTY_NAMES, true).configure(JsonReadFeature.ALLOW_JAVA_COMMENTS, true).configure(JsonReadFeature.ALLOW_SINGLE_QUOTES, true).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true)).configure((DatatypeFeature)JsonNodeFeature.STRIP_TRAILING_BIGDECIMAL_ZEROES, false)).build();

        private DefaultObjectMapperProvider() {
        }

        @Override
        public ObjectMapper getObjectMapper(boolean lenient) {
            return lenient ? lenientMapper : mapper;
        }
    }

    static final class Jackson3Node
    extends AbstractNode {
        private final JsonNode jsonNode;

        Jackson3Node(JsonNode jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public Node element(int index) {
            return Jackson3NodeFactory.newNode(this.jsonNode.path(index));
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            final Iterator iterator = this.jsonNode.propertyStream().iterator();
            return new Iterator<Node.KeyValue>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Node.KeyValue next() {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    return new Node.KeyValue((String)entry.getKey(), Jackson3NodeFactory.newNode((JsonNode)entry.getValue()));
                }
            };
        }

        @Override
        public Node get(String key) {
            return Jackson3NodeFactory.newNode(this.jsonNode.get(key));
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return this.jsonNode.isNull();
        }

        @Override
        public boolean isObject() {
            return this.jsonNode.isObject();
        }

        @Override
        public Iterator<Node> arrayElements() {
            final Iterator elements = this.jsonNode.iterator();
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return elements.hasNext();
                }

                @Override
                public Node next() {
                    return Jackson3NodeFactory.newNode((JsonNode)elements.next());
                }
            };
        }

        @Override
        public int size() {
            return this.jsonNode.size();
        }

        @Override
        public String asText() {
            return this.jsonNode.asString();
        }

        @Override
        public Node.NodeType getNodeType() {
            return switch (this.jsonNode.getNodeType()) {
                case JsonNodeType.OBJECT -> Node.NodeType.OBJECT;
                case JsonNodeType.ARRAY -> Node.NodeType.ARRAY;
                case JsonNodeType.BOOLEAN -> Node.NodeType.BOOLEAN;
                case JsonNodeType.STRING, JsonNodeType.BINARY -> Node.NodeType.STRING;
                case JsonNodeType.NUMBER -> Node.NodeType.NUMBER;
                case JsonNodeType.NULL -> Node.NodeType.NULL;
                default -> throw new IllegalStateException("Unexpected node type " + String.valueOf(this.jsonNode));
            };
        }

        @Override
        public BigDecimal decimalValue() {
            return this.jsonNode.decimalValue();
        }

        @Override
        public Boolean asBoolean() {
            return this.jsonNode.asBoolean();
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

